/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.rse.ui.SystemPropertyResources;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.view.SystemDecoratingLabelProvider;
import org.eclipse.rse.ui.view.SystemTableView;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SystemTablePrintAction
extends SystemBaseAction {
    private int[] _columnWidths = null;
    private int[] _columnAlignments = null;
    private boolean bPrintSelection;
    private boolean bPageRange;
    private int endLine;
    private int bottomMargin = 100;
    private int leftMargin = 100;
    private int rightMargin = 100;
    private int topMargin = 100;
    private String sPrintOutputName = null;
    private String sPageTitle = null;
    private String sTableTitle = null;
    private String sColumnHeader = null;
    private String sUnderLine = null;
    private String sEndOfListing = null;
    private int pageNumber = 1;
    private boolean startedPage = false;
    int startPage;
    int endPage;
    private int pageHeight;
    private int pageWidth;
    private int x;
    private int y = 0;
    private int w;
    private int textHeight;
    private Printer printer;
    private boolean bPrintPage;
    private GC g;
    private SystemTableView _viewer = null;
    private String _title = null;
    private boolean _hasColumns = false;

    public SystemTablePrintAction(String title, SystemTableView viewer) {
        super(SystemResources.ACTION_PRINTLIST_LABEL, null);
        this.setToolTipText(SystemResources.ACTION_PRINTLIST_TOOLTIP);
        this.setTableView(title, viewer);
    }

    public void setTableView(String title, SystemTableView viewer) {
        this._title = title;
        this._viewer = viewer;
    }

    public void checkEnabledState() {
        if (this._viewer != null && this._viewer.getInput() != null) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void run() {
        int columnCount;
        DateFormat dateFormatter = DateFormat.getDateTimeInstance(3, 3);
        String sCurrentDate = dateFormatter.format(new Date());
        this.sPageTitle = this.sPrintOutputName = SystemResources.RESID_TABLE_PRINTLIST_TITLE;
        this.sPageTitle = String.valueOf(this.sPageTitle) + sCurrentDate;
        this.sTableTitle = this._title;
        PrintDialog printDialog = new PrintDialog(this._viewer.getShell());
        PrinterData printerData = printDialog.open();
        if (printerData == null) {
            return;
        }
        this.bPrintSelection = (printerData.scope & 2) != 0;
        this.bPageRange = printerData.scope == 1;
        Table table = this._viewer.getTable();
        TableItem[] printItems = table.getItems();
        if (this.bPrintSelection) {
            printItems = table.getSelection();
            this.endLine = printItems.length;
            if (this.endLine == 0) {
                return;
            }
        } else if (this.bPageRange) {
            this.endLine = printItems.length;
            this.startPage = printerData.startPage;
            this.endPage = printerData.endPage;
            if (this.endPage < this.startPage) {
                return;
            }
        }
        this.printer = new Printer(printerData);
        if (!this.printer.startJob(this.sPrintOutputName)) {
            this.printer.dispose();
            return;
        }
        Rectangle clientArea = this.printer.getClientArea();
        this.pageHeight = clientArea.height;
        this.pageWidth = clientArea.width;
        this.g = new GC((Drawable)this.printer);
        this.textHeight = this.g.getFontMetrics().getHeight();
        this.pageNumber = 1;
        this.startedPage = false;
        int scaleFactor = 1;
        Rectangle tableClientArea = table.getClientArea();
        int tableWidth = tableClientArea.width - 5;
        if (tableWidth > this.pageWidth) {
            scaleFactor = tableWidth / this.pageWidth;
        }
        this._hasColumns = (columnCount = table.getColumnCount()) > 1;
        this.getColumnInfo(scaleFactor);
        this.sColumnHeader = this.getColumnHeader();
        this.sUnderLine = this.getHeaderSeparator();
        this.sEndOfListing = this.getTableFooter();
        int i = 0;
        while (i < printItems.length) {
            TableItem item = printItems[i];
            Object data = item.getData();
            String line = this.getLine(data, columnCount);
            this.printLine(line);
            ++i;
        }
        this.printLine(" ");
        this.printLine(this.sEndOfListing);
        this.g.dispose();
        this.printer.endJob();
        this.printer.dispose();
        System.gc();
    }

    private void printLine(String text) {
        do {
            if (!this.startedPage) {
                this.bPrintPage = this.bPageRange ? this.pageNumber >= this.startPage && this.pageNumber <= this.endPage : true;
                this.startedPage = true;
                this.x = this.leftMargin;
                this.y = this.topMargin;
                if (this.bPrintPage) {
                    this.printer.startPage();
                    this.g.drawString(String.valueOf(this.sPageTitle) + this.pageNumber, this.x, this.y);
                    this.y += this.textHeight * 2;
                    this.g.drawString(this.sTableTitle, this.x, this.y);
                    this.y += this.textHeight * 2;
                    this.g.drawString(this.sColumnHeader, this.x, this.y);
                    this.y += this.textHeight;
                    this.g.drawString(this.sUnderLine, this.x, this.y);
                    this.y += this.textHeight;
                } else {
                    this.y = this.topMargin + this.textHeight * 6;
                }
                ++this.pageNumber;
            }
            this.x = this.leftMargin;
            if (text != null) {
                int l = text.length();
                while (l > 0) {
                    this.w = this.g.stringExtent((String)text.substring((int)0, (int)l)).x;
                    if (this.x + this.w <= this.pageWidth - this.rightMargin) break;
                    --l;
                }
                String remainingText = null;
                if (l > 0 && l < text.length()) {
                    remainingText = text.substring(l);
                    text = text.substring(0, l);
                }
                if (this.bPrintPage) {
                    this.g.drawString(text, this.x, this.y);
                }
                text = remainingText;
            }
            this.y += this.textHeight;
            if (this.y + this.textHeight <= this.pageHeight - this.bottomMargin) continue;
            if (this.bPrintPage) {
                this.printer.endPage();
            }
            this.startedPage = false;
        } while (text != null);
    }

    private void getColumnInfo(int scaleFactor) {
        Table table = this._viewer.getTable();
        this._hasColumns = table.getColumnCount() > 1;
        if (this._hasColumns) {
            this._columnWidths = new int[table.getColumnCount()];
            this._columnAlignments = new int[table.getColumnCount()];
            int i = 0;
            while (i < table.getColumnCount()) {
                TableColumn column = table.getColumn(i);
                int width = column.getWidth();
                this._columnWidths[i] = width / 9;
                this._columnAlignments[i] = column.getAlignment();
                ++i;
            }
        }
    }

    private String getColumnHeader() {
        StringBuffer sbColumnHeader = new StringBuffer("");
        sbColumnHeader.append(this.getBlankLine());
        if (this._hasColumns) {
            IPropertyDescriptor[] descriptors = this._viewer.getVisibleDescriptors(this._viewer.getInput());
            sbColumnHeader.insert(0, SystemPropertyResources.RESID_PROPERTY_NAME_LABEL);
            int offset = this._columnWidths[0];
            sbColumnHeader.insert(offset, " ");
            ++offset;
            int i = 0;
            while (i < descriptors.length) {
                String label = descriptors[i].getDisplayName();
                int columnWidth = this._columnWidths[i + 1];
                int labelWidth = label.length();
                if (this._columnAlignments[i + 1] == 16384) {
                    if (labelWidth > columnWidth) {
                        label = label.substring(0, columnWidth - 3);
                        label = String.valueOf(label) + "...";
                    }
                    sbColumnHeader.insert(offset, label);
                } else {
                    int rightOffset = offset + (columnWidth - labelWidth) - 1;
                    if (rightOffset < offset) {
                        int delta = offset - rightOffset - 3;
                        label = label.substring(0, delta);
                        label = String.valueOf(label) + "...";
                        rightOffset = offset;
                    }
                    sbColumnHeader.insert(rightOffset, label);
                }
                sbColumnHeader.insert(offset += columnWidth, " ");
                ++offset;
                ++i;
            }
        }
        return sbColumnHeader.toString();
    }

    private String getHeaderSeparator() {
        StringBuffer separator = new StringBuffer("");
        if (this._hasColumns) {
            int i = 0;
            while (i < this._columnWidths.length) {
                int width = this._columnWidths[i];
                int t = 0;
                while (t < width) {
                    separator.append("-");
                    ++t;
                }
                separator.append(" ");
                ++i;
            }
        }
        return separator.toString();
    }

    private String getTableFooter() {
        String footer = "           * * * * *   E N D   O F   L I S T I N G   * * * * *";
        return footer;
    }

    private int getTotalWidth() {
        int totalWidth = 0;
        if (this._hasColumns) {
            int i = 0;
            while (i < this._columnWidths.length) {
                totalWidth += this._columnWidths[i];
                ++i;
            }
        } else {
            totalWidth = this.pageWidth;
        }
        return totalWidth;
    }

    private String getBlankLine() {
        StringBuffer blankLine = new StringBuffer();
        int totalWidth = this.getTotalWidth();
        int b = 0;
        while (b < totalWidth) {
            blankLine.append(" ");
            ++b;
        }
        return blankLine.toString();
    }

    private String getLine(Object object, int numColumns) {
        StringBuffer line = new StringBuffer("");
        SystemDecoratingLabelProvider lprovider = (SystemDecoratingLabelProvider)this._viewer.getLabelProvider();
        if (this._hasColumns) {
            line.append(this.getBlankLine());
            int offset = 0;
            int column = 0;
            while (column < numColumns) {
                String columnText = lprovider.getColumnText(object, column);
                int labelWidth = columnText.length();
                int columnWidth = this._columnWidths[column];
                if (this._columnAlignments[column] == 16384) {
                    if (labelWidth > columnWidth) {
                        columnText = columnText.substring(0, columnWidth - 3);
                        columnText = String.valueOf(columnText) + "...";
                    }
                    line.insert(offset, columnText);
                } else {
                    int rightOffset = offset + (columnWidth - labelWidth) - 1;
                    if (rightOffset < offset) {
                        int delta = offset - rightOffset + 3;
                        columnText = columnText.substring(0, labelWidth - delta);
                        columnText = String.valueOf(columnText) + "...";
                        rightOffset = offset;
                    }
                    line.insert(rightOffset, columnText);
                }
                line.insert(offset += columnWidth, " ");
                ++offset;
                ++column;
            }
        } else {
            String columnText = lprovider.getColumnText(object, 0);
            line.append(columnText);
        }
        return line.toString();
    }
}

