/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.StringComparePatternMatcher;
import org.eclipse.rse.ui.SystemPropertyResources;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.dialogs.SystemSelectAnythingDialog;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemTableView;
import org.eclipse.rse.ui.view.SystemTableViewProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class SystemFilterTableDialog
extends SystemPromptDialog
implements KeyListener,
IDoubleClickListener {
    private SystemTableView _viewer;
    private Table table;
    private List _inputs;
    private IAdaptable _currentInput;
    private String _lastFilter;
    private String _lastType;
    private String[] _viewFilterStrings;
    private String[] _typeFilterStrings;
    private ISubSystem _subSystem;
    private Combo _inputText;
    private Button _browseButton;
    private Combo _typeCombo;
    private Combo _filterCombo;
    private String selected = null;
    private boolean _allowInputChange = true;
    static /* synthetic */ Class class$0;

    public SystemFilterTableDialog(Shell shell, String title, ISubSystem subSystem, String input, String[] viewFilterStrings, String[] typeFilterStrings, boolean allowInputChange) {
        super(shell, title);
        this._subSystem = subSystem;
        this.setNeedsProgressMonitor(true);
        this._inputs = new ArrayList();
        this._inputs.add(input);
        this._viewFilterStrings = viewFilterStrings;
        this._typeFilterStrings = typeFilterStrings;
        this._allowInputChange = allowInputChange;
    }

    public SystemFilterTableDialog(Shell shell, String title, ISubSystem subSystem, List inputs, String[] viewFilterStrings, String[] typeFilterStrings, boolean allowInputChange) {
        super(shell, title);
        this._subSystem = subSystem;
        this.setNeedsProgressMonitor(true);
        this._inputs = inputs;
        this._viewFilterStrings = viewFilterStrings;
        this._typeFilterStrings = typeFilterStrings;
        this._allowInputChange = allowInputChange;
    }

    protected ISystemViewElementAdapter getAdatperFor(IAdaptable obj) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ISystemViewElementAdapter)obj.getAdapter((Class)clazz);
    }

    protected Control createInner(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        c.setLayout((Layout)layout);
        layout.numColumns = 1;
        GridData gd = new GridData(1808);
        c.setLayoutData((Object)gd);
        Composite inputC = new Composite(c, 0);
        GridLayout ilayout = new GridLayout();
        inputC.setLayout((Layout)ilayout);
        ilayout.numColumns = this._allowInputChange ? 4 : 3;
        GridData igd = new GridData(1808);
        inputC.setLayoutData((Object)igd);
        SystemWidgetHelpers.createLabel(inputC, "Input");
        this._inputText = new Combo(inputC, 12);
        this._inputText.addListener(13, (Listener)this);
        int i = 0;
        while (i < this._inputs.size()) {
            String input = (String)this._inputs.get(i);
            if (input != null) {
                this._inputText.add(input);
            }
            ++i;
        }
        this._inputText.select(0);
        if (this._allowInputChange) {
            this._browseButton = SystemWidgetHelpers.createPushButton(inputC, SystemResources.BUTTON_BROWSE, this);
        }
        Composite filterC = new Composite(c, 0);
        GridLayout flayout = new GridLayout();
        filterC.setLayout((Layout)flayout);
        flayout.numColumns = 4;
        GridData fgd = new GridData(1808);
        filterC.setLayoutData((Object)fgd);
        SystemWidgetHelpers.createLabel(filterC, SystemPropertyResources.RESID_PROPERTY_TYPE_LABEL);
        this._typeCombo = new Combo(filterC, 12);
        int i2 = 0;
        while (i2 < this._typeFilterStrings.length) {
            if (this._typeFilterStrings[i2] != null) {
                this._typeCombo.add(this._typeFilterStrings[i2]);
            }
            ++i2;
        }
        this._typeCombo.select(0);
        this._typeCombo.addKeyListener((KeyListener)this);
        this._typeCombo.addListener(13, (Listener)this);
        SystemWidgetHelpers.createLabel(filterC, SystemResources.RESID_FILTERSTRING_STRING_LABEL);
        this._filterCombo = SystemWidgetHelpers.createCombo(filterC, this);
        this._filterCombo.setText(this._viewFilterStrings[0]);
        i2 = 0;
        while (i2 < this._viewFilterStrings.length) {
            if (this._viewFilterStrings[i2] != null) {
                this._filterCombo.add(this._viewFilterStrings[i2]);
            }
            ++i2;
        }
        this._filterCombo.addKeyListener((KeyListener)this);
        this.table = new Table(c, 2048);
        this._viewer = new SystemTableView(this.table, this);
        this._viewer.showColumns(false);
        this._viewer.addDoubleClickListener(this);
        TableLayout tlayout = new TableLayout();
        this.table.setLayout((Layout)tlayout);
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(false);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        gridData.widthHint = 200;
        this.table.setLayoutData((Object)gridData);
        this.enableOkButton(false);
        return c;
    }

    protected void initInput() {
        if (this._currentInput == null) {
            String input = (String)this._inputs.get(0);
            try {
                this._currentInput = (IAdaptable)this._subSystem.getObjectWithAbsoluteName(input);
                ISystemViewElementAdapter adapter = this.getAdatperFor(this._currentInput);
                if (adapter != null) {
                    this.applyViewFilter(false);
                    this._viewer.setInput(this._currentInput);
                    this._viewer.refresh();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected void applyViewFilter(boolean refresh) {
        String[] vfilters = new String[1];
        String typeFilter = this._typeCombo.getText().toUpperCase();
        vfilters[0] = this._filterCombo.getText().toUpperCase();
        if (!vfilters[0].endsWith("*")) {
            vfilters[0] = String.valueOf(vfilters[0]) + "*";
        }
        if (this._lastFilter != vfilters[0]) {
            StringComparePatternMatcher matcher = new StringComparePatternMatcher(this._lastFilter != null ? this._lastFilter.toUpperCase() : null);
            if (this._lastFilter == null || !matcher.stringMatches(vfilters[0])) {
                this._lastFilter = vfilters[0];
                this._lastType = typeFilter;
                if (this._currentInput != null) {
                    this.getAdatperFor(this._currentInput).setFilterString(this._lastFilter);
                }
            } else {
                this._lastFilter = vfilters[0];
                this._lastType = typeFilter;
            }
            ((SystemTableViewProvider)this._viewer.getContentProvider()).flushCache();
            String[] tfilters = new String[]{String.valueOf(this._lastFilter) + typeFilter};
            this._viewer.setViewFilters(tfilters);
        } else if (this._lastType != typeFilter) {
            this._lastType = typeFilter;
            String[] tfilters = new String[]{String.valueOf(this._lastFilter) + typeFilter};
            this._viewer.setViewFilters(tfilters);
        }
    }

    protected Control getInitialFocusControl() {
        Display.getCurrent().asyncExec((Runnable)new InitialInputRunnable());
        return this._filterCombo;
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this._typeCombo) {
            this.applyViewFilter(true);
        } else if (source == this._filterCombo) {
            if (this._lastFilter == null || !this._lastFilter.equals(String.valueOf(this._filterCombo.getText()) + "*")) {
                this.applyViewFilter(true);
            }
        } else if (source == this._browseButton) {
            SystemSelectAnythingDialog dlg = new SystemSelectAnythingDialog(this.getShell(), SystemResources.ACTION_SELECT_INPUT_DLG);
            dlg.setInputObject(this._currentInput);
            if (dlg.open() == 0) {
                this._currentInput = (IAdaptable)dlg.getSelectedObject();
                ISystemViewElementAdapter adapter = this.getAdatperFor(this._currentInput);
                String objName = adapter.getAbsoluteName(this._currentInput);
                if (!this._inputs.contains(objName)) {
                    this._inputs.add(0, objName);
                }
                this._inputText.setText(objName);
                this.applyViewFilter(false);
                this._viewer.setInput(this._currentInput);
                this._viewer.refresh();
            }
        } else if (source == this._inputText) {
            int selected = this._inputText.getSelectionIndex();
            String inputStr = (String)this._inputs.get(selected);
            try {
                IAdaptable input = (IAdaptable)this._subSystem.getObjectWithAbsoluteName(inputStr);
                if (input != this._currentInput) {
                    this._currentInput = input;
                    this._inputText.setText(inputStr);
                    this.applyViewFilter(false);
                    this._viewer.setInput(this._currentInput);
                    this._viewer.refresh();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.widget == this._filterCombo) {
            String vfilter = this._filterCombo.getText();
            if (!vfilter.endsWith("*")) {
                vfilter = String.valueOf(vfilter) + "*";
            }
            if (this._lastFilter == null || !this._lastFilter.equals(vfilter)) {
                this.applyViewFilter(true);
                this._filterCombo.clearSelection();
                this._filterCombo.setFocus();
            }
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object element = s.getFirstElement();
        if (element == null) {
            return;
        }
        this.processOK();
        this.close();
    }

    protected boolean processOK() {
        TableItem[] thisRow = this.table.getSelection();
        if (thisRow != null && thisRow.length == 1) {
            this.selected = thisRow[0].getText(0);
        }
        return true;
    }

    public String getSelected() {
        return this.selected;
    }

    class InitialInputRunnable
    implements Runnable {
        InitialInputRunnable() {
        }

        public void run() {
            SystemFilterTableDialog.this.initInput();
        }
    }
}

