/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.rse.ui.GenericMessages;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FileEditorMappingContentProvider;
import org.eclipse.ui.dialogs.FileEditorMappingLabelProvider;

public class SystemSelectFileTypesDialog
extends SystemPromptDialog
implements ISystemMessageLine {
    protected Collection initialSelections;
    protected String instruction;
    protected Object[] result;
    protected CheckboxTableViewer listViewer;
    protected static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    protected static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    protected static final String TYPE_DELIMITER = GenericMessages.TypesFiltering_typeDelimiter;
    protected Text userDefinedText;
    protected IFileEditorMapping[] currentInput;

    public SystemSelectFileTypesDialog(Shell shell) {
        this(shell, new ArrayList());
    }

    public SystemSelectFileTypesDialog(Shell shell, Collection currentTypes) {
        super(shell, GenericMessages.TypesFiltering_title);
        this.initialSelections = currentTypes;
        this.setInstruction(GenericMessages.TypesFiltering_message);
        String id = "org.eclipse.ui.type_filtering_dialog_context";
        this.setHelp(id);
    }

    public SystemSelectFileTypesDialog(Shell shell, String[] currentTypes) {
        this(shell, Arrays.asList(currentTypes));
    }

    protected Control createInner(Composite parent) {
        Composite composite = (Composite)this.createInnerComposite(parent);
        this.createInstructionArea(composite);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.setLabelProvider((IBaseLabelProvider)FileEditorMappingLabelProvider.INSTANCE);
        this.listViewer.setContentProvider((IContentProvider)FileEditorMappingContentProvider.INSTANCE);
        this.addSelectionButtons(composite);
        this.createUserEntryGroup(composite);
        this.initializeViewer();
        if (this.initialSelections != null && !this.initialSelections.isEmpty()) {
            this.checkInitialSelections();
        }
        return composite;
    }

    protected Control getInitialFocusControl() {
        return this.listViewer.getControl();
    }

    private Control createInnerComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        return composite;
    }

    public void setInstruction(String instr) {
        this.instruction = instr;
    }

    protected Label createInstructionArea(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(this.instruction);
        return label;
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        Button selectButton = this.createButton(buttonComposite, 18, SystemResources.RESID_SELECTFILES_SELECTALL_BUTTON_ROOT_LABEL, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemSelectFileTypesDialog.this.listViewer.setAllChecked(true);
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, SystemResources.RESID_SELECTFILES_DESELECTALL_BUTTON_ROOT_LABEL, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemSelectFileTypesDialog.this.listViewer.setAllChecked(false);
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    protected void addUserDefinedEntries(List result) {
        StringTokenizer tokenizer = new StringTokenizer(this.userDefinedText.getText(), TYPE_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            String currentExtension = tokenizer.nextToken().trim();
            if (currentExtension.equals("")) continue;
            if (currentExtension.startsWith("*.")) {
                result.add(currentExtension.substring(2));
                continue;
            }
            if (currentExtension.startsWith(".")) {
                result.add(currentExtension.substring(1));
                continue;
            }
            result.add(currentExtension);
        }
    }

    protected void checkInitialSelections() {
        IFileEditorMapping[] editorMappings = PlatformUI.getWorkbench().getEditorRegistry().getFileEditorMappings();
        ArrayList<String> selectedMappings = new ArrayList<String>();
        int i = 0;
        while (i < editorMappings.length) {
            IFileEditorMapping mapping = editorMappings[i];
            if (this.initialSelections.contains(mapping.getExtension())) {
                this.listViewer.setChecked((Object)mapping, true);
                selectedMappings.add(mapping.getExtension());
            }
            ++i;
        }
        Iterator initialIterator = this.initialSelections.iterator();
        StringBuffer entries = new StringBuffer();
        while (initialIterator.hasNext()) {
            String nextExtension = (String)initialIterator.next();
            if (selectedMappings.contains(nextExtension)) continue;
            entries.append(nextExtension);
            entries.append(',');
        }
        this.userDefinedText.setText(entries.toString());
    }

    private void createUserEntryGroup(Composite parent) {
        Composite userDefinedGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        userDefinedGroup.setLayout((Layout)layout);
        userDefinedGroup.setLayoutData((Object)new GridData(272));
        new Label(userDefinedGroup, 0).setText(GenericMessages.TypesFiltering_otherExtensions);
        this.userDefinedText = new Text(userDefinedGroup, 2052);
        GridData data = new GridData(768);
        this.userDefinedText.setLayoutData((Object)data);
        this.userDefinedText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (event.widget == SystemSelectFileTypesDialog.this.userDefinedText) {
                    SystemSelectFileTypesDialog.this.setPageComplete(SystemSelectFileTypesDialog.this.validateFileType(SystemSelectFileTypesDialog.this.userDefinedText.getText().trim()));
                }
            }
        });
    }

    protected IFileEditorMapping[] getInput() {
        if (this.currentInput == null) {
            ArrayList<IFileEditorMapping> wildcardEditors = new ArrayList<IFileEditorMapping>();
            IFileEditorMapping[] allMappings = PlatformUI.getWorkbench().getEditorRegistry().getFileEditorMappings();
            int i = 0;
            while (i < allMappings.length) {
                if (allMappings[i].getName().equals("*")) {
                    wildcardEditors.add(allMappings[i]);
                }
                ++i;
            }
            this.currentInput = new IFileEditorMapping[wildcardEditors.size()];
            wildcardEditors.toArray(this.currentInput);
        }
        return this.currentInput;
    }

    private void initializeViewer() {
        this.listViewer.setInput((Object)this.getInput());
    }

    protected boolean processOK() {
        if (!this.validateFileType(this.userDefinedText.getText().trim())) {
            return false;
        }
        IFileEditorMapping[] children = this.getInput();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < children.length) {
            IFileEditorMapping element = children[i];
            if (this.listViewer.getChecked((Object)element)) {
                list.add(element.getExtension());
            }
            ++i;
        }
        this.addUserDefinedEntries(list);
        this.setResult(list);
        return true;
    }

    protected void setResult(List newResult) {
        if (newResult == null) {
            this.result = null;
        } else {
            this.result = new Object[newResult.size()];
            newResult.toArray(this.result);
        }
    }

    protected boolean validateFileType(String filename) {
        if (filename.length() == 0) {
            this.clearErrorMessage();
            return true;
        }
        int index = filename.indexOf(46);
        if (index == filename.length() - 1 && (index == 0 || index == 1 && filename.charAt(0) == '*')) {
            this.setErrorMessage(GenericMessages.FileExtension_extensionEmptyMessage);
            return false;
        }
        int startScan = 0;
        if (filename.startsWith("*.")) {
            startScan = 2;
        }
        if ((index = filename.indexOf(42, startScan)) > -1) {
            if (filename.length() == 1) {
                this.setErrorMessage(GenericMessages.FileExtension_extensionEmptyMessage);
                return false;
            }
            if (index != 0 || filename.charAt(1) != '.') {
                this.setErrorMessage(GenericMessages.FileExtension_fileNameInvalidMessage);
                return false;
            }
        }
        this.clearErrorMessage();
        return true;
    }

    public Object[] getResult() {
        return this.result;
    }
}

