/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.filters;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.actions.ISystemAction;
import org.eclipse.rse.ui.actions.SystemSubMenuManager;
import org.eclipse.rse.ui.filters.dialogs.SystemFilterWorkWithFilterPoolsDialog;
import org.eclipse.rse.ui.view.SystemView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class SystemFilterWorkWithFilterPoolsTreeViewer
extends TreeViewer
implements IMenuListener {
    private SystemFilterWorkWithFilterPoolsDialog caller;
    private Shell shell;
    private IAction[] contextMenuActions;
    private MenuManager menuMgr;

    public SystemFilterWorkWithFilterPoolsTreeViewer(Shell shell, SystemFilterWorkWithFilterPoolsDialog caller, Composite arg0) {
        super(arg0);
        this.init(shell, caller);
    }

    public SystemFilterWorkWithFilterPoolsTreeViewer(Shell shell, SystemFilterWorkWithFilterPoolsDialog caller, Composite arg0, int arg1) {
        super(arg0, arg1);
        this.init(shell, caller);
    }

    public SystemFilterWorkWithFilterPoolsTreeViewer(Shell shell, SystemFilterWorkWithFilterPoolsDialog caller, Tree tree) {
        super(tree);
        this.init(shell, caller);
    }

    public void init(Shell shell, SystemFilterWorkWithFilterPoolsDialog caller) {
        this.caller = caller;
        this.shell = shell;
        this.menuMgr = new MenuManager("#PopupMenu");
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = this.menuMgr.createContextMenu((Control)this.getTree());
        this.getTree().setMenu(menu);
    }

    public void setContextMenuActions(IAction[] actions) {
        this.contextMenuActions = actions;
    }

    public void refresh() {
        if (!this.caller.refreshTree()) {
            super.refresh();
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        ISystemAction ourAction = null;
        if (this.contextMenuActions != null) {
            SystemView.createStandardGroups(menu);
            SystemMenuManager ourMenu = new SystemMenuManager(menu);
            int idx = 0;
            while (idx < this.contextMenuActions.length) {
                if (this.contextMenuActions[idx] instanceof ISystemAction) {
                    ourAction = (ISystemAction)this.contextMenuActions[idx];
                    ourMenu.add("group.reorganize", ourAction);
                    if (ourAction instanceof SystemSubMenuManager) {
                        SystemSubMenuManager item = (SystemSubMenuManager)((Object)ourAction);
                        item.setShell(this.shell);
                        item.setSelection(this.getSelection());
                    }
                } else {
                    menu.appendToGroup("group.reorganize", ourAction);
                }
                ++idx;
            }
        }
    }

    protected void menuAdd(MenuManager menu, IAction action) {
        if (action instanceof ISelectionChangedListener) {
            ((ISelectionChangedListener)action).selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
    }
}

