/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.filters.actions;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterString;
import org.eclipse.rse.core.filters.ISystemFilterStringReference;
import org.eclipse.rse.core.subsystems.util.ISubSystemConfigurationAdapter;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.actions.SystemBaseCopyAction;
import org.eclipse.rse.ui.dialogs.SystemRenameSingleDialog;
import org.eclipse.rse.ui.dialogs.SystemSimpleContentElement;
import org.eclipse.rse.ui.filters.SystemFilterUIHelpers;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.validators.ValidatorUniqueString;
import org.eclipse.swt.widgets.Shell;

public class SystemFilterCopyFilterStringAction
extends SystemBaseCopyAction {
    private String promptString = SystemResources.RESID_COPY_PROMPT;
    private SystemSimpleContentElement initialSelectionElement = null;
    private SystemSimpleContentElement root = null;
    private ISystemFilterString[] strings = null;
    static /* synthetic */ Class class$0;

    public SystemFilterCopyFilterStringAction(Shell parent) {
        super(parent, SystemResources.ACTION_COPY_FILTERSTRING_LABEL, 0);
    }

    protected void reset() {
        super.reset();
        this.initialSelectionElement = null;
        this.root = null;
        this.strings = null;
    }

    public void setHelpContextId(String id) {
        this.setHelp(id);
    }

    protected boolean supportsDuplicateFilterStrings(ISystemFilter filter) {
        return filter.isSupportsDuplicateFilterStrings();
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean enable = true;
        Iterator e = selection.iterator();
        while (enable && e.hasNext()) {
            Object selectedObject = e.next();
            if (selectedObject instanceof SystemSimpleContentElement) {
                selectedObject = ((SystemSimpleContentElement)selectedObject).getData();
            }
            if (this.checkObjectType(selectedObject)) continue;
            enable = false;
        }
        return enable;
    }

    public boolean checkObjectType(Object selectedObject) {
        if (selectedObject instanceof ISystemFilterString) {
            ISystemFilterString fs = (ISystemFilterString)selectedObject;
            return fs.isChangable();
        }
        if (selectedObject instanceof ISystemFilterStringReference) {
            ISystemFilterStringReference frs = (ISystemFilterStringReference)selectedObject;
            return frs.getReferencedFilterString().isChangable();
        }
        return false;
    }

    public boolean isValidTargetParent(SystemSimpleContentElement selectedElement) {
        Object data = selectedElement.getData();
        if (data instanceof ISystemFilter) {
            return !((ISystemFilter)data).isPromptable();
        }
        return false;
    }

    protected boolean preCheckForCollision(Shell shell, Object targetContainer, Object oldObject, String oldName) {
        ISystemFilter newFilter = (ISystemFilter)targetContainer;
        if (this.supportsDuplicateFilterStrings(newFilter)) {
            return true;
        }
        ISystemFilterString match = newFilter.getSystemFilterString(oldName);
        if (match != null) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEG1049");
            msg.makeSubstitution((Object)oldName, (Object)newFilter.getName());
            SystemMessageDialog.displayErrorMessage(shell, msg);
        }
        return match == null;
    }

    protected String checkForCollision(Shell shell, IProgressMonitor monitor, Object targetContainer, Object oldObject, String oldName) {
        ISystemFilter newFilter = (ISystemFilter)targetContainer;
        if (this.supportsDuplicateFilterStrings(newFilter)) {
            return oldName;
        }
        String newName = oldName;
        ISystemFilterString match = newFilter.getSystemFilterString(oldName);
        if (match != null) {
            boolean caseSensitive = false;
            ValidatorUniqueString validator = new ValidatorUniqueString(newFilter.getFilterStrings(), caseSensitive);
            SystemRenameSingleDialog dlg = new SystemRenameSingleDialog(shell, true, (Object)match, validator);
            dlg.open();
            newName = !dlg.wasCancelled() ? dlg.getNewName() : null;
        }
        return newName;
    }

    protected boolean doCopy(IProgressMonitor monitor, Object targetContainer, Object oldObject, String newName) throws Exception {
        Object data;
        ISystemFilterString oldFilterString = (ISystemFilterString)oldObject;
        ISystemFilterPoolManager oldMgr = oldFilterString.getSystemFilterPoolManager();
        ISystemFilter targetFilter = (ISystemFilter)targetContainer;
        ISystemFilterString newFilterString = oldMgr.copySystemFilterString(targetFilter, oldFilterString);
        if (this.root != null && newFilterString != null && (data = this.root.getData()) != null && data instanceof TreeViewer) {
            ((TreeViewer)data).refresh();
        }
        return newFilterString != null;
    }

    protected SystemSimpleContentElement getTreeModel() {
        ISystemFilterString firstFilterString = this.getFirstSelectedFilterString();
        ISystemFilterPoolManagerProvider provider = firstFilterString.getProvider();
        return this.getPoolMgrTreeModel(provider, firstFilterString.getSystemFilterPoolManager(), this.getSelectedFilters());
    }

    protected SystemSimpleContentElement getTreeInitialSelection() {
        return this.initialSelectionElement;
    }

    public void setPromptString(String promptString) {
        this.promptString = promptString;
    }

    protected String getPromptString() {
        return this.promptString;
    }

    protected SystemMessage getCopyingMessage() {
        return RSEUIPlugin.getPluginMessage("RSEG1079");
    }

    protected SystemMessage getCopyingMessage(String oldName) {
        return RSEUIPlugin.getPluginMessage("RSEG1080").makeSubstitution((Object)oldName);
    }

    protected Object[] getOldObjects() {
        return this.getSelectedFilterStrings();
    }

    protected String[] getOldNames() {
        this.strings = null;
        ISystemFilterString[] strings = this.getSelectedFilterStrings();
        String[] names = new String[strings.length];
        int idx = 0;
        while (idx < strings.length) {
            names[idx] = strings[idx].getString();
            ++idx;
        }
        return names;
    }

    protected ISystemFilterString[] getSelectedFilterStrings() {
        if (this.strings == null) {
            IStructuredSelection selection = this.getSelection();
            this.strings = new ISystemFilterString[selection.size()];
            Iterator i = selection.iterator();
            int idx = 0;
            while (i.hasNext()) {
                Object next = i.next();
                if (next instanceof SystemSimpleContentElement) {
                    next = ((SystemSimpleContentElement)next).getData();
                }
                this.strings[idx++] = next instanceof ISystemFilterStringReference ? ((ISystemFilterStringReference)next).getReferencedFilterString() : (ISystemFilterString)next;
            }
        }
        return this.strings;
    }

    protected ISystemFilter[] getSelectedFilters() {
        Vector<ISystemFilter> v = new Vector<ISystemFilter>();
        ISystemFilterString[] strings = this.getSelectedFilterStrings();
        int idx = 0;
        while (idx < strings.length) {
            ISystemFilter filter = strings[idx].getParentSystemFilter();
            if (!this.supportsDuplicateFilterStrings(filter) && !SystemFilterCopyFilterStringAction.containsFilter(v, filter)) {
                v.addElement(filter);
            }
            ++idx;
        }
        ISystemFilter[] filters = new ISystemFilter[v.size()];
        int idx2 = 0;
        while (idx2 < v.size()) {
            filters[idx2] = (ISystemFilter)v.elementAt(idx2);
            ++idx2;
        }
        return filters;
    }

    protected ISystemFilterString getFirstSelectedFilterString() {
        Object first = this.getFirstSelection();
        if (first instanceof SystemSimpleContentElement) {
            this.root = ((SystemSimpleContentElement)first).getRoot();
            first = ((SystemSimpleContentElement)first).getData();
        }
        if (first == null) {
            return null;
        }
        if (first instanceof ISystemFilterStringReference) {
            return ((ISystemFilterStringReference)first).getReferencedFilterString();
        }
        if (first instanceof ISystemFilterString) {
            return (ISystemFilterString)first;
        }
        return null;
    }

    protected SystemSimpleContentElement getPoolMgrTreeModel(ISystemFilterPoolManagerProvider poolMgrProvider, ISystemFilterPoolManager poolMgr, ISystemFilter[] filtersToExclude) {
        SystemSimpleContentElement veryRootElement = new SystemSimpleContentElement("Root", (Object)null, null, null);
        veryRootElement.setRenamable(false);
        veryRootElement.setDeletable(false);
        ISystemFilterPoolManager[] mgrs = poolMgrProvider.getSystemFilterPoolManagers();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.core.subsystems.util.ISubSystemConfigurationAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)poolMgrProvider.getAdapter((Class)clazz);
        ImageDescriptor image = adapter.getSystemFilterPoolManagerImage();
        if (mgrs == null || mgrs.length == 0) {
            return veryRootElement;
        }
        ISystemFilter parentFilter = this.getFirstSelectedFilterString().getParentSystemFilter();
        ISystemFilterPool parentFilterPool = parentFilter.getParentFilterPool();
        Vector<SystemSimpleContentElement> veryRootChildren = new Vector<SystemSimpleContentElement>();
        int idx = 0;
        while (idx < mgrs.length) {
            SystemSimpleContentElement mgrElement = new SystemSimpleContentElement(mgrs[idx].getName(), (Object)mgrs[idx], veryRootElement, null);
            mgrElement.setRenamable(false);
            mgrElement.setDeletable(false);
            mgrElement.setImageDescriptor(image);
            Vector elements = new Vector();
            this.populateFilterPoolContentElementVector(poolMgrProvider, mgrs[idx], elements, mgrElement, filtersToExclude, parentFilterPool, parentFilter);
            mgrElement.setChildren(elements);
            veryRootChildren.addElement(mgrElement);
            ++idx;
        }
        veryRootElement.setChildren(veryRootChildren);
        return veryRootElement;
    }

    protected void populateFilterPoolContentElementVector(ISystemFilterPoolManagerProvider poolMgrProvider, ISystemFilterPoolManager mgr, Vector elements, SystemSimpleContentElement parentElement, ISystemFilter[] filtersToExclude, ISystemFilterPool filterPoolToSelect, ISystemFilter filterToSelect) {
        ISystemFilterPool[] pools = mgr.getSystemFilterPools();
        int idx = 0;
        while (idx < pools.length) {
            ISystemFilterPool pool = pools[idx];
            SystemSimpleContentElement cElement = new SystemSimpleContentElement(pool.getName(), (Object)pool, parentElement, null);
            cElement.setImageDescriptor(SystemFilterUIHelpers.getFilterPoolImage(poolMgrProvider, pool));
            Vector childElements = new Vector();
            this.populateFilterContentElementVector(poolMgrProvider, pool, childElements, cElement, filtersToExclude, filterToSelect);
            cElement.setChildren(childElements);
            elements.addElement(cElement);
            if (pool == filterPoolToSelect && this.initialSelectionElement == null) {
                this.initialSelectionElement = cElement;
            }
            ++idx;
        }
    }

    protected void populateFilterContentElementVector(ISystemFilterPoolManagerProvider poolMgrProvider, ISystemFilterPool pool, Vector elements, SystemSimpleContentElement parentElement, ISystemFilter[] filtersToExclude, ISystemFilter filterToSelect) {
        ISystemFilter[] filters = pool.getSystemFilters();
        int idx = 0;
        while (idx < filters.length) {
            ISystemFilter filter = filters[idx];
            if (!(filter.isNonChangable() || filter.isPromptable() || SystemFilterCopyFilterStringAction.containsFilter(filtersToExclude, filter))) {
                SystemSimpleContentElement cElement = new SystemSimpleContentElement(filter.getName(), (Object)filter, parentElement, null);
                cElement.setImageDescriptor(SystemFilterUIHelpers.getFilterImage(poolMgrProvider, filter));
                elements.addElement(cElement);
                if (filterToSelect == filter) {
                    this.initialSelectionElement = cElement;
                }
            }
            ++idx;
        }
    }

    private static boolean containsFilter(ISystemFilter[] filters, ISystemFilter filter) {
        ISystemFilter match = null;
        int idx = 0;
        while (match == null && idx < filters.length) {
            if (filters[idx] == filter) {
                match = filters[idx];
            }
            ++idx;
        }
        return match != null;
    }

    public static boolean containsFilter(Vector filters, ISystemFilter filter) {
        ISystemFilter match = null;
        int idx = 0;
        while (match == null && idx < filters.size()) {
            if (filters.elementAt(idx) == filter) {
                match = (ISystemFilter)filters.elementAt(idx);
            }
            ++idx;
        }
        return match != null;
    }
}

