/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.filters.actions;

import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemSortableSelection;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Shell;

public class SystemFilterMoveDownFilterPoolReferenceAction
extends SystemBaseAction {
    public SystemFilterMoveDownFilterPoolReferenceAction(Shell parent) {
        super(SystemResources.ACTION_MOVEDOWN_LABEL, SystemResources.ACTION_MOVEDOWN_TOOLTIP, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.downIcon"), parent);
        this.allowOnMultipleSelection(true);
        this.setContextMenuGroup("group.reorder");
    }

    public void setHelpContextId(String id) {
        this.setHelp(id);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        ISystemFilterPoolReferenceManager prevMgr = null;
        boolean enable = true;
        Iterator e = selection.iterator();
        while (enable && e.hasNext()) {
            Object selectedObject = e.next();
            ISystemFilterPoolReference filterPoolRef = (ISystemFilterPoolReference)selectedObject;
            if (prevMgr != null) {
                if (prevMgr != filterPoolRef.getFilterPoolReferenceManager()) {
                    enable = false;
                } else {
                    prevMgr = filterPoolRef.getFilterPoolReferenceManager();
                }
            } else {
                prevMgr = filterPoolRef.getFilterPoolReferenceManager();
            }
            if (!enable) continue;
            enable = this.checkObjectType(filterPoolRef);
        }
        return enable;
    }

    public boolean checkObjectType(Object selectedObject) {
        if (!(selectedObject instanceof ISystemFilterPoolReference)) {
            return false;
        }
        ISystemFilterPoolReference filterPoolRef = (ISystemFilterPoolReference)selectedObject;
        ISystemFilterPoolReferenceManager fprMgr = filterPoolRef.getFilterPoolReferenceManager();
        int pos = fprMgr.getSystemFilterPoolReferencePosition(filterPoolRef);
        return pos < fprMgr.getSystemFilterPoolReferenceCount() - 1;
    }

    public void run() {
        IStructuredSelection selections = this.getSelection();
        SystemSortableSelection[] sortableArray = new SystemSortableSelection[selections.size()];
        Iterator i = selections.iterator();
        int idx = 0;
        ISystemFilterPoolReference filterPoolRef = null;
        ISystemFilterPoolReferenceManager fprMgr = null;
        while (i.hasNext()) {
            sortableArray[idx] = new SystemSortableSelection(i.next());
            filterPoolRef = (ISystemFilterPoolReference)sortableArray[idx].getSelectedObject();
            fprMgr = filterPoolRef.getFilterPoolReferenceManager();
            sortableArray[idx].setPosition(fprMgr.getSystemFilterPoolReferencePosition(filterPoolRef));
            ++idx;
        }
        SystemSortableSelection.sortArray(sortableArray);
        ISystemFilterPoolReference[] filterPoolRefs = (ISystemFilterPoolReference[])SystemSortableSelection.getSortedObjects(sortableArray, new ISystemFilterPoolReference[sortableArray.length]);
        if (idx > 0) {
            fprMgr = filterPoolRefs[0].getFilterPoolReferenceManager();
            fprMgr.moveSystemFilterPoolReferences(filterPoolRefs, 1);
        }
    }
}

