/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.messages;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.services.clientserver.messages.IndicatorException;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SystemMessageDialog
extends ErrorDialog
implements Listener {
    private static final int LIST_ITEM_COUNT = 5;
    private Button detailsButton = null;
    private SystemMessage message;
    private Throwable exc;
    private Text list;
    private boolean listCreated = false;
    private int displayMask = 65535;
    private IStatus status;
    private List statusList;
    private int imageId;
    private boolean showDetails = false;
    private String[] buttons = null;
    private int defaultIndex = 0;
    public static final int BUTTON_ID = 1000;
    private int buttonIdPressed;
    private boolean yesNoButtons = false;
    private boolean yesNoCancelButtons = false;
    protected boolean noShowAgainOption;
    protected Button noShowAgainButton;
    protected IPreferenceStore prefStore;
    protected String prefId;
    protected boolean prefValAsSelected;

    public SystemMessageDialog(Shell parentShell, SystemMessage message) {
        this(parentShell, message.getFullMessageID(), message.getLevelOneText(), (IStatus)new MultiStatus(SystemBasePlugin.getBaseDefault().getSymbolicName(), 0, "", (Throwable)new Exception("")), 1048575);
        ((MultiStatus)this.status).add((IStatus)new Status(1, SystemBasePlugin.getBaseDefault().getSymbolicName(), 0, message.getLevelTwoText(), (Throwable)new Exception("")));
        this.statusList = Arrays.asList(this.status.getChildren());
        this.message = message;
        this.initImage(message);
    }

    private SystemMessageDialog(Shell parentShell, String dialogTitle, String message, IStatus status, int displayMask) {
        super(parentShell, dialogTitle, message, status, displayMask);
        this.status = status;
        this.statusList = Arrays.asList(status.getChildren());
        this.displayMask = displayMask;
        this.setShellStyle(67696);
    }

    private void initImage(SystemMessage message) {
        if (message.getIndicator() == 'I' || message.getIndicator() == 'C') {
            this.imageId = 2;
        } else if (message.getIndicator() == 'Q') {
            this.imageId = 4;
        } else if (message.getIndicator() == 'E' || message.getIndicator() == 'U') {
            this.imageId = 1;
        } else if (message.getIndicator() == 'W') {
            this.imageId = 8;
        }
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(id);
            this.close();
        }
        this.buttonIdPressed = id;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.yesNoButtons || this.yesNoCancelButtons || this.message.getIndicator() == 'Q') {
            boolean yesDefault = this.defaultIndex == 0;
            boolean noDefault = this.defaultIndex == 1;
            boolean cancelDefault = this.defaultIndex == 2;
            this.createButton(parent, 2, IDialogConstants.YES_LABEL, yesDefault);
            this.createButton(parent, 3, IDialogConstants.NO_LABEL, noDefault);
            if (this.yesNoCancelButtons) {
                this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, cancelDefault);
            }
            if (yesDefault) {
                this.getButton(2).setFocus();
            } else if (noDefault) {
                this.getButton(3).setFocus();
            } else if (cancelDefault) {
                this.getButton(1).setFocus();
            }
        } else if (this.buttons != null) {
            int i = 0;
            while (i < this.buttons.length) {
                boolean defaultButton = i == this.defaultIndex;
                this.createButton(parent, 1000 + i, this.buttons[i], defaultButton);
                if (defaultButton) {
                    this.getButton(1000 + i).setFocus();
                }
                ++i;
            }
        } else {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.getButton(0).setFocus();
        }
        if (this.status.isMultiStatus() && this.message != null && this.message.getLevelTwoText() != null && this.message.getLevelTwoText().length() > 2) {
            this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
            if (this.showDetails) {
                this.toggleDetailsArea2(parent);
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        GridData data;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        ((GridLayout)composite.getLayout()).numColumns = 2;
        Image image = this.getShell().getDisplay().getSystemImage(this.imageId);
        if (image != null) {
            Label label = new Label(composite, 0);
            image.setBackground(label.getBackground());
            label.setImage(image);
            label.setLayoutData((Object)new GridData(66));
        }
        if (this.message != null) {
            Text messageArea = new Text(composite, 72);
            messageArea.setText(this.message.getLevelOneText());
            data = new GridData(4, 0x1000000, true, true);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            messageArea.setLayoutData((Object)data);
        }
        if (this.noShowAgainOption) {
            Label l = new Label(composite, 0);
            l.setLayoutData((Object)new GridData(64, 4));
            this.noShowAgainButton = this.createNoShowAgainButton(composite);
            data = new GridData(4, 0x1000000, true, true);
            this.noShowAgainButton.setLayoutData((Object)data);
        }
        return composite;
    }

    protected Text createDropDownList2(Composite parent) {
        this.list = new Text(parent, 2632);
        GridData data = new GridData(1808);
        data.heightHint = this.list.getLineHeight() * 5;
        data.widthHint = this.getDialogArea().getSize().x;
        this.list.setLayoutData((Object)data);
        this.listCreated = true;
        this.populateList(this.list);
        return this.list;
    }

    public void setException(Throwable exc) {
        this.exc = exc;
    }

    private void LogMessage() {
        Object[] subList = this.message.getSubVariables();
        int i = 0;
        while (subList != null && i < subList.length) {
            String msg = String.valueOf(this.message.getFullMessageID()) + ": SUB#" + new Integer(i).toString() + ":" + this.message.getSubValue(subList[i]);
            if (this.message.getIndicator() == 'I' || this.message.getIndicator() == 'C' || this.message.getIndicator() == 'Q') {
                SystemBasePlugin.logInfo(msg);
                if (i == subList.length - 1 && this.message.getIndicator() == 'Q') {
                    SystemBasePlugin.logInfo(String.valueOf(this.message.getFullMessageID()) + " :Button ID Pressed:" + this.buttonIdPressed);
                }
            } else if (this.message.getIndicator() == 'W') {
                SystemBasePlugin.logWarning(msg);
            } else if (this.message.getIndicator() == 'E') {
                SystemBasePlugin.logError(msg, null);
            } else if (this.message.getIndicator() == 'U') {
                if (i == subList.length - 1) {
                    SystemBasePlugin.logError(msg, this.exc != null ? this.exc : new Exception());
                } else {
                    SystemBasePlugin.logError(msg, null);
                }
            }
            ++i;
        }
        if (subList == null) {
            String msg = this.message.getFullMessageID();
            if (this.message.getIndicator() == 'I' || this.message.getIndicator() == 'C' || this.message.getIndicator() == 'Q') {
                SystemBasePlugin.logInfo(msg);
            } else if (this.message.getIndicator() == 'W') {
                SystemBasePlugin.logWarning(msg);
            } else if (this.message.getIndicator() == 'E') {
                SystemBasePlugin.logError(msg, null);
            } else if (this.message.getIndicator() == 'U') {
                SystemBasePlugin.logError(msg, this.exc != null ? this.exc : new Exception());
            }
        }
    }

    public int open() {
        if (!this.showDetails) {
            this.LogMessage();
        }
        return super.open();
    }

    public int openWithDetails() {
        this.showDetails = true;
        return this.open();
    }

    public int openWithDetails(Exception exc) {
        this.showDetails = true;
        SystemBasePlugin.logError(this.message.getLevelOneText(), exc);
        return this.open();
    }

    public boolean openQuestion() throws IndicatorException {
        if (this.message.getIndicator() != 'Q') {
            throw new IndicatorException("Message " + this.message.getFullMessageID() + " is not an inquiry message.");
        }
        this.yesNoButtons = true;
        this.open();
        return this.buttonIdPressed == 2;
    }

    public boolean openQuestionNoException() {
        this.yesNoButtons = true;
        this.open();
        return this.buttonIdPressed == 2;
    }

    public int openYesNoCancel() {
        this.yesNoCancelButtons = true;
        return this.open();
    }

    public int getButtonPressedId() {
        return this.buttonIdPressed;
    }

    public void setButtons(String[] buttonList) {
        this.buttons = buttonList;
    }

    public void setButtonIndex(int buttonIndex) {
        this.defaultIndex = buttonIndex;
    }

    private void populateList(Text list) {
        Iterator z = this.statusList.iterator();
        while (z.hasNext()) {
            IStatus childStatus = (IStatus)z.next();
            this.populateList(list, childStatus, 0);
        }
    }

    private void populateList(Text list, IStatus status, int nesting) {
        if (!status.matches(this.displayMask)) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < nesting) {
            sb.append("  ");
            ++i;
        }
        sb.append(status.getMessage());
        list.append(sb.toString());
        IStatus[] children = status.getChildren();
        int i2 = 0;
        while (i2 < children.length) {
            list.append("\n");
            this.populateList(list, children[i2], nesting + 1);
            ++i2;
        }
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        this.getContents().computeSize(-1, -1);
        if (this.listCreated) {
            this.list.dispose();
            this.listCreated = false;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.list = this.createDropDownList2((Composite)this.getContents());
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
        }
        Point newSize = this.getContents().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, newSize.y));
    }

    private void toggleDetailsArea2(Composite composite) {
        Point windowSize = this.getShell().computeSize(-1, -1);
        this.getDialogArea().computeSize(-1, -1);
        this.list = this.createDropDownList2(composite.getParent());
        this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
        Point newSize = composite.getParent().computeSize(-1, -1);
        composite.computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, newSize.y));
    }

    public static Shell getDefaultShell() {
        return Display.getCurrent().getActiveShell();
    }

    public static void displayErrorMessage(Shell shell, SystemMessage msg) {
        SystemMessageDialog msgDlg = new SystemMessageDialog(shell, msg);
        msgDlg.open();
    }

    public static void displayErrorMessage(Shell shell, SystemMessage msg, Exception exc) {
        SystemMessageDialog msgDlg = new SystemMessageDialog(shell, msg);
        msgDlg.setException(exc);
        msgDlg.open();
    }

    public static void displayErrorMessage(Shell shell, String msgText) {
        SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEO1012");
        msg.makeSubstitution((Object)msgText);
        SystemMessageDialog.displayErrorMessage(shell, msg);
    }

    public static void displayMessage(Shell shell, String msgText) {
        SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEO1010");
        msg.makeSubstitution((Object)msgText);
        SystemMessageDialog.displayErrorMessage(shell, msg);
    }

    public static void displayMessage(Shell shell, SystemMessageException msgEx) {
        if (msgEx != null) {
            SystemMessageDialog.displayErrorMessage(shell, msgEx.getSystemMessage());
        }
    }

    public static void displayHostErrorMessage(Shell shell, String hostMsg) {
        SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEO1012");
        msg.makeSubstitution((Object)hostMsg);
        SystemMessageDialog msgDlg = new SystemMessageDialog(shell, msg);
        msgDlg.open();
    }

    public static void displayHostErrorMessage(Shell shell, String hostMsg, String levelTwo) {
        SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEO1002");
        msg.makeSubstitution((Object)hostMsg, (Object)levelTwo);
        SystemMessageDialog msgDlg = new SystemMessageDialog(shell, msg);
        msgDlg.open();
    }

    public static void displayHostWarningMessage(Shell shell, String hostMsg) {
        SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEO1011");
        msg.makeSubstitution((Object)hostMsg);
        SystemMessageDialog msgDlg = new SystemMessageDialog(shell, msg);
        msgDlg.open();
    }

    public static void displayHostWarningMessage(Shell shell, String hostMsg, String levelTwo) {
        SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEO1001");
        msg.makeSubstitution((Object)hostMsg, (Object)levelTwo);
        SystemMessageDialog msgDlg = new SystemMessageDialog(shell, msg);
        msgDlg.open();
    }

    public static void displayExceptionMessage(Shell shell, Exception exc) {
        SystemMessage msg = SystemMessageDialog.getExceptionMessage(shell, exc);
        if (shell == null && Display.getCurrent() != null) {
            shell = Display.getCurrent().getActiveShell();
        }
        SystemMessageDialog msgDlg = new SystemMessageDialog(shell, msg);
        msgDlg.setException(exc);
        msgDlg.open();
    }

    public static SystemMessage getExceptionMessage(Shell shell, Exception exc) {
        SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEG1003");
        msg.makeSubstitution((Object)exc);
        return msg;
    }

    public static void showExceptionMessage(Shell shell, String msg, Exception exc) {
        MessageBox mb = new MessageBox(null);
        mb.setMessage(msg);
        mb.open();
        SystemBasePlugin.logError(msg, exc);
    }

    public static boolean show(Shell shell, SystemMessage msg) {
        boolean yes = false;
        SystemMessageDialog msgDlg = new SystemMessageDialog(shell, msg);
        if (msg.getIndicator() != 'Q') {
            msgDlg.open();
        } else {
            yes = msgDlg.openQuestionNoException();
        }
        return yes;
    }

    public void setNoShowAgainOption(boolean noShowAgainOption, IPreferenceStore prefStore, String prefId, boolean prefValAsSelected) {
        this.noShowAgainOption = noShowAgainOption;
        this.prefStore = prefStore;
        this.prefId = prefId;
        this.prefValAsSelected = prefValAsSelected;
    }

    protected Button createNoShowAgainButton(Composite c) {
        Button b = new Button(c, 32);
        b.setText(SystemResources.RESID_DO_NOT_SHOW_MESSAGE_AGAIN_LABEL);
        b.setToolTipText(SystemResources.RESID_DO_NOT_SHOW_MESSAGE_AGAIN_TOOLTIP);
        b.addListener(13, (Listener)this);
        return b;
    }

    public void handleEvent(Event e) {
        if (e.type == 13 && e.widget == this.noShowAgainButton) {
            boolean isNoShowSelected = this.noShowAgainButton.getSelection();
            if (this.prefStore != null && this.prefId != null) {
                if (this.prefValAsSelected) {
                    this.prefStore.setValue(this.prefId, isNoShowSelected);
                } else {
                    this.prefStore.setValue(this.prefId, !isNoShowSelected);
                }
            }
        }
    }
}

