/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.operations;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.GenericMessages;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.operations.ISystemRunnableContext;
import org.eclipse.rse.ui.operations.Policy;
import org.eclipse.rse.ui.operations.SystemJobRunnableContext;
import org.eclipse.rse.ui.operations.SystemProgressDialogRunnableContext;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.progress.IElementCollector;

public class SystemFetchOperation
extends JobChangeAdapter
implements IRunnableWithProgress {
    protected IWorkbenchPart _part;
    protected IAdaptable _remoteObject;
    protected IElementCollector _collector;
    private IRunnableContext context;
    protected ISystemViewElementAdapter _adapter;
    protected boolean _canRunAsJob;
    protected InvocationTargetException _exc;

    public SystemFetchOperation(IWorkbenchPart part, IAdaptable remoteObject, ISystemViewElementAdapter adapter, IElementCollector collector) {
        this._part = part;
        this._remoteObject = remoteObject;
        this._collector = collector;
        this._adapter = adapter;
        this._canRunAsJob = false;
    }

    public SystemFetchOperation(IWorkbenchPart part, IAdaptable remoteObject, ISystemViewElementAdapter adapter, IElementCollector collector, boolean canRunAsJob) {
        this._part = part;
        this._remoteObject = remoteObject;
        this._collector = collector;
        this._adapter = adapter;
        this._canRunAsJob = canRunAsJob;
    }

    public void setException(InvocationTargetException exc) {
        this._exc = exc;
    }

    public IWorkbenchPart getPart() {
        return this._part;
    }

    public final void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.startOperation();
        try {
            try {
                monitor = Policy.monitorFor(monitor);
                monitor.beginTask(null, 100);
                monitor.setTaskName(this.getTaskName());
                this.execute(Policy.subMonitorFor(monitor, 100));
                this.endOperation();
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void startOperation() {
    }

    protected void endOperation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(IProgressMonitor monitor) throws Exception, InterruptedException {
        SubSystem ss = (SubSystem)this._adapter.getSubSystem(this._remoteObject);
        IConnectorService iConnectorService = ss.getConnectorService();
        synchronized (iConnectorService) {
            if (!ss.isConnected()) {
                Display dis = Display.getDefault();
                dis.syncExec((Runnable)new PromptForPassword(ss));
                try {
                    ss.getConnectorService().connect(monitor);
                    if (this._exc != null) {
                        this.showOperationErrorMessage(null, this._exc, ss);
                    }
                }
                catch (InvocationTargetException exc) {
                    this.showOperationErrorMessage(null, exc, ss);
                }
                catch (Exception e) {
                    this.showOperationErrorMessage(null, e, ss);
                }
                dis.asyncExec((Runnable)new UpdateRegistry(ss));
            }
        }
        Object[] children = this._adapter.getChildren(monitor, this._remoteObject);
        this._collector.add(children, monitor);
        monitor.done();
    }

    protected void showOperationErrorMessage(Shell shell, Throwable exc, SubSystem ss) {
        SystemMessage sysMsg = null;
        if (exc instanceof SystemMessageException) {
            this.displayAsyncMsg(ss, (SystemMessageException)exc);
        } else {
            String excMsg = exc.getMessage();
            if (excMsg == null || excMsg.length() == 0) {
                excMsg = "Exception " + exc.getClass().getName();
            }
            sysMsg = RSEUIPlugin.getPluginMessage("RSEG1066");
            sysMsg.makeSubstitution((Object)excMsg);
            SystemMessageDialog msgDlg = new SystemMessageDialog(shell, sysMsg);
            msgDlg.setException(exc);
            msgDlg.open();
        }
    }

    protected void displayAsyncMsg(SubSystem ss, SystemMessageException msg) {
        SubSystem.DisplayErrorMessageJob job = new SubSystem.DisplayErrorMessageJob(null, msg);
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    protected String getTaskName() {
        return GenericMessages.RSEQuery_task;
    }

    public final void run() throws InvocationTargetException, InterruptedException {
        if (this.shouldRun()) {
            this.getRunnableContext().run(this);
        }
    }

    protected boolean shouldRun() {
        return true;
    }

    protected ISchedulingRule getSchedulingRule() {
        return null;
    }

    protected boolean isPostponeAutobuild() {
        return true;
    }

    protected boolean canRunAsJob() {
        return this._canRunAsJob;
    }

    protected String getJobName() {
        return "";
    }

    protected IAction getGotoAction() {
        return null;
    }

    protected URL getOperationIcon() {
        return null;
    }

    protected boolean getKeepOperation() {
        return false;
    }

    protected Shell getShell() {
        return SystemBasePlugin.getActiveWorkbenchShell();
    }

    private ISystemRunnableContext getRunnableContext() {
        if (this.context == null && this.canRunAsJob()) {
            SystemJobRunnableContext context = new SystemJobRunnableContext(this.getJobName(), this.getOperationIcon(), this.getGotoAction(), this.getKeepOperation(), (IJobChangeListener)this, this.getSite());
            context.setPostponeBuild(this.isPostponeAutobuild());
            context.setSchedulingRule(this.getSchedulingRule());
            return context;
        }
        SystemProgressDialogRunnableContext context = new SystemProgressDialogRunnableContext(this.getShell());
        context.setPostponeBuild(this.isPostponeAutobuild());
        context.setSchedulingRule(this.getSchedulingRule());
        if (this.context != null) {
            context.setRunnableContext(this.context);
        }
        return context;
    }

    private IWorkbenchSite getSite() {
        IWorkbenchPartSite site = null;
        if (this._part != null) {
            site = this._part.getSite();
        }
        return site;
    }

    public class PromptForPassword
    implements Runnable {
        public SubSystem _ss;

        public PromptForPassword(SubSystem ss) {
            this._ss = ss;
        }

        public void run() {
            try {
                this._ss.promptForPassword();
            }
            catch (Exception exception) {}
        }
    }

    public class UpdateRegistry
    implements Runnable {
        private SubSystem _ss;

        public UpdateRegistry(SubSystem ss) {
            this._ss = ss;
        }

        public void run() {
            SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
            registry.connectedStatusChange(this._ss, true, false);
        }
    }
}

