/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.propertypages;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.rse.core.comm.SystemCommunicationsDaemon;
import org.eclipse.rse.ui.Mnemonics;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.propertypages.SystemBooleanFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class SystemCommunicationsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private IntegerFieldEditor portEditor;

    public SystemCommunicationsPreferencePage() {
        super(1);
        this.setPreferenceStore(RSEUIPlugin.getDefault().getPreferenceStore());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.rse.ui.cmmp0000");
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        SystemBooleanFieldEditor autoStartEditor = new SystemBooleanFieldEditor("org.eclipse.rse.preferences.daemon.autostart", SystemResources.RESID_PREF_DAEMON_AUTOSTART_LABEL, parent);
        autoStartEditor.setToolTipText(SystemResources.RESID_PREF_DAEMON_AUTOSTART_TOOLTIP);
        this.addField((FieldEditor)autoStartEditor);
        this.portEditor = new IntegerFieldEditor("org.eclipse.rse.preferences.daemon.port", SystemResources.RESID_PREF_DAEMON_PORT_LABEL, parent);
        this.portEditor.setValidRange(1, 65536);
        this.portEditor.setErrorMessage(RSEUIPlugin.getPluginMessage("RSEG1028").getLevelOneText());
        this.addField((FieldEditor)this.portEditor);
        this.portEditor.getTextControl(parent).setToolTipText(SystemResources.RESID_PREF_DAEMON_PORT_TOOLTIP);
        SystemWidgetHelpers.setHelp((Control)this.portEditor.getTextControl(parent), "org.eclipse.rse.ui.cmmp0000");
        new Mnemonics().setOnPreferencePage(true).setMnemonics(parent);
    }

    public void init(IWorkbench workbench) {
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault("org.eclipse.rse.preferences.daemon.autostart", false);
        store.setDefault("org.eclipse.rse.preferences.daemon.port", 4300);
    }

    public boolean performOk() {
        int port = this.portEditor.getIntValue();
        SystemCommunicationsDaemon daemon = SystemCommunicationsDaemon.getInstance();
        if (daemon.isRunning() && port != daemon.getPort()) {
            SystemCommunicationsDaemon.getInstance().stopDaemon();
            SystemCommunicationsDaemon.getInstance().startDaemon();
        }
        return super.performOk();
    }
}

