/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.validators;

import java.util.Vector;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorUniqueString;

public class ValidatorCompileCommandLabel
extends ValidatorUniqueString
implements ISystemValidator {
    public static final int MAX_CMDLABEL_LENGTH = 50;
    protected boolean fUnique;
    protected SystemMessage msg_Invalid;
    protected IWorkspace workspace = ResourcesPlugin.getWorkspace();

    public ValidatorCompileCommandLabel(Vector existingLabelList) {
        super(existingLabelList, false);
        this.init();
    }

    public ValidatorCompileCommandLabel(String[] existingLabelList) {
        super(existingLabelList, false);
        this.init();
    }

    public ValidatorCompileCommandLabel() {
        super(new String[0], false);
        this.init();
    }

    private void init() {
        super.setErrorMessages(RSEUIPlugin.getPluginMessage("RSEG1195"), RSEUIPlugin.getPluginMessage("RSEG1196"));
        this.fUnique = true;
        this.msg_Invalid = RSEUIPlugin.getPluginMessage("RSEG1197");
    }

    public void setErrorMessages(SystemMessage msg_Empty, SystemMessage msg_NonUnique, SystemMessage msg_Invalid) {
        super.setErrorMessages(msg_Empty, msg_NonUnique);
        this.msg_Invalid = msg_Invalid;
    }

    protected boolean checkForBadCharacters(String newText) {
        return newText.indexOf(38) == -1 && newText.indexOf(64) == -1;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public SystemMessage isSyntaxOk(String newText) {
        this.currentMessage = newText.length() > this.getMaximumNameLength() ? this.msg_Invalid : (this.checkForBadCharacters(newText) ? null : this.msg_Invalid);
        return this.currentMessage;
    }

    public int getMaximumNameLength() {
        return 50;
    }
}

