/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.validators;

import java.io.File;
import java.util.Vector;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.validators.ValidatorPathName;

public class ValidatorLocalPath
extends ValidatorPathName {
    public static final boolean WINDOWS = System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0;
    public static final char SEPCHAR = File.separatorChar;

    public ValidatorLocalPath(Vector existingNameList) {
        super(existingNameList);
    }

    public ValidatorLocalPath(String[] existingNameList) {
        super(existingNameList);
    }

    public ValidatorLocalPath() {
    }

    public SystemMessage isSyntaxOk(String newText) {
        SystemMessage msg = super.isSyntaxOk(newText);
        if (msg == null) {
            boolean ok = true;
            if (WINDOWS) {
                if (newText.length() < 3) {
                    ok = false;
                } else if (newText.charAt(1) != ':') {
                    ok = false;
                } else if (newText.charAt(2) != SEPCHAR) {
                    ok = false;
                } else if (!Character.isLetter(newText.charAt(0))) {
                    ok = false;
                }
            } else if (newText.length() < 1) {
                ok = false;
            } else if (newText.charAt(0) != SEPCHAR) {
                ok = false;
            }
            if (!ok) {
                msg = this.msg_Invalid;
            }
        }
        return msg;
    }
}

