/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import org.eclipse.rse.ui.SystemPropertyResources;

public class SystemInheritablePropertyData {
    private String localValue = "";
    private String inheritedValue = "";
    private boolean isLocal;
    private boolean notApplicable = false;
    private String inheritedXlatedString;

    public SystemInheritablePropertyData() {
        this.setInheritedDisplayString(SystemPropertyResources.RESID_PROPERTY_INHERITED);
    }

    public void setNotApplicable(boolean set) {
        this.notApplicable = set;
    }

    public boolean getNotApplicable() {
        return this.notApplicable;
    }

    public String getLocalValue() {
        return this.localValue;
    }

    public void setLocalValue(String localValue) {
        if (localValue == null) {
            localValue = "";
        }
        this.localValue = localValue;
    }

    public String getInheritedValue() {
        return this.inheritedValue;
    }

    public void setInheritedValue(String inheritedValue) {
        if (inheritedValue == null) {
            inheritedValue = "";
        }
        this.inheritedValue = inheritedValue;
    }

    public boolean getIsLocal() {
        return this.isLocal;
    }

    public void setIsLocal(boolean isLocal) {
        this.isLocal = isLocal;
    }

    public void setInheritedDisplayString(String s) {
        this.inheritedXlatedString = s;
    }

    public String toString() {
        if (this.notApplicable) {
            return SystemPropertyResources.RESID_TERM_NOTAPPLICABLE;
        }
        String value = null;
        value = this.isLocal ? this.localValue : String.valueOf(this.inheritedValue) + " " + this.inheritedXlatedString;
        return value;
    }

    public boolean equals(Object other) {
        if (other instanceof SystemInheritablePropertyData) {
            SystemInheritablePropertyData otherData = (SystemInheritablePropertyData)other;
            boolean equal = this.isLocal == otherData.getIsLocal() && this.localValue.equals(otherData.getLocalValue()) && this.inheritedValue.equals(otherData.getInheritedValue());
            return equal;
        }
        return super.equals(other);
    }

    public void printDetails() {
        System.out.println("SystemInheritablePropertyData: ");
        System.out.println("...localValue = " + this.localValue);
        System.out.println("...inheritedValue = " + this.inheritedValue);
        System.out.println("...isLocal = " + this.isLocal);
    }
}

