/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class SystemPropertySheetForm
extends Composite {
    private PropertySheetPage tree = null;
    private boolean enabledMode = true;
    public static final int DEFAULT_WIDTH = 300;
    public static final int DEFAULT_HEIGHT = 250;

    public SystemPropertySheetForm(Shell shell, Composite parent, int style, ISystemMessageLine msgLine) {
        this(shell, parent, style, msgLine, 1, 1);
    }

    public SystemPropertySheetForm(Shell shell, Composite parent, int style, ISystemMessageLine msgLine, int horizontalSpan, int verticalSpan) {
        super(parent, style);
        this.prepareComposite(1, horizontalSpan, verticalSpan);
        this.createPropertySheetView(shell);
        this.addOurSelectionListener();
        this.addOurMouseListener();
        this.addOurKeyListener();
    }

    public PropertySheetPage getPropertySheetView() {
        return this.tree;
    }

    public Control getControl() {
        return this.tree.getControl();
    }

    public void setToolTipText(String tip) {
        this.tree.getControl().setToolTipText(tip);
    }

    public void refresh() {
        this.tree.refresh();
    }

    public void selectionChanged(ISelection selection) {
        this.tree.selectionChanged(null, selection);
    }

    public void setEnabled(boolean enabled) {
        this.enabledMode = enabled;
    }

    protected Composite prepareComposite(int numColumns, int horizontalSpan, int verticalSpan) {
        SystemPropertySheetForm composite = this;
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.widthHint = 300;
        data.heightHint = 250;
        data.horizontalSpan = horizontalSpan;
        data.verticalSpan = verticalSpan;
        composite.setLayoutData(data);
        return composite;
    }

    protected void createPropertySheetView(Shell shell) {
        this.tree = new PropertySheetPage();
        this.tree.createControl((Composite)this);
        Control c = this.tree.getControl();
        GridData treeData = new GridData();
        treeData.horizontalAlignment = 4;
        treeData.verticalAlignment = 4;
        treeData.grabExcessHorizontalSpace = true;
        treeData.grabExcessVerticalSpace = true;
        treeData.widthHint = 220;
        treeData.heightHint = 200;
        c.setLayoutData((Object)treeData);
    }

    protected void addOurSelectionListener() {
    }

    protected void addOurMouseListener() {
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (!SystemPropertySheetForm.this.enabledMode) {
                    return;
                }
            }
        };
        this.tree.getControl().addMouseListener((MouseListener)mouseListener);
    }

    protected void addOurKeyListener() {
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!SystemPropertySheetForm.this.enabledMode) {
                    return;
                }
            }
        };
        this.tree.getControl().addKeyListener((KeyListener)keyListener);
    }
}

