/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.view.SystemAbstractAPIProvider;

public abstract class SystemResourceSelectionInputProvider
extends SystemAbstractAPIProvider {
    private IHost _connection;
    private boolean _onlyConnection = false;
    private boolean _allowNew = true;
    private String[] _systemTypes;
    private String _category = null;

    public SystemResourceSelectionInputProvider(IHost connection) {
        this._connection = connection;
    }

    public SystemResourceSelectionInputProvider() {
        this._connection = null;
    }

    public IHost getSystemConnection() {
        return this._connection;
    }

    public boolean allowMultipleConnections() {
        return !this._onlyConnection;
    }

    public void setAllowNewConnection(boolean flag) {
        this._allowNew = flag;
    }

    public boolean allowNewConnection() {
        return this._allowNew;
    }

    public void setSystemConnection(IHost connection, boolean onlyConnection) {
        this._connection = connection;
        this._onlyConnection = onlyConnection;
    }

    public String[] getSystemTypes() {
        return this._systemTypes;
    }

    public void setSystemTypes(String[] types) {
        this._systemTypes = types;
    }

    public Object[] getSystemViewRoots() {
        if (this._connection == null) {
            SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
            this._connection = registry.getHosts()[0];
        }
        return this.getConnectionChildren(this._connection);
    }

    public boolean hasSystemViewRoots() {
        return false;
    }

    public Object[] getConnectionChildren(IHost selectedConnection) {
        if (selectedConnection != null) {
            return this.getSubSystem(selectedConnection).getChildren();
        }
        return null;
    }

    public boolean hasConnectionChildren(IHost selectedConnection) {
        if (selectedConnection != null) {
            return this.getSubSystem(selectedConnection).hasChildren();
        }
        return false;
    }

    protected abstract ISubSystem getSubSystem(IHost var1);

    public void setCategory(String category) {
        this._category = category;
    }

    public String getCategory() {
        return this._category;
    }
}

