/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.widgets;

import org.eclipse.rse.core.subsystems.IRemoteServerLauncher;
import org.eclipse.rse.core.subsystems.IServerLauncherProperties;
import org.eclipse.rse.core.subsystems.ServerLaunchType;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.validators.SystemNumericVerifyListener;
import org.eclipse.rse.ui.validators.ValidatorPortInput;
import org.eclipse.rse.ui.widgets.RemoteBaseServerLauncherForm;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RemoteServerLauncherForm
extends RemoteBaseServerLauncherForm {
    private Button _radioDaemon;
    private Button _radioRexec;
    private Button _radioNone;
    private Button _checkBoxSSL;
    private Button _checkBoxRexecSSL;
    private Button _checkBoxAutoDetect;
    private Text _fieldDaemonPort;
    private Label _labelDaemonPort;
    private Text _fieldRexecPath;
    private Text _fieldRexecInvocation;
    private Text _fieldRexecPort;
    private Label _labelRexecPath;
    private Label _labelRexecInvocation;
    private Label _labelRexecPort;
    private Composite _daemonControls;
    private Composite _rexecControls;
    private Composite _noneControls;
    private ValidatorPortInput _daemonPortValidator = new ValidatorPortInput();
    private ValidatorPortInput _rexecPortValidator = new ValidatorPortInput();
    private ServerLaunchType _origlaunchType;
    private String _origPath;
    private String _origInvocation;
    private int _origRexecPort;
    private int _origDaemonPort;
    private boolean _origUseSSL;
    private boolean _origAutoDetect;

    public RemoteServerLauncherForm(Shell shell, ISystemMessageLine msgLine) {
        super(shell, msgLine);
    }

    public boolean isDirty() {
        boolean isDirty = this._origlaunchType != this.getLaunchType() || !this._origPath.equals(this.getServerInstallPath()) || !this._origInvocation.equals(this.getServerInvocation()) || this._origRexecPort != this.getREXECPortAsInt() || this._origDaemonPort != this.getDaemonPortAsInt() || this._origUseSSL != this.getUseSSL() || this._origAutoDetect != this.getAutoDetect();
        return isDirty;
    }

    public void disable() {
        this._radioDaemon.setEnabled(false);
        this._radioRexec.setEnabled(false);
        this._radioNone.setEnabled(false);
        this._fieldRexecInvocation.setEnabled(false);
        this._fieldRexecPath.setEnabled(false);
        this._fieldRexecPort.setEnabled(false);
        this._fieldDaemonPort.setEnabled(false);
        this._checkBoxSSL.setEnabled(false);
        this._checkBoxRexecSSL.setEnabled(false);
        this._checkBoxAutoDetect.setEnabled(false);
    }

    protected void createLauncherControls(Group group) {
        this._radioDaemon = SystemWidgetHelpers.createRadioButton((Composite)group, SystemResources.RESID_PROP_SERVERLAUNCHER_RADIO_DAEMON, this);
        this._radioDaemon.setToolTipText(SystemResources.RESID_PROP_SERVERLAUNCHER_RADIO_DAEMON_TOOLTIP);
        this._daemonControls = SystemWidgetHelpers.createComposite((Composite)group, 1);
        GridLayout dlayout = new GridLayout();
        dlayout.numColumns = 3;
        GridData ddata = new GridData(768);
        ddata.horizontalIndent = 20;
        GridData dd = new GridData();
        dd.widthHint = 30;
        String portRange = " (1-65535)";
        this._labelDaemonPort = SystemWidgetHelpers.createLabel(this._daemonControls, String.valueOf(SystemResources.RESID_CONNECTION_DAEMON_PORT_LABEL) + portRange);
        this._fieldDaemonPort = SystemWidgetHelpers.createTextField(this._daemonControls, this);
        this._fieldDaemonPort.setToolTipText(SystemResources.RESID_CONNECTION_DAEMON_PORT_TIP);
        this._fieldDaemonPort.setLayoutData((Object)dd);
        this._fieldDaemonPort.addVerifyListener((VerifyListener)new SystemNumericVerifyListener());
        this._daemonControls.setLayout((Layout)dlayout);
        this._daemonControls.setLayoutData((Object)ddata);
        this._radioRexec = SystemWidgetHelpers.createRadioButton((Composite)group, SystemResources.RESID_PROP_SERVERLAUNCHER_RADIO_REXEC, this);
        this._radioRexec.setToolTipText(SystemResources.RESID_PROP_SERVERLAUNCHER_RADIO_REXEC_TOOLTIP);
        this._rexecControls = SystemWidgetHelpers.createComposite((Composite)group, 1);
        GridLayout layout = new GridLayout();
        GridData data = new GridData(768);
        data.horizontalIndent = 20;
        this._labelRexecPath = SystemWidgetHelpers.createLabel(this._rexecControls, SystemResources.RESID_PROP_SERVERLAUNCHER_PATH);
        this._fieldRexecPath = SystemWidgetHelpers.createTextField(this._rexecControls, this);
        this._fieldRexecPath.setToolTipText(SystemResources.RESID_PROP_SERVERLAUNCHER_PATH_TOOLTIP);
        Composite subRexecControls = SystemWidgetHelpers.createComposite(this._rexecControls, 1);
        GridLayout l2 = new GridLayout();
        GridData d2 = new GridData(768);
        l2.numColumns = 4;
        this._labelRexecInvocation = SystemWidgetHelpers.createLabel(subRexecControls, SystemResources.RESID_PROP_SERVERLAUNCHER_INVOCATION);
        this._fieldRexecInvocation = SystemWidgetHelpers.createTextField(subRexecControls, this);
        this._fieldRexecInvocation.setToolTipText(SystemResources.RESID_PROP_SERVERLAUNCHER_INVOCATION_TOOLTIP);
        GridData d3 = new GridData();
        d3.widthHint = 30;
        this._labelRexecPort = SystemWidgetHelpers.createLabel(subRexecControls, String.valueOf(SystemResources.RESID_CONNECTION_PORT_LABEL) + portRange);
        this._fieldRexecPort = SystemWidgetHelpers.createTextField(subRexecControls, this);
        this._fieldRexecPort.setToolTipText(SystemResources.RESID_CONNECTION_PORT_TIP);
        this._fieldRexecPort.setLayoutData((Object)d3);
        this._fieldRexecPort.addVerifyListener((VerifyListener)new SystemNumericVerifyListener());
        subRexecControls.setLayout((Layout)l2);
        subRexecControls.setLayoutData((Object)d2);
        this._checkBoxAutoDetect = SystemWidgetHelpers.createCheckBox(this._rexecControls, SystemResources.RESID_SUBSYSTEM_AUTODETECT_LABEL, this);
        this._checkBoxAutoDetect.setToolTipText(SystemResources.RESID_SUBSYSTEM_AUTODETECT_TIP);
        this._checkBoxRexecSSL = SystemWidgetHelpers.createCheckBox(this._rexecControls, SystemResources.RESID_SUBSYSTEM_SSL_LABEL, this);
        this._checkBoxRexecSSL.setToolTipText(SystemResources.RESID_SUBSYSTEM_SSL_TIP);
        this._rexecControls.setLayout((Layout)layout);
        this._rexecControls.setLayoutData((Object)data);
        this._radioNone = SystemWidgetHelpers.createRadioButton((Composite)group, SystemResources.RESID_PROP_SERVERLAUNCHER_RADIO_NONE, this);
        this._radioNone.setToolTipText(SystemResources.RESID_PROP_SERVERLAUNCHER_RADIO_NONE_TOOLTIP);
        this._noneControls = SystemWidgetHelpers.createComposite((Composite)group, 1);
        GridLayout nlayout = new GridLayout();
        GridData ndata = new GridData(768);
        ndata.horizontalIndent = 20;
        this._checkBoxSSL = SystemWidgetHelpers.createCheckBox(this._noneControls, SystemResources.RESID_SUBSYSTEM_SSL_LABEL, this);
        this._checkBoxSSL.setToolTipText(SystemResources.RESID_SUBSYSTEM_SSL_TIP);
        this._noneControls.setLayout((Layout)nlayout);
        this._noneControls.setLayoutData((Object)ndata);
        SystemWidgetHelpers.setHelp((Control)this._radioDaemon, "org.eclipse.rse.ui.srln0001");
        SystemWidgetHelpers.setHelp((Control)this._radioRexec, "org.eclipse.rse.ui.srln0002");
        SystemWidgetHelpers.setHelp((Control)this._radioNone, "org.eclipse.rse.ui.srln0003");
        SystemWidgetHelpers.setHelp((Control)this._fieldRexecPath, "org.eclipse.rse.ui.srln0004");
        SystemWidgetHelpers.setHelp((Control)this._fieldRexecInvocation, "org.eclipse.rse.ui.srln0005");
    }

    protected void initDefaults() {
        this._radioDaemon.setSelection(true);
        this._fieldDaemonPort.setEnabled(this._radioDaemon.getSelection());
        this._fieldRexecPath.setEnabled(this._radioRexec.getSelection());
        this._labelRexecPath.setEnabled(this._radioRexec.getSelection());
        this._fieldRexecInvocation.setEnabled(this._radioRexec.getSelection());
        this._labelRexecInvocation.setEnabled(this._radioRexec.getSelection());
        this._labelRexecPort.setEnabled(this._radioRexec.getSelection());
        this._fieldRexecPort.setEnabled(this._radioRexec.getSelection());
        this._checkBoxRexecSSL.setEnabled(this._radioRexec.getSelection());
        this._checkBoxAutoDetect.setEnabled(this._radioRexec.getSelection());
        this._checkBoxSSL.setEnabled(this._radioNone.getSelection());
        this._fieldDaemonPort.setText(String.valueOf(4035));
        this._fieldRexecPath.setText("/opt/rseserver/");
        this._fieldRexecInvocation.setText("sh -c \"PATH=/opt/j2sdk1.4.2/bin:$PATH; export PATH; perl ./server.pl\"");
        this._fieldRexecPort.setText(String.valueOf(512));
    }

    public void initValues(IServerLauncherProperties launcher) {
        IRemoteServerLauncher isl = (IRemoteServerLauncher)launcher;
        ServerLaunchType type = isl.getServerLaunchType();
        String path = isl.getServerPath();
        String invocation = isl.getServerScript();
        int rexecport = isl.getRexecPort();
        int daemonPort = isl.getDaemonPort();
        boolean useSSL = isl.getConnectorService().isUsingSSL();
        boolean autoDetectSSL = isl.getAutoDetectSSL();
        boolean allowDaemon = isl.isEnabledServerLaunchType(ServerLaunchType.DAEMON_LITERAL);
        boolean allowRexec = isl.isEnabledServerLaunchType(ServerLaunchType.REXEC_LITERAL);
        boolean allowNo = isl.isEnabledServerLaunchType(ServerLaunchType.RUNNING_LITERAL);
        this.setDaemonLaunchEnabled(allowDaemon);
        this.setRexecLaunchEnabled(allowRexec);
        this.setNoLaunchEnabled(allowNo);
        this.setLaunchType(type);
        this.setDaemonPort(daemonPort);
        this.setServerInstallPath(path);
        this.setServerInvocation(invocation);
        this.setREXECPort(rexecport);
        this.setUseSSL(useSSL);
        this.setAutoDetect(autoDetectSSL);
        if (!(allowDaemon || allowRexec || allowNo)) {
            this.disable();
        }
        this._origlaunchType = this.getLaunchType();
        this._origPath = this.getServerInstallPath();
        this._origInvocation = this.getServerInvocation();
        this._origRexecPort = this.getREXECPortAsInt();
        this._origDaemonPort = this.getDaemonPortAsInt();
        this._origUseSSL = this.getUseSSL();
        this._origAutoDetect = this.getAutoDetect();
    }

    public boolean verify() {
        SystemMessage msg = null;
        ServerLaunchType launchType = this.getLaunchType();
        if (launchType == ServerLaunchType.REXEC_LITERAL) {
            String port = this.getREXECPort();
            msg = this._rexecPortValidator.validate(port);
            if (msg == null) {
                String path = this.getServerInstallPath();
                if (path == null || path.length() == 0) {
                    msg = RSEUIPlugin.getPluginMessage("RSEC2103");
                }
                if (msg != null) {
                    this._msgLine.setErrorMessage(msg.getLevelOneText());
                } else {
                    this._msgLine.clearErrorMessage();
                }
            } else {
                this._msgLine.setErrorMessage(msg);
            }
        } else if (launchType == ServerLaunchType.DAEMON_LITERAL) {
            String port = this.getDaemonPort();
            msg = this._daemonPortValidator.validate(port);
            if (msg == null) {
                this._msgLine.clearErrorMessage();
            } else {
                this._msgLine.setErrorMessage(msg);
            }
        } else {
            this._msgLine.clearErrorMessage();
        }
        this.notifyVerifyListeners();
        return msg == null;
    }

    public boolean updateValues(IServerLauncherProperties launcher) {
        ServerLaunchType launchType = this.getLaunchType();
        String path = this.getServerInstallPath();
        String invocation = this.getServerInvocation();
        int rexecPort = this.getREXECPortAsInt();
        int daemonPort = this.getDaemonPortAsInt();
        boolean useSSL = this.getUseSSL();
        boolean autoDetect = this.getAutoDetect();
        IRemoteServerLauncher isl = (IRemoteServerLauncher)launcher;
        isl.setServerLaunchType(launchType);
        isl.setServerPath(path);
        isl.setServerScript(invocation);
        isl.setRexecPort(rexecPort);
        isl.setDaemonPort(daemonPort);
        isl.setAutoDetectSSL(autoDetect);
        isl.getConnectorService().setIsUsingSSL(useSSL);
        try {
            isl.getConnectorService().commit();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void handleEvent(Event evt) {
        boolean useRexec = this._radioRexec.getSelection();
        this._fieldDaemonPort.setEnabled(this._radioDaemon.getSelection());
        this._fieldRexecPath.setEnabled(useRexec);
        this._labelRexecPath.setEnabled(useRexec);
        this._fieldRexecInvocation.setEnabled(useRexec);
        this._labelRexecInvocation.setEnabled(useRexec);
        this._fieldRexecPort.setEnabled(useRexec);
        this._labelRexecPort.setEnabled(useRexec);
        this._checkBoxAutoDetect.setEnabled(useRexec);
        this._checkBoxRexecSSL.setEnabled(useRexec && !this._checkBoxAutoDetect.getSelection());
        this._checkBoxSSL.setEnabled(this._radioNone.getSelection());
        this.verify();
    }

    protected ServerLaunchType getLaunchType() {
        if (this._radioDaemon.getSelection()) {
            return ServerLaunchType.DAEMON_LITERAL;
        }
        if (this._radioRexec.getSelection()) {
            return ServerLaunchType.REXEC_LITERAL;
        }
        if (this._radioNone.getSelection()) {
            return ServerLaunchType.RUNNING_LITERAL;
        }
        return null;
    }

    protected boolean getUseSSL() {
        if (this._radioRexec.getSelection()) {
            return this._checkBoxRexecSSL.getSelection();
        }
        return this._checkBoxSSL.getSelection();
    }

    protected boolean getAutoDetect() {
        if (this._radioNone.getSelection()) {
            return false;
        }
        if (this._radioRexec.getSelection()) {
            return this._checkBoxAutoDetect.getSelection();
        }
        return true;
    }

    protected void setUseSSL(boolean use) {
        this._checkBoxSSL.setSelection(use);
        this._checkBoxRexecSSL.setSelection(use);
    }

    protected void setAutoDetect(boolean use) {
        this._checkBoxAutoDetect.setSelection(use);
    }

    protected void setLaunchType(ServerLaunchType type) {
        if (type == ServerLaunchType.DAEMON_LITERAL) {
            this._radioDaemon.setSelection(true);
            this._radioRexec.setSelection(false);
            this._radioNone.setSelection(false);
        } else if (type == ServerLaunchType.REXEC_LITERAL) {
            this._radioRexec.setSelection(true);
            this._radioDaemon.setSelection(false);
            this._radioNone.setSelection(false);
        } else if (type == ServerLaunchType.RUNNING_LITERAL) {
            this._radioNone.setSelection(true);
            this._radioRexec.setSelection(false);
            this._radioDaemon.setSelection(false);
        } else {
            this._radioNone.setSelection(false);
            this._radioRexec.setSelection(false);
            this._radioDaemon.setSelection(false);
        }
    }

    public void setDaemonLaunchEnabled(boolean enable) {
        this._labelDaemonPort.setEnabled(enable);
        this._fieldDaemonPort.setEnabled(enable);
        this._radioDaemon.setEnabled(enable);
    }

    public void setRexecLaunchEnabled(boolean enable) {
        this._fieldRexecInvocation.setEnabled(enable);
        this._fieldRexecPath.setEnabled(enable);
        this._fieldRexecPort.setEnabled(enable);
        this._radioRexec.setEnabled(enable);
    }

    public void setHostname(String hostname) {
        this._hostName = hostname;
    }

    public void setDaemonPort(String port) {
        this._fieldDaemonPort.setText(port);
    }

    public void setDaemonPort(int port) {
        this._fieldDaemonPort.setText(Integer.toString(port));
    }

    public int getDaemonPortAsInt() {
        int port = 0;
        try {
            port = Integer.parseInt(this._fieldDaemonPort.getText().trim());
        }
        catch (Exception exception) {}
        return port;
    }

    public String getDaemonPort() {
        return this._fieldDaemonPort.getText().trim();
    }

    public void setREXECPort(String port) {
        this._fieldRexecPort.setText(port);
    }

    public void setREXECPort(int port) {
        this._fieldRexecPort.setText(Integer.toString(port));
    }

    public int getREXECPortAsInt() {
        int port = 0;
        try {
            port = Integer.parseInt(this._fieldRexecPort.getText().trim());
        }
        catch (Exception exception) {}
        return port;
    }

    public String getREXECPort() {
        return this._fieldRexecPort.getText().trim();
    }

    public void setNoLaunchEnabled(boolean enable) {
        this._radioNone.setEnabled(enable);
        this._checkBoxSSL.setEnabled(enable);
    }

    public String getServerInstallPath() {
        return this._fieldRexecPath.getText().trim();
    }

    public void setServerInstallPath(String path) {
        this._fieldRexecPath.setText(path);
    }

    public String getServerInvocation() {
        return this._fieldRexecInvocation.getText();
    }

    public void setServerInvocation(String invocation) {
        this._fieldRexecInvocation.setText(invocation);
    }
}

