/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.wizards;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.wizards.AbstractSystemWizard;
import org.eclipse.rse.ui.wizards.IRSENewConnectionWizard;
import org.eclipse.rse.ui.wizards.IRSENewConnectionWizardDelegate;
import org.eclipse.rse.ui.wizards.RSEDefaultNewConnectionWizardDelegate;
import org.eclipse.rse.ui.wizards.RSENewConnectionWizardMainPage;

public class RSENewConnectionWizard
extends AbstractSystemWizard
implements IRSENewConnectionWizard {
    private HashMap map;
    private IRSENewConnectionWizardDelegate delegate;
    private RSENewConnectionWizardMainPage mainPage;
    private IRSESystemType[] restrictedSystemTypes;
    private boolean onlySystemType;
    private IRSENewConnectionWizardDelegate defaultDelegate;
    private boolean defaultDelegateCreated;

    public RSENewConnectionWizard() {
        super(SystemResources.RESID_NEWCONN_TITLE, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.newconnection_wizBannerIcon"));
        this.readWizardDelegateExtensions();
        this.setForcePreviousAndNextButtons(true);
        this.setNeedsProgressMonitor(true);
    }

    public void restrictToSystemType(IRSESystemType systemType) {
        IRSESystemType[] types = new IRSESystemType[]{systemType};
        this.restrictToSystemTypes(types);
    }

    public void restrictToSystemTypes(IRSESystemType[] systemTypes) {
        this.restrictedSystemTypes = systemTypes;
        this.onlySystemType = systemTypes.length == 1;
    }

    public void setSelectedSystemType(IRSESystemType systemType) {
        this.setDelegate(systemType);
    }

    private void readWizardDelegateExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.rse.ui.newConnectionWizardDelegates");
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals("newConnectionWizardDelegate")) {
                String systemTypeID = element.getAttribute("systemType");
                Object obj = null;
                try {
                    obj = element.createExecutableExtension("class");
                    if (obj instanceof IRSENewConnectionWizardDelegate) {
                        if (this.map == null) {
                            this.map = new HashMap();
                        }
                        if (!this.map.containsKey(systemTypeID)) {
                            this.map.put(systemTypeID, obj);
                        }
                    }
                }
                catch (CoreException e) {
                    SystemBasePlugin.logError("Class " + obj + " is not executable extension", e);
                }
            }
            ++i;
        }
    }

    private IRSENewConnectionWizardDelegate setDelegate(IRSESystemType systemType) {
        if (this.map != null) {
            this.delegate = (IRSENewConnectionWizardDelegate)this.map.get(systemType.getId());
        }
        if (this.delegate == null) {
            if (!this.defaultDelegateCreated) {
                this.defaultDelegate = new RSEDefaultNewConnectionWizardDelegate();
                this.defaultDelegateCreated = true;
            }
            this.delegate = this.defaultDelegate;
        }
        if (!this.delegate.isInitialized()) {
            this.delegate.init(this, systemType);
        } else {
            this.delegate.systemTypeChanged(systemType);
        }
        return this.delegate;
    }

    public IRSENewConnectionWizardDelegate getDelegate() {
        return this.delegate;
    }

    public void addPages() {
        if (!this.onlySystemType) {
            this.mainPage = new RSENewConnectionWizardMainPage(this, "Select System Type", "Select a system type");
            if (this.restrictedSystemTypes != null) {
                this.mainPage.restrictToSystemTypes(this.restrictedSystemTypes);
            }
            this.addPage((IWizardPage)this.mainPage);
        } else {
            this.setDelegate(this.restrictedSystemTypes[0]);
            this.addPage(this.delegate.getMainPage());
        }
    }

    public boolean canFinish() {
        boolean result = true;
        if (this.mainPage != null) {
            result = this.mainPage.isPageComplete();
        }
        if (result) {
            result = this.delegate != null ? this.delegate.canFinish() : false;
        }
        return result;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.mainPage != null && page == this.mainPage) {
            return super.getNextPage(page);
        }
        if (this.delegate != null) {
            IWizardPage nextPage = this.delegate.getNextPage(page);
            if (nextPage == null) {
                return super.getNextPage(page);
            }
            return nextPage;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (this.mainPage != null && page == this.mainPage) {
            return super.getPreviousPage(page);
        }
        if (this.delegate != null) {
            IWizardPage prevPage = this.delegate.getPreviousPage(page);
            if (prevPage == null) {
                return super.getPreviousPage(page);
            }
            return prevPage;
        }
        return super.getPreviousPage(page);
    }

    public boolean performFinish() {
        boolean result = true;
        if (this.mainPage != null) {
            result = this.mainPage.performFinish();
        }
        if (result && this.delegate != null) {
            result = this.delegate.performFinish();
        }
        return result;
    }
}

