/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.discovery.protocol;

import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tm.discovery.protocol.IProtocol;

public class ProtocolFactory {
    private static IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.tm.discovery.engine", "discoveryProtocol");

    public static String[] getProtocolList() {
        Vector<String> protocols = new Vector<String>();
        IConfigurationElement[] ce = ep.getConfigurationElements();
        int i = 0;
        while (i < ce.length) {
            String name = ce[i].getAttribute("name");
            if (name != null) {
                protocols.add(name);
            }
            ++i;
        }
        Object[] protocolsList = new String[protocols.size()];
        protocols.copyInto(protocolsList);
        return protocolsList;
    }

    public static String[] getQueryList(String protocolName) throws CoreException {
        IProtocol protocol = null;
        String[] queries = null;
        IConfigurationElement[] ce = ep.getConfigurationElements();
        int i = 0;
        while (i < ce.length) {
            String name = ce[i].getAttribute("name");
            if (name != null && name.equalsIgnoreCase(protocolName)) {
                protocol = (IProtocol)ce[i].createExecutableExtension("class");
            }
            ++i;
        }
        if (protocol != null && (queries = protocol.getQueries()) == null) {
            queries = new String[]{};
        }
        return queries;
    }

    public static IProtocol getProtocol(String protocolName) throws CoreException {
        IProtocol protocol = null;
        IConfigurationElement[] ce = ep.getConfigurationElements();
        int i = 0;
        while (i < ce.length) {
            String name = ce[i].getAttribute("name");
            if (name != null && name.equalsIgnoreCase(protocolName)) {
                protocol = (IProtocol)ce[i].createExecutableExtension("class");
            }
            ++i;
        }
        return protocol;
    }
}

