/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.discovery.protocol.dnssd;

import java.io.ByteArrayInputStream;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.tm.discovery.model.Device;
import org.eclipse.tm.discovery.model.ModelFactory;
import org.eclipse.tm.discovery.model.Network;
import org.eclipse.tm.discovery.model.Pair;
import org.eclipse.tm.discovery.model.Service;
import org.eclipse.tm.discovery.model.ServiceType;
import org.eclipse.tm.discovery.protocol.IProtocol;
import org.eclipse.tm.discovery.protocol.dnssd.Messages;
import org.eclipse.tm.discovery.transport.ITransport;

public class DNSSDProtocol
implements IProtocol {
    private static final int PTR = 12;
    private static final int SRV = 33;
    private static final int TXT = 16;
    private static final int A = 1;
    private byte[] packet;
    private final int MAX_PACKET_SIZE = 65535;
    private byte[] buffer = new byte[65535];
    private String address;
    private final String SERVICE_DISCOVERY_COMMAND = Messages.getString("DNSSDProtocol.ServiceDiscoveryCommand");
    private final String LEGACY_SERVICE_DISCOVERY_COMMAND = Messages.getString("DNSSDProtocol.legacyServiceDiscoveryCommand");
    private final Pattern srvPattern = Pattern.compile("^(.+)\\._(.+)._.+\\.local.");
    private final Pattern ptrPattern = Pattern.compile("^_(.+)._.+\\.local.");
    private Resource resource = null;
    private ITransport transport = null;
    private String query = null;

    public String[] getQueries() {
        return new String[]{this.SERVICE_DISCOVERY_COMMAND, this.LEGACY_SERVICE_DISCOVERY_COMMAND};
    }

    public Job getDiscoveryJob(String aQuery, Resource aResource, ITransport aTransport) {
        this.resource = aResource;
        this.transport = aTransport;
        this.query = aQuery;
        return new Job(Messages.getString("DNSSDProtocol.JobName")){

            protected IStatus run(IProgressMonitor monitor) {
                if (DNSSDProtocol.this.transport != null) {
                    DNSSDProtocol.this.sendQuery(DNSSDProtocol.this.transport, DNSSDProtocol.this.query, 12);
                    Vector<String> discoveredServices = new Vector<String>();
                    if (!DNSSDProtocol.this.resource.getContents().isEmpty()) {
                        Iterator deviceIterator = ((Network)DNSSDProtocol.this.resource.getContents().get(0)).getDevice().iterator();
                        while (deviceIterator.hasNext()) {
                            Device device = (Device)deviceIterator.next();
                            Iterator serviceTypeIterator = device.getServiceType().iterator();
                            while (serviceTypeIterator.hasNext()) {
                                ServiceType serviceType = (ServiceType)serviceTypeIterator.next();
                                if (!serviceType.getName().equals(DNSSDProtocol.this.SERVICE_DISCOVERY_COMMAND) && !serviceType.getName().equals(DNSSDProtocol.this.LEGACY_SERVICE_DISCOVERY_COMMAND)) continue;
                                Iterator serviceIterator = serviceType.getService().iterator();
                                while (serviceIterator.hasNext()) {
                                    Service service = (Service)serviceIterator.next();
                                    if (discoveredServices.contains(service.getName())) continue;
                                    discoveredServices.add(service.getName());
                                }
                                serviceTypeIterator.remove();
                            }
                        }
                        int i = 0;
                        while (i < discoveredServices.size()) {
                            DNSSDProtocol.this.sendQuery(DNSSDProtocol.this.transport, (String)discoveredServices.elementAt(i), 12);
                            ++i;
                        }
                    }
                }
                return new Status(0, "org.eclipse.rse.discovery.engine", 0, Messages.getString("DNSSDProtocol.FinishedJobName"), null);
            }
        };
    }

    private void sendQuery(ITransport transport, String query, int type) {
        try {
            int i = 0;
            while (i < this.buffer.length) {
                this.buffer[i] = 0;
                ++i;
            }
            this.buffer[4] = 0;
            this.buffer[5] = 1;
            int index = 12;
            StringTokenizer tokenizer = new StringTokenizer(query, ".");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                this.buffer[index] = (byte)token.length();
                ++index;
                int subIndex = 0;
                while (subIndex < token.getBytes().length) {
                    this.buffer[index + subIndex] = token.getBytes()[subIndex];
                    ++subIndex;
                }
                index += token.getBytes().length;
            }
            this.buffer[index++] = 0;
            this.buffer[index++] = 0;
            this.buffer[index++] = (byte)(type & 0xFF);
            this.buffer[index++] = 0;
            this.buffer[index++] = 1;
            this.packet = new byte[index];
            int position = 0;
            while (position < index) {
                this.packet[position] = this.buffer[position];
                ++position;
            }
            transport.send(this.packet);
            while (true) {
                this.address = transport.receive(this.buffer);
                this.packet = this.buffer;
                this.populateModel(this.resource);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private void populateModel(Resource resource) {
        Network network = null;
        Device device = null;
        boolean found = false;
        Iterator deviceIterator = null;
        if (resource.getContents().isEmpty()) {
            network = ModelFactory.eINSTANCE.createNetwork();
            resource.getContents().add((Object)network);
        } else {
            network = (Network)resource.getContents().get(0);
        }
        deviceIterator = network.getDevice().iterator();
        while (deviceIterator.hasNext()) {
            Device aDevice = (Device)deviceIterator.next();
            if (!aDevice.getAddress().equals(this.address)) continue;
            device = aDevice;
            found = true;
            break;
        }
        if (!found) {
            device = ModelFactory.eINSTANCE.createDevice();
            device.setAddress(this.address);
            network.getDevice().add((Object)device);
        }
        ByteArrayInputStream packetInputStream = new ByteArrayInputStream(this.packet);
        packetInputStream.skip(4L);
        int queriesNumber = packetInputStream.read() << 8 | packetInputStream.read();
        int answersNumber = packetInputStream.read() << 8 | packetInputStream.read();
        packetInputStream.skip(2L);
        int additionalRecordsNumber = packetInputStream.read() << 8 | packetInputStream.read();
        int i = 0;
        while (i < queriesNumber) {
            this.getName(packetInputStream, this.packet);
            packetInputStream.skip(2L);
            packetInputStream.skip(2L);
            ++i;
        }
        i = 0;
        while (i < answersNumber + additionalRecordsNumber) {
            found = false;
            String name = this.getName(packetInputStream, this.packet);
            int type = packetInputStream.read() << 8 | packetInputStream.read();
            packetInputStream.skip(2L);
            packetInputStream.skip(4L);
            switch (type) {
                case 1: {
                    this.handleARecord(packetInputStream, device, name);
                    break;
                }
                case 12: {
                    this.handlePTRRecord(packetInputStream, device, name);
                    break;
                }
                case 33: {
                    this.handleSRVRecord(packetInputStream, device, name);
                    break;
                }
                case 16: {
                    this.handleTXTRecord(packetInputStream, device, name);
                }
            }
            ++i;
        }
    }

    private void handleARecord(ByteArrayInputStream packetInputStream, Device device, String name) {
        int dataLength = packetInputStream.read() << 8 | packetInputStream.read();
        packetInputStream.skip(dataLength);
        if (device != null) {
            device.setName(name.substring(0, name.indexOf(46)));
        }
    }

    private void handlePTRRecord(ByteArrayInputStream packetInputStream, Device device, String name) {
        Matcher matcher;
        Service service = ModelFactory.eINSTANCE.createService();
        ServiceType serviceType = ModelFactory.eINSTANCE.createServiceType();
        packetInputStream.skip(2L);
        String ptrDataName = this.getName(packetInputStream, this.packet);
        String serviceTypeName = name;
        if (!serviceTypeName.equals(this.SERVICE_DISCOVERY_COMMAND) && !serviceTypeName.equals(this.LEGACY_SERVICE_DISCOVERY_COMMAND) && (matcher = this.ptrPattern.matcher(name)).matches()) {
            serviceTypeName = matcher.group(1);
        }
        Iterator serviceTypeIterator = device.getServiceType().iterator();
        boolean found = false;
        while (serviceTypeIterator.hasNext()) {
            ServiceType aServiceType = (ServiceType)serviceTypeIterator.next();
            if (!aServiceType.getName().equals(serviceTypeName)) continue;
            serviceType = aServiceType;
            found = true;
            break;
        }
        if (!found) {
            serviceType = ModelFactory.eINSTANCE.createServiceType();
            serviceType.setName(serviceTypeName);
            device.getServiceType().add((Object)serviceType);
        }
        if (!ptrDataName.equals("")) {
            String serviceName = null;
            if (serviceTypeName.equals(this.SERVICE_DISCOVERY_COMMAND) || serviceTypeName.equals(this.LEGACY_SERVICE_DISCOVERY_COMMAND)) {
                serviceName = ptrDataName;
            } else {
                Matcher matcher2 = this.srvPattern.matcher(ptrDataName);
                if (matcher2.matches()) {
                    serviceName = matcher2.group(1);
                }
            }
            Iterator serviceIterator = serviceType.getService().iterator();
            found = false;
            while (serviceIterator.hasNext()) {
                Service aService = (Service)serviceIterator.next();
                if (!aService.getName().equals(serviceName)) continue;
                service = aService;
                found = true;
                break;
            }
            if (!found) {
                service = ModelFactory.eINSTANCE.createService();
                service.setName(serviceName);
                serviceType.getService().add((Object)service);
            }
        }
    }

    private void handleSRVRecord(ByteArrayInputStream packetInputStream, Device device, String name) {
        Service service = ModelFactory.eINSTANCE.createService();
        ServiceType serviceType = ModelFactory.eINSTANCE.createServiceType();
        int dataLength = (packetInputStream.read() << 8 | packetInputStream.read()) - 6;
        int priority = packetInputStream.read() << 8 | packetInputStream.read();
        int weight = packetInputStream.read() << 8 | packetInputStream.read();
        int port = packetInputStream.read() << 8 | packetInputStream.read();
        byte[] data = new byte[dataLength];
        try {
            packetInputStream.read(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String serviceTypeName = null;
        String serviceName = null;
        Matcher matcher = this.srvPattern.matcher(name);
        if (matcher.matches()) {
            serviceTypeName = matcher.group(2);
            serviceName = matcher.group(1);
        }
        Iterator serviceTypeIterator = device.getServiceType().iterator();
        boolean found = false;
        while (serviceTypeIterator.hasNext()) {
            ServiceType aServiceType = (ServiceType)serviceTypeIterator.next();
            if (!aServiceType.getName().equals(serviceTypeName)) continue;
            serviceType = aServiceType;
            found = true;
            break;
        }
        if (!found) {
            serviceType = ModelFactory.eINSTANCE.createServiceType();
            serviceType.setName(serviceTypeName);
            device.getServiceType().add((Object)serviceType);
        }
        Iterator serviceIterator = serviceType.getService().iterator();
        found = false;
        while (serviceIterator.hasNext()) {
            Service temp = (Service)serviceIterator.next();
            if (!temp.getName().equals(serviceName)) continue;
            service = temp;
            found = true;
            break;
        }
        if (!found) {
            service = ModelFactory.eINSTANCE.createService();
            service.setName(serviceName);
            serviceType.getService().add((Object)service);
        }
        service.setName(serviceName);
        String[] keys = new String[]{"port", "priority", "weight"};
        String[] values = new String[]{String.valueOf(port), String.valueOf(priority), String.valueOf(weight)};
        int i = 0;
        while (i < keys.length) {
            Pair text = null;
            Iterator pairIterator = service.getPair().iterator();
            found = false;
            while (pairIterator.hasNext()) {
                Pair aPair = (Pair)pairIterator.next();
                if (aPair == null || !aPair.getKey().equals(keys[i])) continue;
                String current = aPair.getValue();
                if (!current.equals(values[i])) {
                    aPair.setValue(values[i]);
                }
                found = true;
                break;
            }
            if (!found) {
                text = ModelFactory.eINSTANCE.createPair();
                text.setKey(keys[i]);
                text.setValue(values[i]);
                service.getPair().add((Object)text);
            }
            ++i;
        }
    }

    private void handleTXTRecord(ByteArrayInputStream packetInputStream, Device device, String recordName) {
        ServiceType serviceType = ModelFactory.eINSTANCE.createServiceType();
        Service service = ModelFactory.eINSTANCE.createService();
        int dataLength = packetInputStream.read() << 8 | packetInputStream.read();
        byte[] data = new byte[dataLength];
        try {
            packetInputStream.read(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String serviceName = null;
        String serviceTypeName = null;
        Matcher matcher = this.srvPattern.matcher(recordName);
        if (matcher.matches()) {
            serviceName = matcher.group(1);
            serviceTypeName = matcher.group(2);
        }
        Iterator serviceTypeIterator = device.getServiceType().iterator();
        boolean found = false;
        while (serviceTypeIterator.hasNext()) {
            ServiceType aServiceType = (ServiceType)serviceTypeIterator.next();
            if (aServiceType == null || !aServiceType.getName().equals(serviceTypeName)) continue;
            serviceType = aServiceType;
            found = true;
            break;
        }
        if (!found) {
            serviceType = ModelFactory.eINSTANCE.createServiceType();
            serviceType.setName(serviceTypeName);
            device.getServiceType().add((Object)serviceType);
        }
        Iterator serviceIterator = serviceType.getService().iterator();
        found = false;
        while (serviceIterator.hasNext()) {
            Service aService = (Service)serviceIterator.next();
            if (aService == null || !aService.getName().equals(serviceName)) continue;
            service = aService;
            found = true;
            break;
        }
        if (!found) {
            service = ModelFactory.eINSTANCE.createService();
            service.setName(recordName);
            serviceType.getService().add((Object)service);
        }
        StringBuffer dataBuffer = new StringBuffer();
        int entryLength = 0;
        int j = 0;
        while (j < dataLength) {
            dataBuffer.setLength(0);
            entryLength = data[j];
            int k = 1;
            while (k <= entryLength) {
                dataBuffer.append((char)data[j + k]);
                ++k;
            }
            StringTokenizer stk = new StringTokenizer(dataBuffer.toString(), "=");
            String key = stk.nextToken();
            String value = "true";
            try {
                value = stk.nextToken();
            }
            catch (Exception exception) {}
            Pair text = null;
            Iterator pairIterator = service.getPair().iterator();
            found = false;
            while (pairIterator.hasNext()) {
                Pair aPair = (Pair)pairIterator.next();
                if (aPair == null || !aPair.getKey().equals(key)) continue;
                String current = aPair.getValue();
                if (!current.equals(value)) {
                    aPair.setValue(value);
                }
                found = true;
                break;
            }
            if (!found) {
                text = ModelFactory.eINSTANCE.createPair();
                text.setKey(key);
                text.setValue(value);
                service.getPair().add((Object)text);
            }
            j += entryLength + 1;
        }
    }

    private String getName(ByteArrayInputStream packetInputStream, byte[] packet) {
        StringBuffer buffer = new StringBuffer();
        int nextByte = 0;
        while (true) {
            if (((nextByte = packetInputStream.read()) & 0xC0) == 192) {
                int upperByte = (nextByte & 0x3F) << 8;
                int offset = packetInputStream.read() | upperByte;
                buffer.append(this.getReference(packet, offset));
                break;
            }
            if (nextByte == 0) break;
            int i = 0;
            while (i < nextByte) {
                buffer.append((char)packetInputStream.read());
                ++i;
            }
            buffer.append('.');
        }
        return buffer.toString();
    }

    private String getReference(byte[] packet, int offset) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (packet[offset + i] != 0) {
            int numReads = packet[offset + i];
            if ((numReads & 0xC0) == 192) {
                int upperByte = (numReads & 0x3F) << 8;
                int nextOffset = packet[offset + i + 1] | upperByte;
                buffer.append(this.getReference(packet, nextOffset));
                break;
            }
            int j = 0;
            while (j < numReads) {
                buffer.append((char)packet[offset + i + j + 1]);
                ++j;
            }
            buffer.append('.');
            i += numReads + 1;
        }
        return buffer.toString();
    }
}

