/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.discovery.view;

import java.net.UnknownHostException;
import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.tm.discovery.engine.ServiceDiscoveryEngine;
import org.eclipse.tm.discovery.model.Service;
import org.eclipse.tm.discovery.model.provider.ModelItemProviderAdapterFactory;
import org.eclipse.tm.discovery.protocol.IProtocol;
import org.eclipse.tm.discovery.protocol.ProtocolFactory;
import org.eclipse.tm.discovery.transport.ITransport;
import org.eclipse.tm.discovery.transport.TransportFactory;
import org.eclipse.tm.discovery.view.Messages;
import org.eclipse.tm.discovery.wizard.ServiceDiscoveryWizardMainPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.part.ViewPart;

public class ServiceDiscoveryView
extends ViewPart {
    private TreeViewer treeViewer;
    private ViewerPane viewerPaneTree;
    private TableViewer tableViewer;
    private ViewerPane viewerPaneTable;
    private String query = null;
    private Table table;
    private Action discoveryAction;
    private Action refreshAction;
    private Action clearAction;
    private ITransport transport = null;
    private IProtocol protocol = null;
    private ServiceDiscoveryWizardMainPage serviceDiscoveryWizardMainPage;
    private Resource resource;
    private ServiceDiscoveryEngine serviceDiscoveryEngine = ServiceDiscoveryEngine.getServiceDiscoveryEngine();

    public void createPartControl(Composite parent) {
        this.resource = this.serviceDiscoveryEngine.getResource();
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ModelItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(factories);
        Composite comp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        comp.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        SashForm sashForm = new SashForm(comp, 0);
        sashForm.setOrientation(256);
        sashForm.setLayoutData((Object)data);
        this.viewerPaneTree = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

            public Viewer createViewer(Composite composite) {
                Tree tree = new Tree(composite, 0);
                ContainerCheckedTreeViewer treeViewer = new ContainerCheckedTreeViewer(tree);
                return treeViewer;
            }

            public void requestActivation() {
                super.requestActivation();
            }
        };
        Composite sashComposite = new Composite((Composite)sashForm, 2048);
        sashComposite.setLayout((Layout)new FillLayout());
        this.viewerPaneTree.createControl(sashComposite);
        this.treeViewer = (TreeViewer)this.viewerPaneTree.getViewer();
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        this.viewerPaneTree.setTitle(Messages.ServiceDiscoveryView_ServicesTreeTitle, null);
        this.treeViewer.setInput((Object)this.resource);
        new AdapterFactoryTreeEditor(this.treeViewer.getTree(), (AdapterFactory)adapterFactory);
        ((ContainerCheckedTreeViewer)this.viewerPaneTree.getViewer()).addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EObject obj;
                if (!event.getSelection().isEmpty() && (obj = (EObject)((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof Service) {
                    ServiceDiscoveryView.this.tableViewer.setInput((Object)obj);
                }
            }
        });
        this.viewerPaneTable = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

            public Viewer createViewer(Composite composite) {
                return new TableViewer(composite);
            }
        };
        Composite c3 = new Composite((Composite)sashForm, 2048);
        c3.setLayout((Layout)new FillLayout());
        this.viewerPaneTable.createControl(c3);
        this.tableViewer = (TableViewer)this.viewerPaneTable.getViewer();
        this.viewerPaneTable.setTitle(Messages.ServiceDiscoveryView_PropertiesTableTitle, null);
        this.table = this.tableViewer.getTable();
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn objectColumn = new TableColumn(this.table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 100, true));
        objectColumn.setText(Messages.ServiceDiscoveryView_KeyColumnLabel);
        objectColumn.setResizable(true);
        TableColumn selfColumn = new TableColumn(this.table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 100, true));
        selfColumn.setText(Messages.ServiceDiscoveryView_ValueColumnLabel);
        selfColumn.setResizable(true);
        this.tableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        this.makeActions();
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.discoveryAction);
        this.getViewSite().getActionBars().getToolBarManager().add((IContributionItem)new Separator());
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.refreshAction);
        this.getViewSite().getActionBars().getToolBarManager().add((IContributionItem)new Separator());
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.clearAction);
    }

    private void update(String query, String address, String transportName, String protocolName, int timeOut) {
        this.query = query;
        try {
            this.protocol = ProtocolFactory.getProtocol((String)protocolName);
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)new Shell(), (String)Messages.ServiceDiscoveryView_ProtocolErrorDialogTitle, (String)(String.valueOf(Messages.ServiceDiscoveryView_ProtocolErrorDialogMessage) + protocolName));
        }
        try {
            this.transport = TransportFactory.getTransport((String)transportName, (String)address, (int)timeOut);
        }
        catch (UnknownHostException unknownHostException) {
            MessageDialog.openError((Shell)new Shell(), (String)Messages.ServiceDiscoveryView_TransportNoAddressFoundDialogTitle, (String)(String.valueOf(Messages.ServiceDiscoveryView_TransportNoAddressFoundDialogTransport) + address));
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)new Shell(), (String)Messages.ServiceDiscoveryView_TransportErrorDialogTitle, (String)(String.valueOf(Messages.ServiceDiscoveryView_TransportErrorDialogMessage) + transportName));
        }
        if (this.protocol != null && this.transport != null) {
            this.serviceDiscoveryEngine.doServiceDiscovery(query, this.protocol, this.transport);
        }
    }

    private void makeActions() {
        this.discoveryAction = new Action(){

            public void run() {
                Wizard wizard = new Wizard(this){
                    final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public boolean performFinish() {
                        ServiceDiscoveryView.access$2(4.access$0(this.this$1), ServiceDiscoveryView.access$1(4.access$0(this.this$1)).getQuery(), ServiceDiscoveryView.access$1(4.access$0(this.this$1)).getAddress(), ServiceDiscoveryView.access$1(4.access$0(this.this$1)).getTransport(), ServiceDiscoveryView.access$1(4.access$0(this.this$1)).getProtocol(), ServiceDiscoveryView.access$1(4.access$0(this.this$1)).getTimeOut());
                        return true;
                    }
                };
                ServiceDiscoveryView.this.serviceDiscoveryWizardMainPage = new ServiceDiscoveryWizardMainPage();
                wizard.addPage((IWizardPage)ServiceDiscoveryView.this.serviceDiscoveryWizardMainPage);
                Shell shell = new Shell();
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                Rectangle absoluteRect = shell.getMonitor().getClientArea();
                Rectangle shellRect = shell.getBounds();
                shell.setLocation((absoluteRect.width - shellRect.width) / 2, (absoluteRect.height - shellRect.height) / 2);
                dialog.open();
            }

            static /* synthetic */ ServiceDiscoveryView access$0(4 var0) {
                return var0.ServiceDiscoveryView.this;
            }
        };
        this.discoveryAction.setText(Messages.ServiceDiscoveryView_DiscoveryActionText);
        this.discoveryAction.setToolTipText(Messages.ServiceDiscoveryView_DiscoveryActionToolTipText);
        this.discoveryAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.refreshAction = new Action(){

            public void run() {
                if (ServiceDiscoveryView.this.query != null && ServiceDiscoveryView.this.transport != null && ServiceDiscoveryView.this.protocol != null) {
                    ServiceDiscoveryView.this.serviceDiscoveryEngine.doServiceDiscovery(ServiceDiscoveryView.this.query, ServiceDiscoveryView.this.protocol, ServiceDiscoveryView.this.transport);
                }
            }
        };
        this.refreshAction.setText(Messages.ServiceDiscoveryView_RefreshActionText);
        this.refreshAction.setToolTipText(Messages.ServiceDiscoveryView_RefreshActionToolTipText);
        this.refreshAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_REDO"));
        this.clearAction = new Action(){

            public void run() {
                ServiceDiscoveryView.this.resource.getContents().clear();
                ServiceDiscoveryView.this.tableViewer.setInput(null);
            }
        };
        this.clearAction.setText(Messages.ServiceDiscoveryView_ClearActionText);
        this.clearAction.setToolTipText(Messages.ServiceDiscoveryView_ClearActionToolTipText);
        this.clearAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
    }

    public void setFocus() {
    }

    static /* synthetic */ void access$2(ServiceDiscoveryView serviceDiscoveryView, String string, String string2, String string3, String string4, int n) {
        serviceDiscoveryView.update(string, string2, string3, string4, n);
    }
}

