/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.internal.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.comm.CommPortIdentifier;
import javax.comm.CommPortOwnershipListener;
import javax.comm.SerialPort;
import org.eclipse.tm.terminal.ISettingsPage;
import org.eclipse.tm.terminal.ISettingsStore;
import org.eclipse.tm.terminal.ITerminalConnector;
import org.eclipse.tm.terminal.ITerminalControl;
import org.eclipse.tm.terminal.Logger;
import org.eclipse.tm.terminal.TerminalState;
import org.eclipse.tm.terminal.internal.serial.ISerialSettings;
import org.eclipse.tm.terminal.internal.serial.SerialConnectWorker;
import org.eclipse.tm.terminal.internal.serial.SerialPortHandler;
import org.eclipse.tm.terminal.internal.serial.SerialSettings;
import org.eclipse.tm.terminal.internal.serial.SerialSettingsPage;

public class SerialConnector
implements ITerminalConnector {
    private OutputStream fOutputStream;
    private InputStream fInputStream;
    private ITerminalControl fControl;
    private SerialPort fSerialPort;
    private CommPortIdentifier fSerialPortIdentifier;
    private SerialPortHandler fTerminalSerialPortHandler;
    private boolean fIsPortInUse;
    private final SerialSettings fSettings;
    static /* synthetic */ Class class$0;

    public SerialConnector() {
        SerialSettings settins = null;
        try {
            settins = new SerialSettings();
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
        }
        this.fSettings = settins;
    }

    public String getId() {
        return this.getClass().getName();
    }

    public boolean isInstalled() {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("javax.comm.SerialPort");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public SerialConnector(SerialSettings settings) {
        this.fSettings = settings;
    }

    public void connect(ITerminalControl control) {
        Logger.log((String)"entered.");
        this.fControl = control;
        SerialConnectWorker worker = new SerialConnectWorker(this, control);
        worker.start();
    }

    public void disconnect() {
        Logger.log((String)"entered.");
        new Thread("Terminal View Serial Port Disconnect Worker"){

            public void run() {
                if (SerialConnector.this.getSerialPortIdentifier() != null) {
                    SerialConnector.this.getSerialPortIdentifier().removePortOwnershipListener((CommPortOwnershipListener)SerialConnector.this.getSerialPortHandler());
                }
                if (SerialConnector.this.getSerialPort() != null) {
                    SerialConnector.this.getSerialPort().removeEventListener();
                    Logger.log((String)"Calling close() on serial port ...");
                    SerialConnector.this.getSerialPort().close();
                }
                if (SerialConnector.this.getInputStream() != null) {
                    try {
                        SerialConnector.this.getInputStream().close();
                    }
                    catch (Exception exception) {
                        Logger.logException((Exception)exception);
                    }
                }
                if (SerialConnector.this.getOutputStream() != null) {
                    try {
                        SerialConnector.this.getOutputStream().close();
                    }
                    catch (Exception exception) {
                        Logger.logException((Exception)exception);
                    }
                }
                SerialConnector.this.setSerialPortIdentifier(null);
                SerialConnector.this.cleanSerialPort();
                SerialConnector.this.setSerialPortHandler(null);
            }
        }.start();
        this.fControl.setState(TerminalState.CLOSED);
    }

    public InputStream getInputStream() {
        return this.fInputStream;
    }

    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    private void setInputStream(InputStream inputStream) {
        this.fInputStream = inputStream;
    }

    private void setOutputStream(OutputStream outputStream) {
        this.fOutputStream = outputStream;
    }

    public boolean isLocalEcho() {
        return false;
    }

    public void setTerminalSize(int newWidth, int newHeight) {
    }

    protected SerialPort getSerialPort() {
        return this.fSerialPort;
    }

    void cleanSerialPort() {
        this.fSerialPort = null;
        this.setInputStream(null);
        this.setOutputStream(null);
    }

    protected void setSerialPort(SerialPort serialPort) throws IOException {
        this.cleanSerialPort();
        if (serialPort != null) {
            this.fSerialPort = serialPort;
            this.setOutputStream(serialPort.getOutputStream());
            this.setInputStream(serialPort.getInputStream());
        }
    }

    protected CommPortIdentifier getSerialPortIdentifier() {
        return this.fSerialPortIdentifier;
    }

    protected void setSerialPortIdentifier(CommPortIdentifier serialPortIdentifier) {
        this.fSerialPortIdentifier = serialPortIdentifier;
    }

    void setSerialPortHandler(SerialPortHandler serialPortHandler) {
        this.fTerminalSerialPortHandler = serialPortHandler;
    }

    SerialPortHandler getSerialPortHandler() {
        return this.fTerminalSerialPortHandler;
    }

    public boolean isPortInUse() {
        return this.fIsPortInUse;
    }

    public void setPortInUse(boolean b) {
        this.fIsPortInUse = true;
    }

    public ISerialSettings getSerialSettings() {
        return this.fSettings;
    }

    public ISettingsPage makeSettingsPage() {
        return new SerialSettingsPage(this.fSettings);
    }

    public String getStatusString(String strConnected) {
        return this.fSettings.getStatusString(strConnected);
    }

    public void load(ISettingsStore store) {
        this.fSettings.load(store);
    }

    public void save(ISettingsStore store) {
        this.fSettings.save(store);
    }
}

