/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.internal.serial;

import java.io.IOException;
import java.text.MessageFormat;
import javax.comm.CommPortOwnershipListener;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.terminal.ITerminalControl;
import org.eclipse.tm.terminal.Logger;
import org.eclipse.tm.terminal.TerminalState;
import org.eclipse.tm.terminal.internal.serial.SerialConnector;
import org.eclipse.tm.terminal.internal.serial.SerialMessages;

public class SerialPortHandler
implements SerialPortEventListener,
CommPortOwnershipListener {
    private final ITerminalControl fControl;
    private final SerialConnector fConn;
    protected byte[] bytes = new byte[2048];

    public SerialPortHandler(SerialConnector conn, ITerminalControl control) {
        this.fControl = control;
        this.fConn = conn;
    }

    public void onSerialDataAvailable(Object data) {
        try {
            while (this.fConn.getInputStream() != null && this.fConn.getInputStream().available() > 0) {
                int nBytes = this.fConn.getInputStream().read(this.bytes);
                this.fControl.writeToTerminal(new String(this.bytes, 0, nBytes));
            }
        }
        catch (IOException ex) {
            this.fControl.displayTextInTerminal(ex.getMessage());
        }
        catch (Exception exception) {
            Logger.logException((Exception)exception);
        }
    }

    public void onSerialOwnershipRequested(Object data) {
        if (this.fConn.isPortInUse()) {
            this.fConn.setPortInUse(false);
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Object[] args = new String[]{SerialPortHandler.this.fConn.getSerialSettings().getSerialPort()};
                String strMsg = MessageFormat.format(SerialMessages.PORT_IN_USE, args);
                if (!MessageDialog.openQuestion((Shell)SerialPortHandler.this.fControl.getShell(), (String)SerialMessages.PROP_TITLE, (String)strMsg)) {
                    return;
                }
                SerialPortHandler.this.fControl.setState(TerminalState.CONNECTING);
            }
        });
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 1: {
                this.onSerialDataAvailable(null);
            }
        }
    }

    public void ownershipChange(int nType) {
        switch (nType) {
            case 3: {
                this.onSerialOwnershipRequested(null);
            }
        }
    }
}

