/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm.terminal.ITerminalControl;
import org.eclipse.tm.terminal.Logger;
import org.eclipse.tm.terminal.TerminalState;
import org.eclipse.tm.terminal.ssh.KeyboardInteractiveDialog;
import org.eclipse.tm.terminal.ssh.SshConnector;
import org.eclipse.tm.terminal.ssh.SshMessages;
import org.eclipse.tm.terminal.ssh.UserValidationDialog;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

class SshConnection
extends Thread {
    private static int fgNo;
    private final ITerminalControl fControl;
    private final SshConnector fConn;
    private Channel fChannel;
    private static String current_ssh_home;
    private static String current_pkeys;
    static String SSH_HOME_DEFAULT;
    private static IPreferenceStore fCvsSsh2PreferenceStore;
    private static IPreferenceStore fCvsUIPreferenceStore;
    private static final String INFO_PROXY_USER = "org.eclipse.team.cvs.core.proxy.user";
    private static final String INFO_PROXY_PASS = "org.eclipse.team.cvs.core.proxy.pass";

    static {
        current_ssh_home = null;
        current_pkeys = "";
        SSH_HOME_DEFAULT = null;
        String ssh_dir_name = ".ssh";
        if (Platform.getOS().equals("win32")) {
            ssh_dir_name = "ssh";
        }
        if ((SSH_HOME_DEFAULT = System.getProperty("user.home")) != null) {
            SSH_HOME_DEFAULT = String.valueOf(SSH_HOME_DEFAULT) + File.separator + ssh_dir_name;
        }
    }

    protected SshConnection(SshConnector conn, ITerminalControl control) {
        super("SshConnection-" + fgNo++);
        this.fControl = control;
        this.fConn = conn;
        this.fControl.setState(TerminalState.CONNECTING);
    }

    static IPreferenceStore getCvsSsh2PreferenceStore() {
        if (fCvsSsh2PreferenceStore == null) {
            fCvsSsh2PreferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.team.cvs.ssh2");
        }
        return fCvsSsh2PreferenceStore;
    }

    static IPreferenceStore getCvsUIPreferenceStore() {
        if (fCvsUIPreferenceStore == null) {
            fCvsUIPreferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.team.cvs.ui");
        }
        return fCvsUIPreferenceStore;
    }

    static void loadSshPrefs(JSch jsch) {
        IPreferenceStore store = SshConnection.getCvsSsh2PreferenceStore();
        String ssh_home = store.getString("CVSSSH2PreferencePage.SSH2HOME");
        String pkeys = store.getString("CVSSSH2PreferencePage.PRIVATEKEY");
        try {
            if (ssh_home.length() == 0) {
                ssh_home = SSH_HOME_DEFAULT;
            }
            if (current_ssh_home == null || !current_ssh_home.equals(ssh_home)) {
                SshConnection.loadKnownHosts(jsch, ssh_home);
                current_ssh_home = ssh_home;
                current_pkeys = "";
            }
            if (!current_pkeys.equals(pkeys)) {
                String[] pkey = pkeys.split(",");
                String[] _pkey = current_pkeys.split(",");
                current_pkeys = "";
                int i = 0;
                while (i < pkey.length) {
                    File file = new File(pkey[i]);
                    if (!file.isAbsolute()) {
                        file = new File(ssh_home, pkey[i]);
                    }
                    if (file.exists()) {
                        boolean notyet = true;
                        int j = 0;
                        while (j < _pkey.length) {
                            if (pkey[i].equals(_pkey[j])) {
                                notyet = false;
                                break;
                            }
                            ++j;
                        }
                        if (notyet) {
                            jsch.addIdentity(file.getPath());
                        }
                        current_pkeys = current_pkeys.length() == 0 ? pkey[i] : String.valueOf(current_pkeys) + "," + pkey[i];
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
    }

    static void loadKnownHosts(JSch jsch, String ssh_home) {
        try {
            File file = new File(ssh_home, "known_hosts");
            jsch.setKnownHosts(file.getPath());
        }
        catch (Exception exception) {}
    }

    static Proxy loadSshProxyPrefs() {
        IPreferenceStore store = SshConnection.getCvsUIPreferenceStore();
        boolean useProxy = store.getBoolean("proxyEnabled");
        ProxyHTTP proxy = null;
        if (useProxy) {
            String _type = store.getString("proxyType");
            String _host = store.getString("proxyHost");
            String _port = store.getString("proxyPort");
            boolean useAuth = store.getBoolean("proxyAuth");
            String _user = "";
            String _pass = "";
            if (useAuth) {
                Map authInfo = null;
                try {
                    URL FAKE_URL = new URL("http://org.eclipse.team.cvs.proxy.auth");
                    authInfo = Platform.getAuthorizationInfo((URL)FAKE_URL, (String)"proxy", (String)"");
                }
                catch (MalformedURLException malformedURLException) {}
                if (authInfo == null) {
                    authInfo = Collections.EMPTY_MAP;
                }
                _user = (String)authInfo.get(INFO_PROXY_USER);
                _pass = (String)authInfo.get(INFO_PROXY_PASS);
                if (_user == null) {
                    _user = "";
                }
                if (_pass == null) {
                    _pass = "";
                }
            }
            String proxyhost = String.valueOf(_host) + ":" + _port;
            if (_type.equals("HTTP")) {
                proxy = new ProxyHTTP(proxyhost);
                if (useAuth) {
                    proxy.setUserPasswd(_user, _pass);
                }
            } else if (_type.equals("SOCKS5")) {
                proxy = new ProxySOCKS5(proxyhost);
                if (useAuth) {
                    ((ProxySOCKS5)proxy).setUserPasswd(_user, _pass);
                }
            }
        }
        return proxy;
    }

    public void run() {
        try {
            int nTimeout = this.fConn.getTelnetSettings().getTimeout() * 1000;
            String host = this.fConn.getTelnetSettings().getHost();
            String user = this.fConn.getTelnetSettings().getUser();
            String password = this.fConn.getTelnetSettings().getPassword();
            int port = this.fConn.getTelnetSettings().getPort();
            SshConnection.loadSshPrefs(this.fConn.getJsch());
            Proxy proxy = SshConnection.loadSshProxyPrefs();
            Session session = this.fConn.getJsch().getSession(user, host, port);
            if (proxy != null) {
                session.setProxy(proxy);
            }
            session.setTimeout(0);
            session.setPassword(password);
            MyUserInfo ui = new MyUserInfo(null, user, password);
            session.setUserInfo((UserInfo)ui);
            session.connect(nTimeout);
            ChannelShell channel = (ChannelShell)session.openChannel("shell");
            channel.connect();
            this.fConn.setInputStream(channel.getInputStream());
            this.fConn.setOutputStream(channel.getOutputStream());
            this.fConn.setChannel(channel);
            this.fControl.setState(TerminalState.CONNECTED);
            this.readDataForever(this.fConn.getInputStream());
            this.fControl.setState(TerminalState.CLOSED);
        }
        catch (JSchException e) {
            this.connectFailed(e.getMessage(), e.getMessage());
        }
        catch (IOException e) {
            this.connectFailed(e.getMessage(), e.getMessage());
        }
    }

    synchronized void setChannel(Channel channel) {
        this.fChannel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        this.interrupt();
        SshConnection sshConnection = this;
        synchronized (sshConnection) {
            if (this.fChannel != null) {
                this.fChannel.disconnect();
                this.fChannel = null;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readDataForever(InputStream in) throws IOException {
        bytes = new byte[32768];
        ** GOTO lbl15
        {
            try {
                SshConnection.sleep(1L);
            }
            catch (InterruptedException v0) {
                this.interrupt();
                return;
            }
            do {
                if (in.available() == 0) continue block2;
                n = in.read(bytes);
                if (n == -1) {
                    return;
                }
                this.fControl.writeToTerminal(new String(bytes, 0, n, "UTF8"));
lbl15:
                // 2 sources

            } while (!this.isInterrupted());
        }
    }

    protected static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private void connectFailed(String terminalText, String msg) {
        Logger.log((String)terminalText);
        this.fControl.displayTextInTerminal(terminalText);
        this.fControl.setState(TerminalState.CLOSED);
        this.fControl.setMsg(msg);
    }

    private static class MyUserInfo
    implements UserInfo {
        private final String fConnectionId;
        private final String fUser;
        private String fPassword;
        private String fPassphrase;
        private int fAttemptCount;

        public MyUserInfo(String connectionId, String user, String password) {
            this.fConnectionId = connectionId;
            this.fUser = user;
            this.fPassword = password;
        }

        public String getPassword() {
            return this.fPassword;
        }

        public boolean promptYesNo(String str) {
            boolean[] retval = new boolean[1];
            Display.getDefault().syncExec(new Runnable(this, retval, str){
                final /* synthetic */ MyUserInfo this$1;
                private final /* synthetic */ boolean[] val$retval;
                private final /* synthetic */ String val$str;
                {
                    this.this$1 = myUserInfo;
                    this.val$retval = blArray;
                    this.val$str = string;
                }

                public void run() {
                    this.val$retval[0] = MessageDialog.openQuestion(null, (String)SshMessages.WARNING, (String)this.val$str);
                }
            });
            return retval[0];
        }

        private String promptSecret(String message) {
            String[] retval = new String[1];
            SshConnection.getStandardDisplay().syncExec(new Runnable(this, message, retval){
                final /* synthetic */ MyUserInfo this$1;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ String[] val$retval;
                {
                    this.this$1 = myUserInfo;
                    this.val$message = string;
                    this.val$retval = stringArray;
                }

                public void run() {
                    UserValidationDialog uvd = new UserValidationDialog(null, MyUserInfo.access$0(this.this$1), MyUserInfo.access$1(this.this$1), this.val$message);
                    uvd.setUsernameMutable(false);
                    this.val$retval[0] = uvd.open() == 0 ? uvd.getPassword() : null;
                }
            });
            return retval[0];
        }

        public String getPassphrase() {
            return this.fPassphrase;
        }

        public boolean promptPassphrase(String message) {
            this.fPassphrase = this.promptSecret(message);
            return this.fPassphrase != null;
        }

        public boolean promptPassword(String message) {
            String _password = this.promptSecret(message);
            if (_password != null) {
                this.fPassword = _password;
                return true;
            }
            return false;
        }

        public void showMessage(String message) {
            Display.getDefault().syncExec(new Runnable(this, message){
                final /* synthetic */ MyUserInfo this$1;
                private final /* synthetic */ String val$message;
                {
                    this.this$1 = myUserInfo;
                    this.val$message = string;
                }

                public void run() {
                    MessageDialog.openInformation(null, (String)SshMessages.INFO, (String)this.val$message);
                }
            });
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            String[] result;
            block6: {
                if (prompt.length == 0) {
                    return new String[0];
                }
                try {
                    if (this.fAttemptCount == 0 && this.fPassword != null && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                        ++this.fAttemptCount;
                        return new String[]{this.fPassword};
                    }
                    String[][] finResult = new String[1][];
                    SshConnection.getStandardDisplay().syncExec(new Runnable(this, destination, name, instruction, prompt, echo, finResult){
                        final /* synthetic */ MyUserInfo this$1;
                        private final /* synthetic */ String val$destination;
                        private final /* synthetic */ String val$name;
                        private final /* synthetic */ String val$instruction;
                        private final /* synthetic */ String[] val$prompt;
                        private final /* synthetic */ boolean[] val$echo;
                        private final /* synthetic */ String[][] val$finResult;
                        {
                            this.this$1 = myUserInfo;
                            this.val$destination = string;
                            this.val$name = string2;
                            this.val$instruction = string3;
                            this.val$prompt = stringArray;
                            this.val$echo = blArray;
                            this.val$finResult = stringArray2;
                        }

                        public void run() {
                            KeyboardInteractiveDialog dialog = new KeyboardInteractiveDialog(null, MyUserInfo.access$0(this.this$1), this.val$destination, this.val$name, this.val$instruction, this.val$prompt, this.val$echo);
                            dialog.open();
                            this.val$finResult[0] = dialog.getResult();
                        }
                    });
                    result = finResult[0];
                    if (result != null) break block6;
                    return null;
                }
                catch (OperationCanceledException operationCanceledException) {
                    return null;
                }
            }
            if (result.length == 1 && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                this.fPassword = result[0];
            }
            ++this.fAttemptCount;
            return result;
        }

        public void aboutToConnect() {
            this.fAttemptCount = 0;
        }

        public void connectionMade() {
            this.fAttemptCount = 0;
        }

        static /* synthetic */ String access$0(MyUserInfo myUserInfo) {
            return myUserInfo.fConnectionId;
        }

        static /* synthetic */ String access$1(MyUserInfo myUserInfo) {
            return myUserInfo.fUser;
        }
    }
}

