/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.ssh;

import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.tm.terminal.ISettingsPage;
import org.eclipse.tm.terminal.ISettingsStore;
import org.eclipse.tm.terminal.ITerminalConnector;
import org.eclipse.tm.terminal.ITerminalControl;
import org.eclipse.tm.terminal.Logger;
import org.eclipse.tm.terminal.TerminalState;
import org.eclipse.tm.terminal.ssh.ISshSettings;
import org.eclipse.tm.terminal.ssh.SshConnection;
import org.eclipse.tm.terminal.ssh.SshSettings;
import org.eclipse.tm.terminal.ssh.SshSettingsPage;

public class SshConnector
implements ITerminalConnector {
    private OutputStream fOutputStream;
    private InputStream fInputStream;
    private ITerminalControl fControl;
    private JSch fJsch;
    private ChannelShell fChannel;
    private SshConnection fConnection;
    private final SshSettings fSettings;

    public SshConnector() {
        this(new SshSettings());
        try {
            this.fJsch = new JSch();
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
        }
    }

    public SshConnector(SshSettings settings) {
        this.fSettings = settings;
    }

    public String getId() {
        return this.getClass().getName();
    }

    public boolean isInstalled() {
        return this.fJsch != null;
    }

    public void connect(ITerminalControl control) {
        Logger.log((String)"entered.");
        this.fControl = control;
        this.fConnection = new SshConnection(this, control);
        this.fConnection.start();
    }

    public synchronized void disconnect() {
        Logger.log((String)"entered.");
        this.fConnection.disconnect();
        if (this.getInputStream() != null) {
            try {
                this.getInputStream().close();
            }
            catch (Exception exception) {
                Logger.logException((Exception)exception);
            }
        }
        if (this.getOutputStream() != null) {
            try {
                this.getOutputStream().close();
            }
            catch (Exception exception) {
                Logger.logException((Exception)exception);
            }
        }
        this.setState(TerminalState.CLOSED);
    }

    public boolean isLocalEcho() {
        return false;
    }

    public void setTerminalSize(int newWidth, int newHeight) {
        if (this.fChannel != null) {
            this.fChannel.setPtySize(newWidth, newHeight, 8, 8);
        }
    }

    public InputStream getInputStream() {
        return this.fInputStream;
    }

    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    void setInputStream(InputStream inputStream) {
        this.fInputStream = inputStream;
    }

    void setOutputStream(OutputStream outputStream) {
        this.fOutputStream = outputStream;
    }

    public void writeToTerminal(String txt) {
        this.fControl.writeToTerminal(txt);
    }

    public void setState(TerminalState state) {
        this.fControl.setState(state);
    }

    public ISshSettings getTelnetSettings() {
        return this.fSettings;
    }

    public ISettingsPage makeSettingsPage() {
        return new SshSettingsPage(this.fSettings);
    }

    public String getStatusString(String strConnected) {
        return this.fSettings.getStatusString(strConnected);
    }

    public void load(ISettingsStore store) {
        this.fSettings.load(store);
    }

    public void save(ISettingsStore store) {
        this.fSettings.save(store);
    }

    protected JSch getJsch() {
        return this.fJsch;
    }

    ChannelShell getChannel() {
        return this.fChannel;
    }

    void setChannel(ChannelShell channel) {
        this.fChannel = channel;
    }
}

