/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.internal.view;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PageBook
extends Composite {
    private Point minimumPageSize = new Point(0, 0);
    private Control currentPage = null;

    public PageBook(Composite parent, int style) {
        super(parent, style);
        this.setLayout(new PageBookLayout());
    }

    public void showPage(Control page) {
        if (page == this.currentPage) {
            return;
        }
        if (page == null || page.getParent() != this) {
            return;
        }
        this.currentPage = page;
        if (!page.isDisposed()) {
            page.setVisible(true);
            this.layout(true);
        }
        Control[] pages = this.getChildren();
        int i = 0;
        while (i < pages.length) {
            if (pages[i] != page && !pages[i].isDisposed()) {
                pages[i].setVisible(false);
            }
            ++i;
        }
    }

    private class PageBookLayout
    extends Layout {
        private PageBookLayout() {
        }

        public Point computeSize(Composite composite, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            int x = ((PageBook)PageBook.this).minimumPageSize.x;
            int y = ((PageBook)PageBook.this).minimumPageSize.y;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Point size = children[i].computeSize(-1, -1, force);
                x = Math.max(x, size.x);
                y = Math.max(y, size.y);
                ++i;
            }
            if (wHint != -1) {
                x = wHint;
            }
            if (hHint != -1) {
                y = hHint;
            }
            return new Point(x, y);
        }

        public void layout(Composite composite, boolean force) {
            Rectangle rect = composite.getClientArea();
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].setSize(rect.width, rect.height);
                ++i;
            }
        }
    }
}

