/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.internal.view;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm.terminal.internal.view.TerminalViewPlugin;
import org.eclipse.tm.terminal.internal.view.ViewMessages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TerminalPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREF_LIMITOUTPUT = "TerminalPrefLimitOutput";
    public static final String PREF_BUFFERLINES = "TerminalPrefBufferLines";
    public static final String PREF_TIMEOUT_SERIAL = "TerminalPrefTimeoutSerial";
    public static final String PREF_TIMEOUT_NETWORK = "TerminalPrefTimeoutNetwork";
    public static final boolean DEFAULT_LIMITOUTPUT = true;
    public static final int DEFAULT_BUFFERLINES = 1000;
    public static final int DEFAULT_TIMEOUT_SERIAL = 5;
    public static final int DEFAULT_TIMEOUT_NETWORK = 5;
    protected TerminalBooleanFieldEditor fEditorLimitOutput;
    protected IntegerFieldEditor fEditorBufferSize;
    protected IntegerFieldEditor fEditorSerialTimeout;
    protected IntegerFieldEditor fEditorNetworkTimeout;

    public TerminalPreferencePage() {
        super(1);
    }

    public void onLimitOutputSelected() {
        Button ctlButton = this.fEditorLimitOutput.getChangeControl(this.getFieldEditorParent());
        Text ctlText = this.fEditorBufferSize.getTextControl(this.getFieldEditorParent());
        Label ctlLabel = this.fEditorBufferSize.getLabelControl(this.getFieldEditorParent());
        boolean bEnabled = ctlButton.getSelection();
        ctlText.setEnabled(bEnabled);
        ctlLabel.setEnabled(bEnabled);
    }

    protected void createFieldEditors() {
        this.setupPage();
    }

    protected void initialize() {
        super.initialize();
        this.onLimitOutputSelected();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.onLimitOutputSelected();
    }

    public void init(IWorkbench workbench) {
    }

    protected void setupPage() {
        this.setupData();
        this.setupEditors();
        this.setupListeners();
    }

    protected void setupData() {
        TerminalViewPlugin plugin = TerminalViewPlugin.getDefault();
        IPreferenceStore preferenceStore = plugin.getPreferenceStore();
        this.setPreferenceStore(preferenceStore);
    }

    protected void setupEditors() {
        this.fEditorLimitOutput = new TerminalBooleanFieldEditor(PREF_LIMITOUTPUT, ViewMessages.LIMITOUTPUT, this.getFieldEditorParent());
        this.fEditorBufferSize = new IntegerFieldEditor(PREF_BUFFERLINES, ViewMessages.BUFFERLINES, this.getFieldEditorParent());
        this.fEditorSerialTimeout = new IntegerFieldEditor(PREF_TIMEOUT_SERIAL, ViewMessages.SERIALTIMEOUT, this.getFieldEditorParent());
        this.fEditorNetworkTimeout = new IntegerFieldEditor(PREF_TIMEOUT_NETWORK, ViewMessages.NETWORKTIMEOUT, this.getFieldEditorParent());
        this.fEditorBufferSize.setValidRange(0, Integer.MAX_VALUE);
        this.fEditorSerialTimeout.setValidRange(0, Integer.MAX_VALUE);
        this.fEditorNetworkTimeout.setValidRange(0, Integer.MAX_VALUE);
        this.addField((FieldEditor)this.fEditorLimitOutput);
        this.addField((FieldEditor)this.fEditorBufferSize);
        this.addField((FieldEditor)this.fEditorSerialTimeout);
        this.addField((FieldEditor)this.fEditorNetworkTimeout);
    }

    protected void setupListeners() {
        TerminalSelectionHandler selectionHandler = new TerminalSelectionHandler();
        Button ctlButton = this.fEditorLimitOutput.getChangeControl(this.getFieldEditorParent());
        ctlButton.addSelectionListener((SelectionListener)selectionHandler);
    }

    public class TerminalBooleanFieldEditor
    extends BooleanFieldEditor {
        public TerminalBooleanFieldEditor(String strName, String strLabel, Composite ctlParent) {
            super(strName, strLabel, ctlParent);
        }

        public Button getChangeControl(Composite parent) {
            return super.getChangeControl(parent);
        }
    }

    protected class TerminalSelectionHandler
    extends SelectionAdapter {
        protected TerminalSelectionHandler() {
        }

        public void widgetSelected(SelectionEvent event) {
            Button ctlButton;
            Object source = event.getSource();
            if (source == (ctlButton = TerminalPreferencePage.this.fEditorLimitOutput.getChangeControl(TerminalPreferencePage.this.getFieldEditorParent()))) {
                TerminalPreferencePage.this.onLimitOutputSelected();
            }
        }
    }
}

