/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;

public final class Logger {
    public static final String TRACE_DEBUG_LOG = "org.eclipse.tm.terminal/debug/log";
    public static final String TRACE_DEBUG_LOG_ERROR = "org.eclipse.tm.terminal/debug/log/error";
    public static final String TRACE_DEBUG_LOG_INFO = "org.eclipse.tm.terminal/debug/log/info";
    public static final String TRACE_DEBUG_LOG_CHAR = "org.eclipse.tm.terminal/debug/log/char";
    public static final String TRACE_DEBUG_LOG_BUFFER_SIZE = "org.eclipse.tm.terminal/debug/log/buffer/size";
    private static PrintStream logStream;

    static {
        String logFile = null;
        File logDirWindows = new File("C:\\wblogs");
        File logDirUNIX = new File("/tmp/wblogs");
        if (logDirWindows.isDirectory()) {
            logFile = logDirWindows + "\\wbterminal.log";
        } else if (logDirUNIX.isDirectory()) {
            logFile = logDirUNIX + "/wbterminal.log";
        }
        if (logFile != null) {
            try {
                logStream = new PrintStream(new FileOutputStream(logFile, true));
            }
            catch (Exception ex) {
                logStream = System.err;
                logStream.println("Exception when opening log file -- logging to stderr!");
                ex.printStackTrace(logStream);
            }
        }
    }

    public static final void log(String message) {
        if (logStream != null) {
            StackTraceElement caller = new Throwable().getStackTrace()[1];
            int lineNumber = caller.getLineNumber();
            String className = caller.getClassName();
            String methodName = caller.getMethodName();
            className = className.substring(className.lastIndexOf(46) + 1);
            logStream.println(String.valueOf(className) + "." + methodName + ":" + lineNumber + ": " + message);
            logStream.flush();
        }
    }

    public static final void logException(Exception ex) {
        StackTraceElement caller = new Throwable().getStackTrace()[1];
        int lineNumber = caller.getLineNumber();
        String className = caller.getClassName();
        String methodName = caller.getMethodName();
        className = className.substring(className.lastIndexOf(46) + 1);
        PrintStream tmpStream = System.err;
        if (logStream != null) {
            tmpStream = logStream;
        }
        tmpStream.println(String.valueOf(className) + "." + methodName + ":" + lineNumber + ": " + "Caught exception: " + ex);
        ex.printStackTrace(tmpStream);
    }
}

