/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.internal.telnet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.eclipse.tm.terminal.Logger;
import org.eclipse.tm.terminal.TerminalState;
import org.eclipse.tm.terminal.internal.telnet.TelnetCodes;
import org.eclipse.tm.terminal.internal.telnet.TelnetConnector;
import org.eclipse.tm.terminal.internal.telnet.TelnetMessages;
import org.eclipse.tm.terminal.internal.telnet.TelnetOption;

public class TelnetConnection
extends Thread
implements TelnetCodes {
    protected static final int STATE_INITIAL = 0;
    protected static final int STATE_IAC_RECEIVED = 1;
    protected static final int STATE_WILL_RECEIVED = 2;
    protected static final int STATE_WONT_RECEIVED = 3;
    protected static final int STATE_DO_RECEIVED = 4;
    protected static final int STATE_DONT_RECEIVED = 5;
    protected static final int STATE_SUBNEGOTIATION_STARTED = 6;
    protected static final int STATE_RECEIVING_SUBNEGOTIATION = 7;
    protected static final int BUFFER_SIZE = 2048;
    protected byte[] rawBytes = new byte[2048];
    protected byte[] processedBytes = new byte[2048];
    protected StringBuffer processedStringBuffer = new StringBuffer(2048);
    protected int telnetState = 0;
    protected boolean remoteIsTelnetServer = false;
    protected TelnetOption[] localOptions = new TelnetOption[256];
    protected TelnetOption[] remoteOptions = new TelnetOption[256];
    protected byte[] receivedSubnegotiation = new byte[128];
    protected int nextSubnegotiationByteIndex = 0;
    protected boolean ignoreSubnegotiation = false;
    protected int width = 0;
    protected int height = 0;
    protected TelnetConnector terminalControl;
    protected Socket socket;
    protected InputStream inputStream;
    protected OutputStream outputStream;
    protected boolean localEcho = true;

    public TelnetConnection(TelnetConnector terminalControl, Socket socket) throws IOException {
        Logger.log("entered");
        this.terminalControl = terminalControl;
        this.socket = socket;
        this.inputStream = socket.getInputStream();
        this.outputStream = socket.getOutputStream();
        this.initializeOptions();
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    public boolean isRemoteTelnetServer() {
        return this.remoteIsTelnetServer;
    }

    public void setTerminalSize(int newWidth, int newHeight) {
        Logger.log("Setting new size: width = " + newWidth + ", height = " + newHeight);
        if (!this.isConnected() || !this.isRemoteTelnetServer()) {
            return;
        }
        boolean sizeChanged = false;
        if (newWidth != this.width || newHeight != this.height) {
            sizeChanged = true;
        }
        this.width = newWidth;
        this.height = newHeight;
        if (sizeChanged && this.remoteIsTelnetServer && this.localOptions[31].isEnabled()) {
            Object[] sizeData = new Integer[]{new Integer(this.width), new Integer(this.height)};
            this.localOptions[31].sendSubnegotiation(sizeData);
        }
    }

    public boolean localEcho() {
        return this.localEcho;
    }

    private void writeToTerminal(String string) {
        this.terminalControl.writeToTerminal(string);
    }

    public void run() {
        Logger.log("Entered");
        try {
            while (this.socket.isConnected()) {
                int nRawBytes = this.inputStream.read(this.rawBytes);
                if (nRawBytes == -1) {
                    Logger.log("End of input reading from socket!");
                    this.writeToTerminal("\r" + TelnetMessages.CONNECTION_CLOSED_BY_FOREIGN_HOST + "\r\n");
                    this.terminalControl.setState(TerminalState.CLOSED);
                    break;
                }
                Logger.log("Received " + nRawBytes + " bytes: '" + new String(this.rawBytes, 0, nRawBytes) + "'");
                int nProcessedBytes = this.processTelnetProtocol(nRawBytes);
                if (nProcessedBytes <= 0) continue;
                this.writeToTerminal(new String(this.processedBytes, 0, nProcessedBytes));
            }
        }
        catch (SocketException ex) {
            String message = ex.getMessage();
            if (message != null && !message.equals("socket closed")) {
                Logger.logException(ex);
            }
        }
        catch (Exception ex) {
            Logger.logException(ex);
        }
    }

    protected void initializeOptions() {
        int i = 0;
        while (i < this.localOptions.length) {
            this.localOptions[i] = new TelnetOption((byte)i, false, true, this.outputStream);
            ++i;
        }
        i = 0;
        while (i < this.localOptions.length) {
            this.remoteOptions[i] = new TelnetOption((byte)i, false, false, this.outputStream);
            ++i;
        }
        this.localOptions[1].setDesired(false);
        this.remoteOptions[1].setDesired(true);
        this.localOptions[3].setDesired(true);
        this.remoteOptions[3].setDesired(true);
        this.localOptions[24].setDesired(true);
        this.remoteOptions[24].setDesired(true);
        this.localOptions[31].setDesired(true);
        this.remoteOptions[31].setDesired(true);
    }

    protected int processTelnetProtocol(int count) {
        int nextProcessedByte = 0;
        int byteIndex = 0;
        while (byteIndex < count) {
            byte inputByte = this.rawBytes[byteIndex];
            block0 : switch (this.telnetState) {
                case 0: {
                    if (inputByte == -1) {
                        this.telnetState = 1;
                        break;
                    }
                    this.processedBytes[nextProcessedByte++] = this.rawBytes[byteIndex];
                    break;
                }
                case 1: {
                    switch (inputByte) {
                        case -1: {
                            this.processedBytes[nextProcessedByte++] = -1;
                            this.telnetState = 0;
                            break block0;
                        }
                        case -5: {
                            this.telnetState = 2;
                            break block0;
                        }
                        case -4: {
                            this.telnetState = 3;
                            break block0;
                        }
                        case -3: {
                            this.telnetState = 4;
                            break block0;
                        }
                        case -2: {
                            this.telnetState = 5;
                            break block0;
                        }
                        case -6: {
                            this.telnetState = 6;
                            break block0;
                        }
                        case -15: 
                        case -14: 
                        case -12: 
                        case -11: 
                        case -10: 
                        case -9: 
                        case -8: 
                        case -7: {
                            this.telnetState = 0;
                            break block0;
                        }
                    }
                    Logger.log("processTelnetProtocol: UNRECOGNIZED TELNET PROTOCOL COMMAND: " + inputByte);
                    this.telnetState = 0;
                    break;
                }
                case 2: {
                    Logger.log("Received WILL " + this.localOptions[inputByte].optionName() + ".");
                    this.remoteOptions[inputByte].handleWill();
                    this.telnetState = 0;
                    this.telnetServerDetected();
                    break;
                }
                case 3: {
                    Logger.log("Received WONT " + this.localOptions[inputByte].optionName() + ".");
                    this.remoteOptions[inputByte].handleWont();
                    this.telnetState = 0;
                    this.telnetServerDetected();
                    break;
                }
                case 4: {
                    Logger.log("Received DO " + this.localOptions[inputByte].optionName() + ".");
                    this.localOptions[inputByte].handleDo();
                    this.telnetState = 0;
                    this.telnetServerDetected();
                    break;
                }
                case 5: {
                    Logger.log("Received DONT " + this.localOptions[inputByte].optionName() + ".");
                    this.localOptions[inputByte].handleDont();
                    this.telnetState = 0;
                    this.telnetServerDetected();
                    break;
                }
                case 6: {
                    Logger.log("Starting subnegotiation for option " + this.localOptions[inputByte].optionName() + ".");
                    int i = 0;
                    while (i < this.receivedSubnegotiation.length) {
                        this.receivedSubnegotiation[i] = 0;
                        ++i;
                    }
                    this.ignoreSubnegotiation = false;
                    this.nextSubnegotiationByteIndex = 0;
                    this.receivedSubnegotiation[this.nextSubnegotiationByteIndex++] = inputByte;
                    this.telnetState = 7;
                    break;
                }
                case 7: {
                    if (inputByte == -1) {
                        if (this.nextSubnegotiationByteIndex > 0 && this.receivedSubnegotiation[this.nextSubnegotiationByteIndex - 1] == -1) {
                            Logger.log("Double IAC in subnegotiation translated into single IAC.");
                            break;
                        }
                        if (this.nextSubnegotiationByteIndex < this.receivedSubnegotiation.length) {
                            this.receivedSubnegotiation[this.nextSubnegotiationByteIndex++] = inputByte;
                            break;
                        }
                        this.receivedSubnegotiation[this.receivedSubnegotiation.length - 1] = inputByte;
                        break;
                    }
                    if (inputByte == -16 && this.receivedSubnegotiation[this.nextSubnegotiationByteIndex - 1] == -1) {
                        Logger.log("Found SE code marking end of subnegotiation.");
                        if (!this.ignoreSubnegotiation) {
                            this.receivedSubnegotiation[this.nextSubnegotiationByteIndex - 1] = 0;
                            byte subnegotiatedOption = this.receivedSubnegotiation[0];
                            this.localOptions[subnegotiatedOption].handleSubnegotiation(this.receivedSubnegotiation, this.nextSubnegotiationByteIndex);
                        } else {
                            Logger.log("NOT CALLING handleSubnegotiation() BECAUSE OF ERRORS!");
                        }
                        this.telnetState = 0;
                    }
                    if (this.nextSubnegotiationByteIndex >= this.receivedSubnegotiation.length) {
                        Logger.log("SUBNEGOTIATION BUFFER FULL!");
                        this.ignoreSubnegotiation = true;
                        break;
                    }
                    Logger.log("Recording subnegotiation byte " + (inputByte & 0xFF));
                    this.receivedSubnegotiation[this.nextSubnegotiationByteIndex++] = inputByte;
                    break;
                }
                default: {
                    Logger.log("INVALID TELNET STATE: " + this.telnetState);
                    this.telnetState = 0;
                }
            }
            ++byteIndex;
        }
        return nextProcessedByte;
    }

    protected void telnetServerDetected() {
        if (!this.remoteIsTelnetServer) {
            this.localEcho = false;
            Logger.log("Detected TELNET server.");
            this.remoteIsTelnetServer = true;
            int i = 0;
            while (i < this.localOptions.length) {
                if (this.localOptions[i].isDesired()) {
                    this.localOptions[i].negotiate();
                }
                ++i;
            }
            i = 0;
            while (i < this.remoteOptions.length) {
                if (this.remoteOptions[i].isDesired()) {
                    this.remoteOptions[i].negotiate();
                }
                ++i;
            }
        }
    }
}

