/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.actions;

import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.internal.ui.view.SystemViewPart;
import org.eclipse.rse.subsystems.files.core.SystemIFileProperties;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileFilterString;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.view.ContextObject;
import org.eclipse.rse.ui.view.IContextObject;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemTree;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.IViewLinker;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.FileEditorInput;

public class LinkWithSystemViewAction
implements IViewActionDelegate {
    private SystemViewPart _systemViewPart;
    private IAction _action;
    private IViewLinker _linker;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void init(IViewPart view) {
        this._systemViewPart = (SystemViewPart)view;
        this._linker = new ViewLinker();
    }

    public void run(IAction action) {
        if (this._systemViewPart != null) {
            boolean isToggled = action.isChecked();
            this._systemViewPart.setLinkingEnabled(isToggled, this._linker);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this._action == null) {
            this._action = action;
            this._action.setChecked(this._systemViewPart.isLinkingEnabled());
        }
        if (this._systemViewPart.isLinkingEnabled() && !this._action.isChecked()) {
            this._action.setChecked(true);
            this._systemViewPart.setLinkingEnabled(true, this._linker);
        }
    }

    private class LinkFromFilterJob
    extends Job {
        private IRemoteFileSubSystem _subSystem;
        private IRemoteFile _targetRemoteFile;
        private ISystemTree _systemTree;

        public LinkFromFilterJob(IRemoteFile targetRemoteFile, ISystemTree systemTree) {
            super(FileResources.MESSAGE_EXPANDING_FILTER);
            this._targetRemoteFile = targetRemoteFile;
            this._subSystem = this._targetRemoteFile.getParentRemoteFileSubSystem();
            this._systemTree = systemTree;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                ISystemFilterReference ref = this.findMatchingFilterReference();
                if (ref == null) {
                    return Status.OK_STATUS;
                }
                IAdaptable iAdaptable = (IAdaptable)ref;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ISystemViewElementAdapter adapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz);
                ContextObject contextObject = new ContextObject((Object)ref, (ISubSystem)this._subSystem, ref);
                Object[] children = adapter.getChildren((IContextObject)contextObject, monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Display.getDefault().asyncExec((Runnable)new ShowChildrenInTree(ref, children, ref, this._systemTree, this._targetRemoteFile));
            }
            catch (Exception exception) {}
            return Status.OK_STATUS;
        }

        private ISystemFilterReference findMatchingFilterReference() {
            String remoteObjectName = this._targetRemoteFile.getAbsolutePath();
            ISystemFilterPoolReferenceManager refmgr = this._subSystem.getFilterPoolReferenceManager();
            if (refmgr != null) {
                ISystemFilterReference[] refs = refmgr.getSystemFilterReferences((ISubSystem)this._subSystem);
                int i = 0;
                while (i < refs.length) {
                    ISystemFilterReference ref = refs[i];
                    if (this.doesFilterEncompass(ref.getReferencedFilter(), remoteObjectName)) {
                        return ref;
                    }
                    ++i;
                }
            }
            return null;
        }

        private boolean doesFilterEncompass(ISystemFilter filter, String remoteObjectAbsoluteName) {
            boolean would = false;
            String[] strings = filter.getFilterStrings();
            if (strings != null) {
                int idx = 0;
                while (!would && idx < strings.length) {
                    if (strings[idx].equals("/*")) {
                        would = true;
                    } else if (strings[idx].equals("./*")) {
                        try {
                            IRemoteFile homeDir = this._subSystem.getRemoteFileObject(".", (IProgressMonitor)new NullProgressMonitor());
                            String homePath = homeDir.getAbsolutePath();
                            would = remoteObjectAbsoluteName.startsWith(homePath);
                        }
                        catch (Exception exception) {}
                    } else {
                        would = this.doesFilterStringEncompass(strings[idx], remoteObjectAbsoluteName);
                    }
                    ++idx;
                }
            }
            return would;
        }

        private boolean doesFilterStringEncompass(String filterString, String remoteObjectAbsoluteName) {
            RemoteFileFilterString rffs = new RemoteFileFilterString(this._subSystem.getParentRemoteFileSubSystemConfiguration(), filterString);
            if (remoteObjectAbsoluteName.endsWith(" -folder")) {
                if (!rffs.getShowSubDirs()) {
                    return false;
                }
                remoteObjectAbsoluteName = remoteObjectAbsoluteName.substring(0, remoteObjectAbsoluteName.indexOf(" -folder"));
            }
            if (!rffs.getShowFiles()) {
                return false;
            }
            String container = rffs.getPath();
            if (container == null) {
                return false;
            }
            if (container.equals(".")) {
                try {
                    container = this._subSystem.getRemoteFileObject(container, (IProgressMonitor)new NullProgressMonitor()).getAbsolutePath();
                }
                catch (Exception exception) {}
            }
            return remoteObjectAbsoluteName.startsWith(container);
        }
    }

    private class LinkFromFolderJob
    extends Job {
        private IRemoteFileSubSystem _subSystem;
        private IRemoteFile _remoteFolder;
        private IRemoteFile _targetRemoteFile;
        private ISystemTree _systemTree;
        private ISystemFilterReference _filterRef;

        public LinkFromFolderJob(IRemoteFile remoteFolder, ISystemFilterReference filterRef, IRemoteFile targetRemoteFile, ISystemTree systemTree) {
            super(FileResources.MESSAGE_EXPANDING_FOLDER);
            this._remoteFolder = remoteFolder;
            this._subSystem = this._remoteFolder.getParentRemoteFileSubSystem();
            this._filterRef = filterRef;
            this._targetRemoteFile = targetRemoteFile;
            this._systemTree = systemTree;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                IAdaptable iAdaptable = (IAdaptable)this._remoteFolder;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ISystemViewElementAdapter adapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz);
                ContextObject contextObject = new ContextObject((Object)this._remoteFolder, (ISubSystem)this._subSystem, this._filterRef);
                Object[] children = adapter.getChildren((IContextObject)contextObject, monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Display.getDefault().asyncExec((Runnable)new ShowChildrenInTree(this._remoteFolder, children, this._filterRef, this._systemTree, this._targetRemoteFile));
            }
            catch (Exception exception) {}
            return Status.OK_STATUS;
        }
    }

    private class SelectFileJob
    extends Job {
        private IRemoteFileSubSystem _subSystem;
        private String _path;
        private ISystemTree _systemTree;

        public SelectFileJob(IRemoteFileSubSystem subSystem, String path, ISystemTree systemTree) {
            super(FileResources.MESSSAGE_QUERYING_FILE);
            this._subSystem = subSystem;
            this._path = path;
            this._systemTree = systemTree;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                IRemoteFile remoteFile = this._subSystem.getRemoteFileObject(this._path, monitor);
                Display.getDefault().asyncExec(new Runnable(this, remoteFile){
                    final /* synthetic */ SelectFileJob this$1;
                    private final /* synthetic */ IRemoteFile val$remoteFile;
                    {
                        this.this$1 = selectFileJob;
                        this.val$remoteFile = iRemoteFile;
                    }

                    public void run() {
                        TreeItem item = (TreeItem)SelectFileJob.access$0(this.this$1).findFirstRemoteItemReference((Object)this.val$remoteFile, null);
                        if (item != null) {
                            SelectFileJob.access$0(this.this$1).getTree().setSelection(item);
                        } else {
                            LinkFromFilterJob job = SelectFileJob.access$1(this.this$1).new LinkFromFilterJob(this.val$remoteFile, SelectFileJob.access$0(this.this$1));
                            job.schedule();
                        }
                    }
                });
            }
            catch (Exception exception) {}
            return Status.OK_STATUS;
        }

        static /* synthetic */ ISystemTree access$0(SelectFileJob selectFileJob) {
            return selectFileJob._systemTree;
        }

        static /* synthetic */ LinkWithSystemViewAction access$1(SelectFileJob selectFileJob) {
            return selectFileJob.LinkWithSystemViewAction.this;
        }
    }

    private class ShowChildrenInTree
    implements Runnable {
        private Object _parentObject;
        private Object[] _children;
        private ISystemTree _systemTree;
        private IRemoteFile _targetRemoteFile;
        private ISystemFilterReference _filterReference;

        public ShowChildrenInTree(Object parentObject, Object[] children, ISystemFilterReference filterReference, ISystemTree systemTree, IRemoteFile targetRemoteFile) {
            this._parentObject = parentObject;
            this._children = children;
            this._systemTree = systemTree;
            this._targetRemoteFile = targetRemoteFile;
            this._filterReference = filterReference;
        }

        public void run() {
            this._systemTree.revealAndExpand(this._filterReference.getSubSystem(), this._filterReference.getReferencedFilter());
            Vector matches = new Vector();
            this._systemTree.findAllRemoteItemReferences(this._parentObject, this._parentObject, matches);
            if (matches.size() > 0) {
                TreeItem item = (TreeItem)matches.get(0);
                this._systemTree.createTreeItems(item, this._children);
                item.setExpanded(true);
                IRemoteFile containingFolder = null;
                int i = 0;
                while (i < item.getItemCount()) {
                    TreeItem childItem = item.getItem(i);
                    Object data = childItem.getData();
                    if (data instanceof IRemoteFile) {
                        IRemoteFile childFile = (IRemoteFile)data;
                        String childPath = childFile.getAbsolutePath();
                        if (childPath.equals(this._targetRemoteFile.getAbsolutePath())) {
                            this._systemTree.getTree().setSelection(childItem);
                            return;
                        }
                        if (this._targetRemoteFile.getAbsolutePath().startsWith(childPath)) {
                            containingFolder = childFile;
                        }
                    }
                    ++i;
                }
                if (containingFolder != null) {
                    LinkFromFolderJob job = new LinkFromFolderJob(containingFolder, this._filterReference, this._targetRemoteFile, this._systemTree);
                    job.schedule();
                }
            }
        }
    }

    public class ViewLinker
    implements IViewLinker {
        public void linkViewToEditor(Object remoteObject, IWorkbenchPage page) {
            Object obj = remoteObject;
            if (obj instanceof IAdaptable) {
                try {
                    ISystemRemoteElementAdapter adapter;
                    IAdaptable iAdaptable = (IAdaptable)obj;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((adapter = (ISystemRemoteElementAdapter)iAdaptable.getAdapter((Class)clazz)) != null && adapter.canEdit(obj)) {
                        IEditorReference[] editorRefs = page.getEditorReferences();
                        int i = 0;
                        while (i < editorRefs.length) {
                            IEditorInput input;
                            IEditorReference editorRef = editorRefs[i];
                            IEditorPart editor = editorRef.getEditor(false);
                            if (editor != null && (input = editor.getEditorInput()) instanceof FileEditorInput) {
                                SystemIFileProperties properties;
                                String path;
                                ((FileEditorInput)input).getFile();
                                IFile file = ((FileEditorInput)input).getFile();
                                if (file.getProject().getName().equals("RemoteSystemsTempFiles") && (path = (properties = new SystemIFileProperties((IResource)file)).getRemoteFilePath()) != null && path.equals(adapter.getAbsoluteName(obj))) {
                                    page.bringToTop((IWorkbenchPart)editor);
                                    return;
                                }
                            }
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void linkEditorToView(IEditorPart editor, ISystemTree systemTree) {
            IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFileEditorInput fileInput = (IFileEditorInput)input;
                fileInput.getFile();
                IFile file = fileInput.getFile();
                SystemIFileProperties properties = new SystemIFileProperties((IResource)file);
                Object rmtEditable = properties.getRemoteFileObject();
                IRemoteFile remoteObj = null;
                IRemoteFileSubSystem subSystem = null;
                if (rmtEditable != null && rmtEditable instanceof ISystemEditableRemoteObject) {
                    ISystemEditableRemoteObject editable = (ISystemEditableRemoteObject)rmtEditable;
                    remoteObj = (IRemoteFile)editable.getRemoteObject();
                    TreeItem item = (TreeItem)systemTree.findFirstRemoteItemReference((Object)remoteObj, null);
                    if (item != null) {
                        systemTree.getTree().setSelection(item);
                    } else {
                        subSystem = remoteObj.getParentRemoteFileSubSystem();
                        LinkFromFilterJob job = new LinkFromFilterJob(remoteObj, systemTree);
                        job.schedule();
                    }
                } else {
                    String subsystemId = properties.getRemoteFileSubSystem();
                    String path = properties.getRemoteFilePath();
                    if (subsystemId != null && path != null && (subSystem = (IRemoteFileSubSystem)RSECorePlugin.getTheSystemRegistry().getSubSystem(subsystemId)) != null) {
                        SelectFileJob job = new SelectFileJob(subSystem, path, systemTree);
                        job.schedule();
                    }
                }
            }
        }
    }
}

