/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.dstore.search;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.IDataStoreProvider;
import org.eclipse.rse.internal.services.dstore.ServiceResources;
import org.eclipse.rse.internal.services.dstore.files.DStoreHostFile;
import org.eclipse.rse.internal.services.dstore.search.DStoreSearchResultConfiguration;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.dstore.AbstractDStoreService;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.services.search.ISearchService;

public class DStoreSearchService
extends AbstractDStoreService
implements ISearchService {
    public DStoreSearchService(IDataStoreProvider provider) {
        super(provider);
    }

    public String getName() {
        return ServiceResources.DStore_Search_Service_Label;
    }

    public String getDescription() {
        return ServiceResources.DStore_Search_Service_Description;
    }

    protected String getMinerId() {
        return "org.eclipse.rse.dstore.universal.miners.UniversalFileSystemMiner";
    }

    public void search(IHostSearchResultConfiguration searchConfig, IFileService fileService, IProgressMonitor monitor) {
        block8: {
            DStoreHostFile searchTarget = (DStoreHostFile)searchConfig.getSearchTarget();
            SystemSearchString searchString = searchConfig.getSearchString();
            String textString = searchString.getTextString();
            boolean isCaseSensitive = searchString.isCaseSensitive();
            boolean isTextRegex = searchString.isTextStringRegex();
            String fileNamesString = searchString.getFileNamesString();
            boolean isFileNamesRegex = searchString.isFileNamesRegex();
            boolean includeArchives = searchString.isIncludeArchives();
            boolean includeSubfolders = searchString.isIncludeSubfolders();
            String classificationString = searchString.getClassificationString();
            DataElement deObj = searchTarget.getDataElement();
            DataStore ds = this.getDataStore();
            DataElement queryCmd = ds.localDescriptorQuery(deObj.getDescriptor(), "C_SEARCH");
            if (queryCmd != null) {
                ArrayList argList = this.setSearchAttributes(textString, isCaseSensitive, isTextRegex, fileNamesString, isFileNamesRegex, includeArchives, includeSubfolders, classificationString, true);
                DataElement status = ds.command(queryCmd, argList, deObj);
                DStoreSearchResultConfiguration config = (DStoreSearchResultConfiguration)searchConfig;
                config.setStatusObject(status);
                try {
                    this.getStatusMonitor(ds).waitForUpdate(status, monitor);
                    String statusStr = status.getName();
                    if (statusStr.equals("done")) {
                        if (status.getNestedSize() > 0) {
                            config.setStatus(1);
                            break block8;
                        }
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (Exception exception) {}
                        config.setStatus(1);
                        break block8;
                    }
                    if (statusStr.equals("cancelled")) {
                        config.setStatus(2);
                    }
                }
                catch (Exception exception) {
                    config.setStatus(2);
                }
            }
        }
    }

    private ArrayList setSearchAttributes(String textString, boolean isCaseSensitive, boolean isTextRegex, String fileNamesString, boolean isFileNamesRegex, boolean includeArchives, boolean includeSubfolders, String classificationString, boolean showHidden) {
        DataStore ds = this.getDataStore();
        DataElement universaltemp = this.getMinerElement();
        DataElement arg1 = ds.createObject(universaltemp, textString, String.valueOf(isCaseSensitive), String.valueOf(isTextRegex));
        DataElement arg2 = ds.createObject(universaltemp, fileNamesString, String.valueOf(isFileNamesRegex), classificationString);
        DataElement arg3 = ds.createObject(universaltemp, String.valueOf(includeArchives), String.valueOf(includeSubfolders), String.valueOf(showHidden));
        ArrayList<DataElement> argList = new ArrayList<DataElement>();
        argList.add(arg1);
        argList.add(arg2);
        argList.add(arg3);
        return argList;
    }

    public void cancelSearch(IHostSearchResultConfiguration searchConfig, IProgressMonitor monitor) {
        DataElement cmdDescriptor;
        DataElement command;
        DataStore dataStore;
        DataElement cancelDescriptor;
        DStoreSearchResultConfiguration config = (DStoreSearchResultConfiguration)searchConfig;
        DataElement status = config.getStatusObject();
        if (status != null && (cancelDescriptor = (dataStore = (command = status.getParent()).getDataStore()).localDescriptorQuery(cmdDescriptor = command.getDescriptor(), "C_CANCEL")) != null) {
            dataStore.command(cancelDescriptor, command);
        }
    }
}

