/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.files;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IFileServiceCodePageConverter;

public class DefaultFileServiceCodePageConverter
implements IFileServiceCodePageConverter {
    public byte[] convertClientStringToRemoteBytes(String remotePath, String clientString, String remoteEncoding, IFileService fs) {
        try {
            return clientString.getBytes(remoteEncoding);
        }
        catch (Exception exception) {
            return clientString.getBytes();
        }
    }

    public void convertFileFromRemoteEncoding(String remotePath, File file, String remoteEncoding, String localEncoding, IFileService fs) {
        try {
            int fileLength = (int)file.length();
            FileInputStream inputStream = new FileInputStream(file);
            BufferedInputStream bufInputStream = new BufferedInputStream(inputStream, fileLength);
            byte[] buffer = new byte[fileLength];
            int bytesRead = bufInputStream.read(buffer, 0, fileLength);
            bufInputStream.close();
            inputStream.close();
            byte[] localBuffer = new String(buffer, 0, bytesRead, remoteEncoding).getBytes(localEncoding);
            FileOutputStream outStream = new FileOutputStream(file);
            outStream.write(localBuffer, 0, localBuffer.length);
            outStream.close();
        }
        catch (Exception exception) {}
    }

    public boolean isServerEncodingSupported(String remoteEncoding, IFileService fs) {
        return true;
    }

    public int getPriority(String remoteEString, IFileService fs) {
        return 1000;
    }
}

