/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.IRSECoreRegistry;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.internal.RSESystemType;

public class RSECoreRegistry
implements IRSECoreRegistry {
    private static RSECoreRegistry instance;
    private IExtensionRegistry registry;
    private boolean hasReadSystemTypes;
    private IRSESystemType[] systemTypes;
    private static final String ELEMENT_SYTEM_TYPE = "systemType";

    private RSECoreRegistry() {
        this.init();
    }

    private void init() {
        this.registry = Platform.getExtensionRegistry();
    }

    public static final RSECoreRegistry getDefault() {
        if (instance == null) {
            instance = new RSECoreRegistry();
        }
        return instance;
    }

    public IRSESystemType[] getSystemTypes() {
        if (!this.hasReadSystemTypes) {
            this.systemTypes = this.readSystemTypes();
            this.hasReadSystemTypes = true;
        }
        return this.systemTypes;
    }

    public IRSESystemType getSystemType(String name) {
        IRSESystemType[] types = this.getSystemTypes();
        int i = 0;
        while (i < types.length) {
            IRSESystemType type = types[i];
            if (type.getName().equals(name)) {
                return type;
            }
            ++i;
        }
        return null;
    }

    public String[] getSystemTypeNames() {
        IRSESystemType[] types = this.getSystemTypes();
        String[] names = new String[types.length];
        int i = 0;
        while (i < types.length) {
            IRSESystemType type = types[i];
            names[i] = type.getName();
            ++i;
        }
        return names;
    }

    private IRSESystemType[] readSystemTypes() {
        IExtensionRegistry registry = this.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.rse.core", "systemTypes");
        IRSESystemType[] types = new IRSESystemType[elements.length];
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals(ELEMENT_SYTEM_TYPE)) {
                RSESystemType type = new RSESystemType(element);
                types[i] = type;
            }
            ++i;
        }
        return types;
    }

    private IExtensionRegistry getExtensionRegistry() {
        return this.registry;
    }
}

