/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.references;

import java.util.Vector;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.references.IRSEBaseReferencedObject;
import org.eclipse.rse.core.references.IRSEBaseReferencingObject;
import org.eclipse.rse.core.subsystems.ISubSystem;

public class SystemReferencedObjectHelper
implements IRSEBaseReferencedObject {
    private Vector referencingObjects = new Vector();
    private IRSEBaseReferencedObject parent = null;

    public SystemReferencedObjectHelper(IRSEBaseReferencedObject parent) {
        this.parent = parent;
    }

    public int addReference(IRSEBaseReferencingObject ref) {
        this.referencingObjects.addElement(ref);
        return this.referencingObjects.size();
    }

    private String getReferencedName() {
        String toName = "unknown";
        if (this.parent instanceof ISystemFilterPool) {
            ISystemFilterPool fp = (ISystemFilterPool)this.parent;
            toName = fp.getName();
        }
        return toName;
    }

    private String getReferencingName(IRSEBaseReferencingObject object) {
        String fromName = "unknown";
        if (object instanceof ISystemFilterPoolReference) {
            ISystemFilterPoolReference fpr = (ISystemFilterPoolReference)object;
            ISystemFilterPoolReferenceManagerProvider provider = fpr.getProvider();
            String prefix = "unknown|unknown|unknown";
            if (provider instanceof ISubSystem) {
                ISubSystem subsystem = (ISubSystem)provider;
                IHost host = subsystem.getHost();
                prefix = String.valueOf(host.getAliasName()) + "|" + subsystem.getName();
                fromName = String.valueOf(prefix) + fpr.getName();
            }
        }
        return fromName;
    }

    public int removeReference(IRSEBaseReferencingObject ref) {
        boolean found = this.referencingObjects.removeElement(ref);
        this.assertThis(!found, "removeReference failed for " + ref);
        return this.referencingObjects.size();
    }

    public int getReferenceCount() {
        return this.referencingObjects.size();
    }

    public void removeAllReferences() {
        IRSEBaseReferencingObject[] references = this.getReferencingObjects();
        int i = 0;
        while (i < references.length) {
            IRSEBaseReferencingObject reference = references[i];
            this.removeReference(reference);
            ++i;
        }
    }

    public IRSEBaseReferencingObject[] getReferencingObjects() {
        IRSEBaseReferencingObject[] references = new IRSEBaseReferencingObject[this.referencingObjects.size()];
        this.referencingObjects.toArray(references);
        return references;
    }

    protected void assertThis(boolean assertion, String msg) {
    }
}

