/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.dstore.universal.miners.command;

import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.dstore.core.miners.miner.MinerThread;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.rse.dstore.universal.miners.command.CommandMiner;
import org.eclipse.rse.dstore.universal.miners.command.OutputHandler;
import org.eclipse.rse.dstore.universal.miners.command.ProcessTracker;
import org.eclipse.rse.dstore.universal.miners.command.patterns.ParsedOutput;
import org.eclipse.rse.dstore.universal.miners.command.patterns.Patterns;
import org.eclipse.rse.dstore.universal.miners.environment.EnvironmentMiner;

public class CommandMinerThread
extends MinerThread {
    private DataElement _status;
    private DataStore _dataStore;
    private String _invocation;
    private DataInputStream _stdInput;
    private DataInputStream _stdError;
    private BufferedWriter _stdOutput;
    private Patterns _patterns;
    private Process _theProcess;
    private ProcessTracker _processTracker;
    private DataElement _subject;
    private String _cwdStr;
    private OutputHandler _stdOutputHandler;
    private OutputHandler _stdErrorHandler;
    private boolean _isShell = false;
    private boolean _isDone = false;
    private boolean _isWindows;
    private boolean _isTTY;
    private boolean _isOS400 = false;
    private boolean _didInitialCWDQuery = false;
    private CommandMiner.CommandMinerDescriptors _descriptors;
    private String PSEUDO_TERMINAL;
    private DataElement _lastPrompt;

    public CommandMinerThread(DataElement theElement, String invocation, DataElement status, Patterns thePatterns, CommandMiner.CommandMinerDescriptors descriptors) {
        this._status = status;
        this._dataStore = theElement.getDataStore();
        this._descriptors = descriptors;
        this._subject = theElement;
        String theOS = System.getProperty("os.name");
        this._invocation = invocation.trim();
        this._patterns = thePatterns;
        this._patterns.refresh(this._invocation);
        if (theOS.toLowerCase().startsWith("os/400")) {
            this._isOS400 = true;
        }
        if (theOS.toLowerCase().startsWith("z")) {
            System.setProperty("dstore.stdin.encoding", "Cp037");
        }
        this._isWindows = theOS.toLowerCase().startsWith("win");
        if (!this._isWindows) {
            this.PSEUDO_TERMINAL = String.valueOf(this._dataStore.getAttribute(0)) + File.separatorChar + "rseterm" + File.separatorChar + "rseterm";
        }
        try {
            File theDirectory;
            this._cwdStr = theElement.getSource();
            if (this._cwdStr == null || this._cwdStr.length() == 0) {
                this._cwdStr = System.getProperty("user.home");
            }
            if (!(theDirectory = new File(this._cwdStr)).isDirectory()) {
                theDirectory = theDirectory.getParentFile();
            }
            try {
                this._cwdStr = theDirectory.getAbsolutePath();
            }
            catch (Exception exception) {
                this._cwdStr = System.getProperty("user.home");
            }
            this._status.setAttribute(4, this._cwdStr);
            String theShell = null;
            if (!this._isWindows) {
                File psuedoTerminal = new File(this.PSEUDO_TERMINAL);
                if (psuedoTerminal.exists()) {
                    this._isTTY = true;
                    this.PSEUDO_TERMINAL = psuedoTerminal.getAbsolutePath();
                } else {
                    this._isTTY = false;
                }
                this._patterns.setIsTerminal(this._isTTY && !this._isOS400);
                String property = "SHELL=";
                String[] env = this.getEnvironment(this._subject);
                int i = 0;
                while (i < env.length) {
                    String var = env[i];
                    if (var.startsWith(property) && (theShell = var.substring(property.length(), var.length())).endsWith("bash")) {
                        theShell = "sh";
                    }
                    if (this._isOS400) {
                        theShell = "/QOpenSys/usr/bin/sh";
                    }
                    ++i;
                }
                if (theShell == null) {
                    if (this._invocation.equals(">")) {
                        this._invocation = "sh";
                        this._isShell = true;
                    }
                    if (this._isTTY) {
                        String[] args = new String[]{this.PSEUDO_TERMINAL, this._invocation};
                        this._theProcess = Runtime.getRuntime().exec(args, env, theDirectory);
                    } else {
                        this._theProcess = Runtime.getRuntime().exec(this._invocation, env, theDirectory);
                    }
                } else if (this._invocation.equals(">")) {
                    this._invocation = theShell;
                    this._isShell = true;
                    if (this._isTTY) {
                        String[] args = null;
                        args = new String[]{this.PSEUDO_TERMINAL, "-w", "256", this._invocation};
                        this._theProcess = Runtime.getRuntime().exec(args, env, theDirectory);
                    } else {
                        this._theProcess = Runtime.getRuntime().exec(this._invocation, env, theDirectory);
                    }
                } else {
                    this._isTTY = false;
                    if (this._isTTY) {
                        String[] args = new String[]{this.PSEUDO_TERMINAL, theShell, "-c", this._invocation};
                        this._theProcess = Runtime.getRuntime().exec(args, env, theDirectory);
                    } else {
                        String[] args = new String[]{theShell, "-c", this._invocation};
                        this._theProcess = Runtime.getRuntime().exec(args, env, theDirectory);
                    }
                }
            } else {
                theShell = theOS.indexOf("95") >= 0 || theOS.indexOf("98") >= 0 || theOS.indexOf("ME") >= 0 ? "start" : "cmd";
                if (this._invocation.equals(">")) {
                    this._invocation = theShell;
                    this._isShell = true;
                }
                String[] args = new String[]{theShell, theShell.equals("start") ? "/B " : "/C ", this._invocation};
                String[] env = this.getEnvironment(this._subject);
                this._theProcess = this._invocation.equals(theShell) ? Runtime.getRuntime().exec(this._invocation, env, theDirectory) : Runtime.getRuntime().exec(args, env, theDirectory);
            }
            OutputStream output = this._theProcess.getOutputStream();
            this._stdInput = new DataInputStream(this._theProcess.getInputStream());
            this._stdError = new DataInputStream(this._theProcess.getErrorStream());
            String specialEncoding = System.getProperty("dstore.stdin.encoding");
            if (specialEncoding != null) {
                try {
                    this._stdOutput = new BufferedWriter(new OutputStreamWriter(output, specialEncoding));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this._stdOutput = new BufferedWriter(new OutputStreamWriter(output));
                }
            } else {
                this._stdOutput = new BufferedWriter(new OutputStreamWriter(output));
            }
        }
        catch (IOException e) {
            this._theProcess = null;
            e.printStackTrace();
            this.createObject("command", e.getMessage());
            status.setAttribute(2, "done");
            return;
        }
        this.createObject("command", this._invocation);
        this.createObject("stdout", "");
        if (this._isShell && !this._isWindows && !this._isTTY) {
            this.createPrompt(String.valueOf(this._cwdStr) + ">", this._cwdStr);
        }
        status.setAttribute(2, "progress");
        this._dataStore.update(status);
        this._dataStore.disconnectObjects(status);
        this._stdOutputHandler = new OutputHandler(this._stdInput, null, this._isWindows || this._isTTY, false, this._isShell, this);
        this._stdOutputHandler.setWaitTime(10);
        this._stdOutputHandler.start();
        this._stdErrorHandler = new OutputHandler(this._stdError, null, this._isWindows || this._isTTY, true, this._isShell, this);
        this._stdErrorHandler.setWaitTime(10);
        this._stdErrorHandler.start();
        this.getCurrentProccesses();
        this.queryCWD();
    }

    public Process getProcess() {
        return this._theProcess;
    }

    public String getCWD() {
        return this._cwdStr;
    }

    public void queryCWD() {
        BufferedWriter writer = this._stdOutput;
        try {
            writer.write("echo '<'PWD=$PWD");
            writer.newLine();
            writer.flush();
        }
        catch (Exception exception) {}
        this._didInitialCWDQuery = true;
    }

    private void getCurrentProccesses() {
    }

    public void sendBreak() {
        if (!this._isWindows && this._processTracker != null) {
            this._processTracker.killLastest();
        }
    }

    public void sendInput(String input) {
        if (!this._isDone) {
            input.getBytes();
            try {
                BufferedWriter writer = this._stdOutput;
                if (input.equals("#break") && !this._isTTY) {
                    this.sendBreak();
                    return;
                }
                if (input.equals("#enter")) {
                    if (this._isOS400) {
                        writer.write("\r");
                    } else {
                        writer.newLine();
                    }
                    writer.flush();
                    return;
                }
                if (this._isShell) {
                    String promptText;
                    if (this._lastPrompt != null && !this._isTTY && (promptText = this._lastPrompt.getName()).endsWith(">")) {
                        this._lastPrompt.setAttribute(2, String.valueOf(promptText) + input);
                        this._dataStore.refresh(this._lastPrompt);
                    }
                    this._patterns.update(input);
                }
                if (!this._isWindows && !this._isTTY) {
                    this.createObject("input", input);
                }
                writer.write(input);
                if (this._isOS400) {
                    writer.write("\r");
                } else {
                    writer.newLine();
                }
                writer.flush();
                if (!this._isWindows && (input.startsWith("cd ") || input.equals("cd"))) {
                    this.queryCWD();
                } else if (!this._didInitialCWDQuery) {
                    this.queryCWD();
                }
                if (!this._isWindows && !this._isTTY && (input.startsWith("cd ") || input.equals("cd"))) {
                    writer.write("echo $PWD'>'");
                    writer.newLine();
                    writer.flush();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this._stdOutputHandler.newCommand();
            }
            catch (IOException e) {
                this.cleanupThread();
                System.out.println(e);
            }
        }
    }

    private String[] getEnvironment(DataElement theSubject) {
        DataElement envMiner = this._dataStore.findMinerInformation(EnvironmentMiner.MINER_ID);
        DataElement systemEnv = this._dataStore.find(envMiner, 2, "System Environment", 1);
        DataElement theProject = theSubject;
        List projectEnvReference = null;
        while (theProject != null && !theProject.getValue().equals("Data")) {
            projectEnvReference = theProject.getAssociated("inhabits");
            if (projectEnvReference.size() > 0) break;
            theProject = theProject.getParent();
        }
        DataElement projectEnv = null;
        if (projectEnvReference != null && projectEnvReference.size() > 0) {
            projectEnv = (DataElement)projectEnvReference.get(0);
        }
        String[] theEnv = this.mergeEnvironments(systemEnv, projectEnv);
        return theEnv;
    }

    private String[] mergeEnvironments(DataElement systemEnv, DataElement projectEnv) {
        String theOS;
        List prjVars = null;
        List sysVars = null;
        if (systemEnv != null) {
            sysVars = systemEnv.getNestedData();
        }
        if (projectEnv != null) {
            prjVars = projectEnv.getNestedData();
        }
        if (sysVars == null || sysVars.size() == 0) {
            return this.listToArray(prjVars);
        }
        if (prjVars == null || prjVars.size() == 0) {
            return this.listToArray(sysVars);
        }
        Hashtable<String, String> varTable = new Hashtable<String, String>();
        varTable.putAll(this.mapVars(sysVars));
        int i = 0;
        while (i < prjVars.size()) {
            DataElement envElement = (DataElement)prjVars.get(i);
            if (envElement.getType().equals("Environment Variable")) {
                String theVariable = envElement.getValue();
                String theKey = this.getKey(theVariable);
                String theValue = this.getValue(theVariable);
                theValue = this.calculateValue(theValue, varTable);
                varTable.put(theKey, theValue);
            }
            ++i;
        }
        if (this._isTTY) {
            varTable.put("PS1", "$PWD/>");
            varTable.put("COLUMNS", "256");
        }
        if ((theOS = System.getProperty("os.name")).toLowerCase().startsWith("os")) {
            varTable.put("QIBM_JAVA_STDIO_CONVERT", "Y");
            varTable.put("QIBM_USE_DESCRIPTOR_STDIO", "I");
            varTable.put("PASE_STDIO_ISATTY", "N");
            varTable.put("TERMINAL_TYPE", "REMOTE");
            varTable.put("STDIO_ISATTY", "Y");
        }
        return this.tableToArray(varTable);
    }

    private String calculateValue(String value, Hashtable theTable) {
        value = value.replaceAll("}", "\n}");
        StringBuffer theValue = new StringBuffer(value);
        try {
            int index = 0;
            while (index < theValue.length()) {
                char c = theValue.charAt(index);
                if (c == '{') {
                    c = theValue.charAt(++index);
                    while (index < theValue.length() && c != '}') {
                        c = theValue.charAt(++index);
                    }
                } else if (c == '$' && !this._isWindows) {
                    int nextIndex = index + 1;
                    if (nextIndex < theValue.length()) {
                        String replacementValue;
                        c = theValue.charAt(nextIndex);
                        if (c == '{') {
                            int next = theValue.toString().indexOf("}", nextIndex);
                            if (next > 0) {
                                replacementValue = this.findValue(theValue.substring(nextIndex + 1, next), theTable, true);
                                theValue.replace(index, next + 1, replacementValue);
                                index += replacementValue.length() - 1;
                            }
                        } else if (Character.isJavaIdentifierStart(c)) {
                            while (nextIndex + 1 < theValue.length() && Character.isJavaIdentifierPart(c)) {
                                c = theValue.charAt(++nextIndex);
                            }
                            String v = theValue.substring(index + 1, nextIndex);
                            replacementValue = this.findValue(v, theTable, true);
                            theValue.replace(index, nextIndex, replacementValue);
                            index += replacementValue.length() - 1;
                        }
                    }
                } else if (c == '%') {
                    int next = theValue.toString().indexOf("%", index + 1);
                    if (next > 0) {
                        String replacementValue = this.findValue(theValue.substring(index + 1, next), theTable, false);
                        theValue.replace(index, next + 1, replacementValue);
                        index += replacementValue.length() - 1;
                    }
                } else if (c == '\"') {
                    c = theValue.charAt(++index);
                    while (index < theValue.length() && c != '\"') {
                        c = theValue.charAt(++index);
                    }
                }
                ++index;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return theValue.toString();
    }

    private String findValue(String key, Hashtable theTable, boolean caseSensitive) {
        Object theValue = null;
        if (caseSensitive) {
            theValue = theTable.get(key);
        } else {
            String matchString = key.toUpperCase();
            Enumeration e = theTable.keys();
            while (e.hasMoreElements()) {
                String theKey = (String)e.nextElement();
                if (!matchString.equals(theKey.toUpperCase())) continue;
                theValue = theTable.get(theKey);
            }
        }
        if (theValue == null) {
            return "";
        }
        return theValue;
    }

    private String getKey(String var) {
        int index = var.indexOf("=");
        if (index < 0) {
            return var;
        }
        return var.substring(0, index);
    }

    private String getValue(String var) {
        var = var.replaceAll("}", "\n}");
        int index = var.indexOf("=") + 1;
        int varLength = var.length();
        if (index < 1 || index == var.length()) {
            return "";
        }
        return var.substring(index, varLength);
    }

    private Hashtable mapVars(List theVars) {
        Hashtable<String, String> theTable = new Hashtable<String, String>();
        int theSize = theVars.size();
        int i = 0;
        while (i < theSize) {
            String theVar = ((DataElement)theVars.get(i)).getValue();
            theTable.put(this.getKey(theVar), this.getValue(theVar));
            ++i;
        }
        return theTable;
    }

    private String[] listToArray(List theList) {
        if (theList == null) {
            theList = new ArrayList();
        }
        int theSize = theList.size();
        String[] theArray = new String[theSize];
        int i = 0;
        while (i < theSize) {
            theArray[i] = ((DataElement)theList.get(i)).getValue();
            ++i;
        }
        return theArray;
    }

    private String[] tableToArray(Hashtable theTable) {
        if (theTable == null) {
            theTable = new Hashtable();
        }
        int theSize = theTable.size();
        String[] theArray = new String[theSize];
        int i = 0;
        Enumeration e = theTable.keys();
        while (e.hasMoreElements()) {
            String theKey = (String)e.nextElement();
            String theValue = (String)theTable.get(theKey);
            theArray[i++] = String.valueOf(theKey) + "=" + theValue;
        }
        return theArray;
    }

    public boolean doThreadedWork() {
        return this._stdOutputHandler != null && !this._stdOutputHandler.isFinished() || this._stdErrorHandler != null && !this._stdErrorHandler.isFinished();
    }

    public void initializeThread() {
    }

    public void sendExit() {
        if (this._isShell) {
            this.sendInput("exit");
        }
    }

    public void cleanupThread() {
        block6: {
            this._isDone = true;
            try {
                this._status.setAttribute(2, "done");
                this._dataStore.refresh(this._status, true);
                this._stdOutputHandler.finish();
                this._stdErrorHandler.finish();
                this._stdInput.close();
                this._stdError.close();
                if (this._theProcess == null) break block6;
                try {
                    if (this._isCancelled) {
                        this._theProcess.destroy();
                    } else {
                        int exitcode = this._theProcess.exitValue();
                        this.createObject("prompt", "> Shell Completed (exit code = " + exitcode + ")");
                    }
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    int exitcode = -1;
                    this._theProcess.destroy();
                }
                this._theProcess = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void interpretLine(String line, boolean stdError) {
        if (line.startsWith("<PWD")) {
            String statement = line.substring(1);
            String[] pair = statement.split("=");
            String value = pair[1];
            this._status.setAttribute(4, value);
            return;
        }
        if (line.indexOf("echo '<'PWD=$PWD") > 0) {
            return;
        }
        ParsedOutput parsedMsg = null;
        try {
            parsedMsg = this._patterns.matchLine(this.removeWhitespace(line));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (parsedMsg == null) {
            if (stdError) {
                this.createObject(this._descriptors._stderr, line);
            } else {
                this.createObject(this._descriptors._stdout, line);
            }
        } else {
            try {
                String fileName = parsedMsg.file;
                if (parsedMsg.type.equals("prompt")) {
                    File promptFile = new File(fileName);
                    if (promptFile.exists()) {
                        this.createPrompt(line, fileName);
                    } else {
                        this.createObject(this._descriptors._stdout, line);
                    }
                } else if (parsedMsg.type.equals("file")) {
                    this.createObject(parsedMsg.type, line, fileName, null);
                } else {
                    this.createObject(parsedMsg.type, line, fileName, new Integer(parsedMsg.line));
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        this._dataStore.refresh(this._status);
        this._dataStore.disconnectObjects(this._status);
    }

    public void createPrompt(String line, String fileName) {
        DataElement lastObject;
        DataElement object = null;
        int size = this._status.getNestedSize();
        if (size > 0 && !(lastObject = this._status.get(size - 1)).getType().equals("prompt")) {
            line = line.replaceAll("//", "/");
            fileName = fileName.replaceAll("//", "/");
            this._lastPrompt = object = this.createObject("prompt", line, fileName, null);
            this._cwdStr = object.getSource();
        }
    }

    public String removeWhitespace(String theLine) {
        StringBuffer strippedLine = new StringBuffer();
        boolean inWhitespace = true;
        int i = 0;
        while (i < theLine.length()) {
            char curChar = theLine.charAt(i);
            if (curChar == '\t') {
                if (!inWhitespace) {
                    strippedLine.append(' ');
                    inWhitespace = true;
                }
            } else if (curChar == ' ') {
                if (!inWhitespace) {
                    strippedLine.append(' ');
                    inWhitespace = true;
                }
            } else {
                strippedLine.append(curChar);
                inWhitespace = false;
            }
            ++i;
        }
        return strippedLine.toString();
    }

    public DataElement createObject(String type, String text) {
        DataElement newObj = null;
        DataElement descriptorType = this._descriptors.getDescriptorFor(type);
        newObj = descriptorType != null ? this._dataStore.createObject(this._status, descriptorType, text, "") : this._dataStore.createObject(this._status, type, text, "");
        return newObj;
    }

    public DataElement createObject(DataElement type, String text) {
        return this._dataStore.createObject(this._status, type, text, "");
    }

    private DataElement createObject(String type, String text, String file, Integer line) {
        DataElement descriptorType = null;
        if (file != null && file.length() > 0) {
            boolean foundFile = false;
            String expectedPath = null;
            File aFile = new File(file);
            if (type.equals("prompt")) {
                descriptorType = this._descriptors._prompt;
                expectedPath = file;
                this._cwdStr = file.replaceAll("//", "/");
            } else if (aFile.exists()) {
                file = expectedPath = aFile.getAbsolutePath();
                if (aFile.isDirectory() && type.equals("file")) {
                    type = "directory";
                }
                foundFile = true;
            } else {
                expectedPath = this._cwdStr.endsWith("/") ? (file.equals("/") ? this._cwdStr : String.valueOf(this._cwdStr) + file) : String.valueOf(this._cwdStr) + "/" + file;
            }
            if (!foundFile) {
                File qfile = new File(expectedPath);
                if (!qfile.exists()) {
                    expectedPath = file;
                    qfile = new File(expectedPath);
                    if (qfile.exists()) {
                        if (qfile.isDirectory() && type.equals("file")) {
                            type = "directory";
                        }
                    } else {
                        File cwdFile = new File(this._cwdStr);
                        String cwdParent = cwdFile.getAbsolutePath();
                        if (cwdFile.getParent() != null) {
                            cwdParent = cwdFile.getParentFile().getAbsolutePath();
                        }
                        if ((qfile = new File(expectedPath = cwdParent.endsWith("/") ? String.valueOf(cwdParent) + file : String.valueOf(cwdParent) + "/" + file)).exists()) {
                            if (qfile.isDirectory() && type.equals("file")) {
                                type = "directory";
                            }
                            file = expectedPath;
                        } else if (type.equals("file")) {
                            type = "stdout";
                            descriptorType = this._descriptors._stdout;
                        } else if (type.equals("error")) {
                            type = "stderr";
                            descriptorType = this._descriptors._stderr;
                        } else {
                            type = "stdout";
                            descriptorType = this._descriptors._stdout;
                        }
                    }
                } else {
                    if (qfile.isDirectory() && type.equals("file")) {
                        type = "directory";
                        expectedPath = expectedPath.replaceAll("//", "/");
                    }
                    file = expectedPath;
                }
            }
            DataElement obj = null;
            if (line == null || line == 1) {
                obj = descriptorType != null ? this._dataStore.createObject(this._status, descriptorType, text, file) : this._dataStore.createObject(this._status, type, text, file);
            } else {
                obj = descriptorType != null ? this._dataStore.createObject(this._status, descriptorType, text, file) : this._dataStore.createObject(this._status, type, text, file);
                obj.setAttribute(4, String.valueOf(obj.getSource()) + ':' + line.toString());
            }
            this._dataStore.refresh(this._status);
            this._dataStore.disconnectObjects(this._status);
            return obj;
        }
        return this.createObject(type, text);
    }
}

