/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.dstore.processes;

import java.util.HashMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.rse.dstore.universal.miners.IUniversalDataStoreConstants;
import org.eclipse.rse.services.clientserver.processes.IHostProcess;
import org.eclipse.rse.services.clientserver.processes.ISystemProcessRemoteConstants;

public class DStoreHostProcess
implements IHostProcess,
IUniversalDataStoreConstants,
IAdaptable,
ISystemProcessRemoteConstants {
    public static final boolean ROOT_TRUE = true;
    public static final boolean ROOT_FALSE = false;
    protected String _name;
    protected String _username;
    protected long _pid = -1L;
    protected long _ppid = -1L;
    protected long _tgid = -1L;
    protected long _tracerPid = -1L;
    protected long _uid = -1L;
    protected long _gid = -1L;
    protected String _label = null;
    protected String _fullyQualifiedProcess;
    protected boolean _isRoot = false;
    protected Object _remoteObj;
    protected HashMap _contents = new HashMap();
    protected boolean _isStale = false;
    protected HashMap _properties = new HashMap();
    protected HashMap _propertyStates = new HashMap();

    public DStoreHostProcess(DataElement dataElementObj) {
        this.init(dataElementObj);
    }

    protected void init(DataElement dataElementObj) {
        this.setProcess(dataElementObj);
        String name = dataElementObj.getName();
        this._fullyQualifiedProcess = "/proc/" + name;
        String s = dataElementObj.getAttribute(3);
        if (s != null && s.length() > 0) {
            this.getAttributes(null);
        }
    }

    protected String getAttributes(String newAttributes) {
        String[] str;
        int tokens;
        DataElement deObj = (DataElement)this.getObject();
        String s = null;
        s = newAttributes == null ? deObj.getAttribute(3) : newAttributes;
        if (s != null && s.length() > 0 && (tokens = (str = s.split("\\|")).length) > 1) {
            try {
                this.setPid(str[0]);
                this.setName(str[1]);
                this.setTgid(str[3]);
                this.setPPid(str[4]);
                if (this._ppid == 0L) {
                    this._isRoot = true;
                }
                this.setTracerPid(str[5]);
                this.setUid(str[6]);
                this.setUsername(str[7]);
                this.setGid(str[8]);
                this.setLabel(str[1]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        return s;
    }

    public void setProcess(Object dataElementObj) {
        this._remoteObj = dataElementObj;
    }

    public Object getObject() {
        return this._remoteObj;
    }

    public String getAbsolutePath() {
        return this._fullyQualifiedProcess;
    }

    public String getLabel() {
        return this._label;
    }

    public long getPid() {
        return this._pid;
    }

    public String getName() {
        return this._name;
    }

    public String getState() {
        String state = this.getSubAttribute(2);
        if (state == null) {
            return " ";
        }
        return state;
    }

    public long getTgid() {
        return this._tgid;
    }

    public long getTracerPid() {
        return this._tracerPid;
    }

    public long getUid() {
        return this._uid;
    }

    public String getUsername() {
        return this._username;
    }

    public long getGid() {
        return this._gid;
    }

    protected void setAbsolutePath(String path) {
        this._fullyQualifiedProcess = path;
    }

    protected void setGid(long gid) {
        this._gid = gid;
    }

    protected void setGid(String newGid) {
        try {
            this._gid = Long.parseLong(newGid);
        }
        catch (NumberFormatException numberFormatException) {
            this._gid = -1L;
        }
    }

    public void setLabel(String newLabel) {
        this._label = newLabel;
    }

    protected void setName(String exeName) {
        this._name = exeName;
    }

    protected void setPid(long newPid) {
        this._pid = newPid;
    }

    protected void setPid(String newPid) {
        try {
            this._pid = Long.parseLong(newPid);
        }
        catch (NumberFormatException numberFormatException) {
            this._pid = -1L;
        }
    }

    protected void setState(String newState) {
        this.setSubAttribute(2, newState);
    }

    protected void setTgid(long tgid) {
        this._tgid = tgid;
    }

    protected void setTgid(String newTgid) {
        try {
            this._tgid = Long.parseLong(newTgid);
        }
        catch (NumberFormatException numberFormatException) {
            this._tgid = -1L;
        }
    }

    protected void setTracerPid(long tracerPid) {
        this._tracerPid = tracerPid;
    }

    protected void setTracerPid(String newTracerPid) {
        try {
            this._tracerPid = Long.parseLong(newTracerPid);
        }
        catch (NumberFormatException numberFormatException) {
            this._tracerPid = -1L;
        }
    }

    protected void setUid(long uid) {
        this._uid = uid;
    }

    protected void setUid(String newUid) {
        try {
            this._uid = Long.parseLong(newUid);
        }
        catch (NumberFormatException numberFormatException) {
            this._uid = -1L;
        }
    }

    protected void setUsername(String username) {
        this._username = username;
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public long getPPid() {
        return this._ppid;
    }

    protected void setPPid(long newPPid) {
        this._ppid = newPPid;
    }

    protected void setPPid(String newPPid) {
        try {
            this._ppid = Long.parseLong(newPPid);
        }
        catch (NumberFormatException numberFormatException) {
            this._ppid = -1L;
        }
    }

    public boolean isRoot() {
        return this._isRoot;
    }

    public String getAllProperties() {
        return this.getAttributes(null);
    }

    protected void setAllProperties(String allProperties) {
        this.getAttributes(allProperties);
    }

    public long getVmSizeInKB() {
        String sizeStr = this.getSubAttribute(9);
        if (sizeStr == null) {
            return 0L;
        }
        long vmsize = 0L;
        try {
            vmsize = Long.parseLong(sizeStr);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
        return vmsize;
    }

    public long getVmRSSInKB() {
        String sizeStr = this.getSubAttribute(10);
        if (sizeStr == null) {
            return 0L;
        }
        long vmrss = 0L;
        try {
            vmrss = Long.parseLong(sizeStr);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
        return vmrss;
    }

    protected void setVmSizeInKB(long size) {
        String sizeStr = "";
        sizeStr = String.valueOf(sizeStr) + size;
        this.setSubAttribute(9, sizeStr);
    }

    protected void setVmRSSInKB(long size) {
        String sizeStr = "";
        sizeStr = String.valueOf(sizeStr) + size;
        this.setSubAttribute(10, sizeStr);
    }

    protected String getSubAttribute(int attIndex) {
        DataElement deObj = (DataElement)this.getObject();
        if (deObj == null) {
            return null;
        }
        String s = deObj.getAttribute(3);
        if (s != null && s.length() > 0) {
            String[] str = s.split("\\|");
            if (attIndex >= str.length) {
                return null;
            }
            if (str[attIndex] == null || str[attIndex].equals("")) {
                return null;
            }
            return str[attIndex];
        }
        return null;
    }

    protected void setSubAttribute(int attIndex, String newSubAttribute) {
        DataElement deObj = (DataElement)this.getObject();
        if (deObj == null) {
            return;
        }
        String s = deObj.getAttribute(3);
        if (s != null && s.length() > 0) {
            String[] str = s.split("\\|");
            if (attIndex >= str.length) {
                return;
            }
            s = "";
            str[attIndex] = newSubAttribute;
            int i = 0;
            while (i < str.length) {
                s = i == str.length - 1 ? String.valueOf(s) + str[i] : String.valueOf(s) + str[i] + "|";
                ++i;
            }
        } else {
            return;
        }
        deObj.setAttribute(3, s);
        DataStore ds = deObj.getDataStore();
        ds.refresh(deObj);
    }
}

