/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.dstore.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.extra.internal.extra.DomainEvent;
import org.eclipse.dstore.extra.internal.extra.DomainNotifier;
import org.eclipse.dstore.extra.internal.extra.IDomainListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DStoreStatusMonitor
implements IDomainListener {
    protected Shell _shell;
    protected boolean _networkDown = false;
    protected List _workingStatuses;
    protected List _cancelledStatuses;
    protected List _doneStatuses;
    protected DataStore _dataStore;

    public DStoreStatusMonitor(DataStore dataStore) {
        this._dataStore = dataStore;
        this.reInit();
    }

    public void reInit() {
        DomainNotifier notifier;
        this._networkDown = false;
        this._workingStatuses = new ArrayList();
        this._doneStatuses = new ArrayList();
        this._cancelledStatuses = new ArrayList();
        if (this._dataStore != null && (notifier = this._dataStore.getDomainNotifier()) != null) {
            notifier.addDomainListener((IDomainListener)this);
        }
    }

    public DataStore getDataStore() {
        return this._dataStore;
    }

    public void dispose() {
        this._workingStatuses.clear();
        this._doneStatuses.clear();
        this._cancelledStatuses.clear();
        this._dataStore.getDomainNotifier().removeDomainListener((IDomainListener)this);
    }

    public boolean listeningTo(DomainEvent event) {
        if (this._workingStatuses.size() == 0) {
            return true;
        }
        DataElement parent = (DataElement)event.getParent();
        if (this._workingStatuses.contains(parent)) {
            return this.determineStatusDone(parent);
        }
        return false;
    }

    public void domainChanged(DomainEvent event) {
        boolean isStatusDone;
        if (this._workingStatuses.size() == 0) {
            return;
        }
        DataElement parent = (DataElement)event.getParent();
        if (this._workingStatuses.contains(parent) && (isStatusDone = this.determineStatusDone(parent))) {
            this.setDone(parent);
            this.notifyUpdate();
        }
    }

    public boolean determineStatusDone(DataElement status) {
        return status.getAttribute(3).equals("done") || status.getAttribute(2).equals("done");
    }

    public boolean isPassiveCommunicationsListener() {
        return false;
    }

    public synchronized void setDone(DataElement status) {
        this._workingStatuses.remove(status);
        this._doneStatuses.add(status);
    }

    public synchronized void setCancelled(DataElement status) {
        this._workingStatuses.remove(status);
        this._cancelledStatuses.add(status);
    }

    public synchronized void setWorking(DataElement status) {
        this._workingStatuses.add(status);
    }

    public boolean wasCancelled(DataElement status) {
        return this._cancelledStatuses.contains(status);
    }

    public Shell getShell() {
        if (this._shell == null || this._shell.isDisposed()) {
            FindShell findShell = new FindShell();
            Display.getDefault().syncExec((Runnable)findShell);
            this._shell = findShell.shell;
        }
        return this._shell;
    }

    public boolean isNetworkDown() {
        return this._networkDown;
    }

    public DataElement waitForUpdate(DataElement status) throws InterruptedException {
        return this.waitForUpdate(status, null, 0);
    }

    public DataElement waitForUpdate(DataElement status, IProgressMonitor monitor) throws InterruptedException {
        return this.waitForUpdate(status, monitor, 0);
    }

    public DataElement waitForUpdate(DataElement status, int wait) throws InterruptedException {
        return this.waitForUpdate(status, null, wait);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized DataElement waitForUpdate(DataElement status, IProgressMonitor monitor, int wait) throws InterruptedException {
        block14: {
            if (this._networkDown && status.getDataStore().isConnected()) {
                this.reInit();
            }
            if (this.determineStatusDone(status)) {
                this.setDone(status);
                return status;
            }
            this.setWorking(status);
            display = Display.getCurrent();
            WaitThreshold = 600;
            if (wait > 0) {
                WaitThreshold = wait * 10;
            } else if (wait == -1) {
                WaitThreshold = -1;
            }
            if (display == null) ** GOTO lbl44
            while (this._workingStatuses.contains(status)) {
                statusDone = this.determineStatusDone(status);
                if (statusDone) {
                    this.setDone(status);
                    continue;
                }
                this.waitForUpdate();
                if (WaitThreshold > 0) {
                    --WaitThreshold;
                }
                if (WaitThreshold == 0) {
                    return status;
                }
                if (!this._networkDown) continue;
                this.dispose();
                throw new InterruptedException();
            }
            break block14;
lbl-1000:
            // 1 sources

            {
                statusDone = this.determineStatusDone(status);
                if (statusDone) {
                    this.setDone(status);
                    continue;
                }
                if (monitor != null && monitor.isCanceled()) {
                    this.setCancelled(status);
                    throw new InterruptedException();
                }
                this.waitForUpdate();
                if (WaitThreshold > 0) {
                    --WaitThreshold;
                }
                if (WaitThreshold == 0) {
                    return status;
                }
                if (!this._networkDown) continue;
                this.dispose();
                throw new InterruptedException();
lbl44:
                // 3 sources

                ** while (this._workingStatuses.contains((Object)status))
            }
        }
        return status;
    }

    public synchronized void waitForUpdate() {
        try {
            this.wait(200L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }

    public synchronized void notifyUpdate() {
        this.notifyAll();
    }

    protected class FindShell
    implements Runnable {
        private Shell shell;

        protected FindShell() {
        }

        public void run() {
            Display display = Display.getCurrent();
            if (display != null) {
                try {
                    Shell[] shells = Display.getCurrent().getShells();
                    int loop = 0;
                    while (loop < shells.length && this.shell == null) {
                        if (shells[loop].isEnabled()) {
                            this.shell = shells[loop];
                        }
                        ++loop;
                    }
                }
                catch (Exception exception) {}
            }
        }
    }
}

