/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.shells.ssh;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.subsystems.shells.servicesubsystem.OutputRefreshJob;
import org.eclipse.rse.internal.subsystems.shells.subsystems.RemoteError;
import org.eclipse.rse.internal.subsystems.shells.subsystems.RemoteOutput;
import org.eclipse.rse.services.shells.IHostOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellChangeEvent;
import org.eclipse.rse.services.shells.ParsedOutput;
import org.eclipse.rse.services.shells.Patterns;
import org.eclipse.rse.services.ssh.shell.SshHostShell;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.shells.core.model.ISystemOutputRemoteTypes;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteOutput;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.ServiceCommandShell;

public class SshServiceCommandShell
extends ServiceCommandShell
implements ISystemOutputRemoteTypes {
    private Patterns _patterns = new Patterns();
    private String _curCommand;
    private String _workingDir;
    private IRemoteFileSubSystem _fs;

    public SshServiceCommandShell(IRemoteCmdSubSystem cmdSS, IHostShell hostShell) {
        super(cmdSS, hostShell);
        this._patterns.update("cmd");
        ISubSystem[] sses = cmdSS.getHost().getSubSystems();
        int i = 0;
        while (i < sses.length) {
            if (sses[i] instanceof IRemoteFileSubSystem) {
                this._fs = (IRemoteFileSubSystem)sses[i];
            }
            ++i;
        }
    }

    public Object getContext() {
        String workingDir = this._workingDir;
        if (workingDir != null && workingDir.length() > 0) {
            try {
                return this._fs.getRemoteFileObject(workingDir);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public void shellOutputChanged(IHostShellChangeEvent event) {
        IHostOutput[] lines = event.getLines();
        boolean gotCommand = false;
        ArrayList<RemoteError> outputs = new ArrayList<RemoteError>(lines.length);
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].getString();
            if (!line.endsWith(this.getPromptCommand())) {
                ParsedOutput parsedMsg = null;
                if (!gotCommand && line.equals(this._curCommand)) {
                    gotCommand = true;
                } else {
                    try {
                        if (this._curCommand == null || !this._curCommand.trim().equals("ls")) {
                            String temp;
                            StringTokenizer tokenizer;
                            parsedMsg = this._patterns.matchLine(line);
                            if (this._curCommand != null && (tokenizer = new StringTokenizer(temp = this._curCommand.trim())).countTokens() == 2) {
                                String token1 = tokenizer.nextToken();
                                String token2 = tokenizer.nextToken();
                                if (token1.equals("ls") && token2.indexOf(45) == 0 && token2.indexOf(108) > 0 && line.startsWith("total")) {
                                    parsedMsg = null;
                                }
                            }
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    Object output = null;
                    String type = "stdout";
                    if (parsedMsg != null) {
                        type = parsedMsg.type;
                    }
                    output = event.isError() ? new RemoteError((Object)this, type) : new RemoteOutput((Object)this, type);
                    output.setText(line);
                    if (parsedMsg != null) {
                        String file = parsedMsg.file;
                        if (type.equals("prompt")) {
                            this._workingDir = file;
                            output.setAbsolutePath(this._workingDir);
                        } else if (this._workingDir != null) {
                            IPath p = new Path(this._workingDir).append(file);
                            output.setAbsolutePath(p.toString());
                        } else {
                            output.setAbsolutePath(file);
                        }
                    }
                    this.addOutput(output);
                    outputs.add((RemoteError)output);
                }
            }
            ++i;
        }
        IRemoteOutput[] remoteOutputs = outputs.toArray(new IRemoteOutput[outputs.size()]);
        this._lastRefreshJob = new OutputRefreshJob((IRemoteCommandShell)this, remoteOutputs, false);
        this._lastRefreshJob.schedule();
    }

    protected String getPromptCommand() {
        IHostShell shell = this.getHostShell();
        if (shell instanceof SshHostShell) {
            return ((SshHostShell)shell).getPromptCommand();
        }
        return "\uffff";
    }

    public void writeToShell(String cmd) {
        this._curCommand = cmd;
        this._patterns.update(cmd);
        super.writeToShell(cmd);
    }
}

