/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui;

import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.rse.internal.useractions.ui.ISystemCommandTextAdditionalGUIProvider;
import org.eclipse.rse.internal.useractions.ui.SystemCmdSubstVarList;
import org.eclipse.rse.internal.useractions.ui.SystemCommandViewerConfiguration;
import org.eclipse.rse.internal.useractions.ui.SystemEditCommandDialog;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.shells.ui.view.ISystemCommandTextModifyListener;
import org.eclipse.rse.shells.ui.view.SystemCommandEditor;
import org.eclipse.rse.ui.ISystemMassager;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class SystemCommandTextField
implements SelectionListener {
    protected SystemCommandEditor textCommand;
    protected ISystemMassager cmdMassager;
    protected Button insertVariableButton;
    protected Button editButton;
    protected boolean menuListenerAdded;
    protected SystemCommandViewerConfiguration sourceViewerConfiguration;
    private String cmdFieldLabel = SystemUDAResources.RESID_UDA_COMMAND_LABEL;
    private String cmdFieldTooltip = SystemUDAResources.RESID_UDA_COMMAND_TOOLTIP;
    private String insertVarButtonLabel = SystemUDAResources.RESID_UDA_INSERTVAR_BUTTON_LABEL;
    private String insertVarButtonTooltip = SystemUDAResources.RESID_UDA_INSERTVAR_BUTTON_TOOLTIP;
    private String editButtonLabel = SystemUDAResources.RESID_UDA_EDIT_BUTTON_LABEL;
    private String editButtonTooltip = SystemUDAResources.RESID_UDA_EDIT_BUTTON_TOOLTIP;
    public static final int MAX_CMD_LENGTH = 512;

    public SystemCommandTextField(SystemCommandViewerConfiguration cmdAssistant) {
        this.sourceViewerConfiguration = cmdAssistant;
    }

    public void setCommandTextViewerConfiguration(SystemCommandViewerConfiguration cmdAssistant) {
        if (this.sourceViewerConfiguration != null && this.textCommand != null && this.sourceViewerConfiguration.getContentAssistant((ISourceViewer)this.textCommand) != null) {
            this.sourceViewerConfiguration.getContentAssistant((ISourceViewer)this.textCommand).uninstall();
        }
        this.sourceViewerConfiguration = cmdAssistant;
        if (this.textCommand != null) {
            this.textCommand.configure((SourceViewerConfiguration)this.sourceViewerConfiguration);
        }
    }

    public void setSubstitutionVariableList(SystemCmdSubstVarList varList) {
        this.sourceViewerConfiguration.setSubstVarList(varList);
    }

    public void setCommandMassager(ISystemMassager massager) {
        this.cmdMassager = massager;
    }

    public ISystemMassager getCommandMassager() {
        return this.cmdMassager;
    }

    public SourceViewer getEditor() {
        return this.textCommand;
    }

    public Control getCommandWidget() {
        return this.textCommand.getControl();
    }

    public String getCommandText() {
        return this.textCommand.getCommandText();
    }

    public String getMassagedCommandText() {
        if (this.cmdMassager == null) {
            return this.getCommandText();
        }
        return this.cmdMassager.massage(this.getCommandText());
    }

    public void setCommandText(String text) {
        this.textCommand.getDocument().set(text);
    }

    public void enableCommandWidget(boolean enable) {
        if (this.textCommand != null) {
            this.textCommand.getTextWidget().setEnabled(enable);
        }
        if (this.insertVariableButton != null) {
            this.insertVariableButton.setEnabled(enable);
        }
        if (this.editButton != null) {
            this.editButton.setEnabled(enable);
        }
    }

    public void setIgnoreChanges(boolean ignore) {
        if (this.textCommand != null) {
            this.textCommand.setIgnoreChanges(ignore);
        }
    }

    public Control createContents(Composite comp, int nbrColumns, ISystemCommandTextAdditionalGUIProvider guiProvider) {
        Label labelCommand = SystemWidgetHelpers.createLabel((Composite)comp, (String)this.cmdFieldLabel, (String)this.cmdFieldTooltip);
        String s = SystemWidgetHelpers.appendColon((String)labelCommand.getText());
        labelCommand.setText(s);
        if (guiProvider == null || !guiProvider.createCommandLabelLineControls(comp, nbrColumns - 1)) {
            ((GridData)labelCommand.getLayoutData()).horizontalSpan = nbrColumns;
        }
        int cmdSpan = nbrColumns;
        this.textCommand = this.createEditor(comp, cmdSpan, this.sourceViewerConfiguration);
        this.textCommand.getControl().setToolTipText(this.cmdFieldTooltip);
        this.insertVariableButton = SystemWidgetHelpers.createPushButton((Composite)comp, null, (String)this.insertVarButtonLabel, (String)this.insertVarButtonTooltip);
        this.editButton = SystemWidgetHelpers.createPushButton((Composite)comp, null, (String)this.editButtonLabel, (String)this.editButtonTooltip);
        if (guiProvider == null || !guiProvider.createExtraButtons(comp, nbrColumns - 1)) {
            this.addFillerLine(comp, nbrColumns - 1);
        }
        this.insertVariableButton.addSelectionListener((SelectionListener)this);
        this.editButton.addSelectionListener((SelectionListener)this);
        return comp;
    }

    public void setMRI(String cmdFieldLabel, String cmdFieldTooltip, String insertVarButtonLabel, String insertVarButtonTooltip) {
        this.cmdFieldLabel = cmdFieldLabel;
        this.cmdFieldTooltip = cmdFieldTooltip;
        this.insertVarButtonLabel = insertVarButtonLabel;
        this.insertVarButtonTooltip = insertVarButtonTooltip;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.insertVariableButton) {
            this.textCommand.getTextWidget().setFocus();
            this.textCommand.doOperation(13);
        } else if (source == this.editButton) {
            SystemCommandViewerConfiguration cfg = new SystemCommandViewerConfiguration();
            cfg.setSubstVarList(this.sourceViewerConfiguration.getSubstVarList());
            SystemEditCommandDialog dlg = new SystemEditCommandDialog(this.getCommandWidget().getShell(), this.getCommandText(), cfg, 2818);
            if (dlg.open() == 0) {
                String str = dlg.getCommand();
                this.textCommand.getDocument().set(str);
            }
        }
    }

    private SystemCommandEditor createEditor(Composite parent, int nbrColumns, SystemCommandViewerConfiguration sourceViewerConfiguration) {
        this.textCommand = new SystemCommandEditor(null, parent, 2818, nbrColumns, (SourceViewerConfiguration)sourceViewerConfiguration, "", SystemUDAResources.RESID_UDA_INSERTVAR_BUTTON_LABEL);
        return this.textCommand;
    }

    public void setCommandValidator(ISystemValidator cmdValidator) {
        if (this.textCommand != null) {
            this.textCommand.setCommandValidator(cmdValidator);
        }
    }

    public SystemMessage validateCommand() {
        if (this.textCommand != null) {
            return this.textCommand.validateCommand();
        }
        return null;
    }

    public void addModifyListener(ISystemCommandTextModifyListener listener) {
        if (this.textCommand != null) {
            this.textCommand.addModifyListener(listener);
        }
    }

    public void removeModifyListener(ISystemCommandTextModifyListener listener) {
        if (this.textCommand != null) {
            this.textCommand.removeModifyListener(listener);
        }
    }

    protected Label addSeparatorLine(Composite parent, int nbrColumns) {
        Label separator = new Label(parent, 258);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        separator.setLayoutData((Object)data);
        return separator;
    }

    protected Label addFillerLine(Composite parent, int nbrColumns) {
        Label filler = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalSpan = nbrColumns;
        data.horizontalAlignment = 4;
        filler.setLayoutData((Object)data);
        return filler;
    }
}

