/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.uda;

import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.model.IProperty;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.IPropertySetContainer;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.internal.useractions.ui.uda.ISystemXMLElementWrapperFactory;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDBaseManager;
import org.eclipse.swt.graphics.Image;

public abstract class SystemXMLElementWrapper
implements IAdaptable {
    protected IPropertySet elm;
    private boolean isDomainElement;
    private SystemUDBaseManager database;
    private ISystemProfile profile;
    private int domainType;
    private static final String UDA_TRUE = "True";
    private static final String UDA_FALSE = "False";
    private static final String UDA_ATTR_VENDOR = "Vendor";
    private static final String UDA_ATTR_CHANGED = "UserChanged";
    private static final String VENDOR_IBM = "IBM";

    public SystemXMLElementWrapper(IPropertySet elm, SystemUDBaseManager mgr, ISystemProfile profile, int domainType) {
        this.elm = elm;
        this.isDomainElement = elm.getPropertyValue("type").equals("Domain");
        this.domainType = domainType;
        this.database = mgr;
        this.profile = profile;
    }

    protected abstract String getTagName();

    public abstract Image getImage();

    public String toString() {
        return this.getName();
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public ISystemProfile getProfile() {
        return this.profile;
    }

    public SystemUDBaseManager getManager() {
        return this.database;
    }

    public IPropertySet getElement() {
        return this.elm;
    }

    public IPropertySet getDocument() {
        return (IPropertySet)this.elm.getContainer();
    }

    public IPropertySet getParentDomainElement() {
        IPropertySet parent = this.getParentElement();
        if (parent != null && parent.getPropertyValue("name").equals("Domain")) {
            return parent;
        }
        return null;
    }

    public IPropertySet getParentElement() {
        IPropertySetContainer parent = this.elm.getContainer();
        if (parent instanceof IPropertySet) {
            return (IPropertySet)parent;
        }
        return null;
    }

    public boolean isDomain() {
        return this.isDomainElement;
    }

    public int getDomain() {
        return this.domainType;
    }

    public String getName() {
        return this.elm.getPropertyValue("name");
    }

    public void setName(String s) {
        String orgName;
        if (this.isIBM() && ((orgName = this.elm.getPropertyValue("OriginalName")) == null || orgName.length() <= 0)) {
            IProperty property = this.elm.getProperty("OriginalName");
            if (property == null) {
                this.elm.addProperty("OriginalName", this.getName());
            } else {
                property.setValue(this.getName());
            }
        }
        this.setAttribute("name", s);
        this.setUserChanged(true);
    }

    public String getOriginalName() {
        String s = this.elm.getPropertyValue("OriginalName");
        if (s == null || s.length() == 0) {
            return this.getName();
        }
        return s;
    }

    public boolean isIBM() {
        String vendor = this.elm.getPropertyValue(UDA_ATTR_VENDOR);
        if (vendor == null) {
            return false;
        }
        return vendor.equals(VENDOR_IBM);
    }

    public void setVendor(String vendor) {
        this.setAttribute(UDA_ATTR_VENDOR, vendor);
    }

    public String getVendor() {
        return this.elm.getPropertyValue(UDA_ATTR_VENDOR);
    }

    public void setIBM(boolean isFromIBM) {
        if (isFromIBM) {
            this.setAttribute(UDA_ATTR_VENDOR, VENDOR_IBM);
        } else {
            this.setAttribute(UDA_ATTR_VENDOR, null);
        }
    }

    public boolean isUserChanged() {
        boolean changed = false;
        changed = !this.isIBM() ? true : (this.isDomainElement ? false : this.getBooleanAttribute(UDA_ATTR_CHANGED, false));
        return changed;
    }

    public void setUserChanged(boolean isUserChanged) {
        if (this.isIBM() && !this.isDomainElement) {
            this.setBooleanAttribute(UDA_ATTR_CHANGED, isUserChanged);
        }
    }

    public void deleteElement() {
        this.elm.getContainer().removePropertySet(this.elm.getName());
    }

    public void setBooleanAttribute(String attr, boolean b) {
        IProperty property = this.elm.getProperty(attr);
        if (property == null) {
            this.elm.addProperty(attr, b ? UDA_TRUE : UDA_FALSE);
        } else {
            property.setValue(b ? UDA_TRUE : UDA_FALSE);
        }
        this.database.setChanged(this.profile);
    }

    public boolean getBooleanAttribute(String attr) {
        String val = this.elm.getPropertyValue(attr);
        return UDA_TRUE.equals(val);
    }

    public boolean getBooleanAttribute(String attr, boolean defaultValue) {
        String val = this.elm.getPropertyValue(attr);
        if (val == null) {
            return defaultValue;
        }
        return UDA_TRUE.equals(val);
    }

    public String getAttribute(String attr, String defaultValue) {
        String value = this.elm.getPropertyValue(attr);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public void setAttribute(String attr, String value) {
        if (value != null) {
            IProperty property = this.elm.getProperty(attr);
            if (property == null) {
                this.elm.addProperty(attr, value);
            } else {
                property.setValue(value);
            }
        } else {
            this.elm.removeProperty(attr);
        }
        this.database.setChanged(this.profile);
    }

    public Vector getExistingNames() {
        IPropertySet parentElement = null;
        String currName = null;
        if (this.isDomain()) {
            parentElement = this.getElement();
        } else {
            parentElement = this.getParentElement();
            currName = this.getName();
        }
        Vector nameList = this.getExistingNames(parentElement, this.getDocument());
        if (currName != null) {
            nameList.remove(currName);
        }
        return nameList;
    }

    public Vector getExistingNames(IPropertySet parentElement, IPropertySet xdoc) {
        return SystemXMLElementWrapper.getExistingNames(parentElement, xdoc, this.getTagName());
    }

    public static Vector getExistingNames(IPropertySet parentElement, IPropertySet xdoc, String tagName) {
        Vector<String> nameList = new Vector<String>();
        IPropertySet[] subList = null;
        subList = parentElement != null ? parentElement.getPropertySets() : xdoc.getPropertySets();
        if (subList != null) {
            int idx = 0;
            while (idx < subList.length) {
                IPropertySet sn = subList[idx];
                if (sn.getPropertyValue("type").equals(tagName)) {
                    nameList.add(sn.getPropertyValue("name"));
                }
                ++idx;
            }
        }
        return nameList;
    }

    public Vector getChildren(Vector children, IPropertySet parentElement, IPropertySet xdoc, ISystemProfile profile) {
        return SystemXMLElementWrapper.getChildren(children, parentElement, xdoc, profile, this.database, this.getDomain());
    }

    public static Vector getChildren(Vector children, IPropertySet parentElement, IPropertySet xdoc, ISystemProfile profile, ISystemXMLElementWrapperFactory factory, int domain) {
        if (children == null) {
            children = new Vector<SystemXMLElementWrapper>();
        }
        String tagName = factory.getTagName();
        IPropertySet[] subList = null;
        subList = parentElement != null ? parentElement.getPropertySets() : xdoc.getPropertySets();
        if (subList != null) {
            int idx = 0;
            while (idx < subList.length) {
                IPropertySet sn = subList[idx];
                if (sn.getPropertyValue("type").equals(tagName)) {
                    SystemXMLElementWrapper thisWrapper = factory.createElementWrapper(sn, profile, domain);
                    children.add(thisWrapper);
                }
                ++idx;
            }
        }
        return children;
    }

    public static IPropertySet findChildByName(IPropertySet parentElement, IPropertySet xdoc, String tagName, String searchName) {
        IPropertySet match = null;
        IPropertySet[] subList = null;
        subList = parentElement != null ? parentElement.getPropertySets() : xdoc.getPropertySets();
        if (subList != null) {
            int idx = 0;
            while (match == null && idx < subList.length) {
                IProperty typeProperty;
                IPropertySet sn = subList[idx];
                if (sn.getName().equals(searchName) && (typeProperty = sn.getProperty("type")).getValue().equals(tagName)) {
                    match = sn;
                }
                ++idx;
            }
        }
        return match;
    }
}

