/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.discovery.wizard;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm.discovery.protocol.ProtocolFactory;
import org.eclipse.tm.discovery.transport.TransportFactory;
import org.eclipse.tm.discovery.wizard.Messages;

public class ServiceDiscoveryWizardMainPage
extends WizardPage {
    private int timeOut = 500;
    private Combo queryCombo;
    private Combo transportCombo;
    private Combo protocolCombo;
    private Text addressText;
    private Text timeOutText;

    public ServiceDiscoveryWizardMainPage() {
        super("wizardPage1");
        this.setTitle(Messages.getString("ServiceDiscoveryWizardMainPage.WizardPageTitle"));
        this.setDescription(Messages.getString("ServiceDiscoveryWizardMainPage.WizardPageDescription"));
        this.setErrorMessage(Messages.getString("ServiceDiscoveryWizardMainPage.ProvideAddressError"));
    }

    public void createControl(Composite parent) {
        FillLayout layout = new FillLayout();
        layout.type = 512;
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)layout);
        new Label(comp, 0).setText(Messages.getString("ServiceDiscoveryWizardMainPage.AddressLabel"));
        this.addressText = new Text(comp, 2116);
        this.addressText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (((Text)e.getSource()).getText().equals("")) {
                    ServiceDiscoveryWizardMainPage.this.setErrorMessage(Messages.getString("ServiceDiscoveryWizardMainPage.ProvideAddressError"));
                    ServiceDiscoveryWizardMainPage.this.setPageComplete(false);
                } else {
                    ServiceDiscoveryWizardMainPage.this.setErrorMessage(null);
                    ServiceDiscoveryWizardMainPage.this.setPageComplete(true);
                }
            }
        });
        new Label(comp, 0).setText(Messages.getString("ServiceDiscoveryWizardMainPage.TransportLabel"));
        this.transportCombo = new Combo(comp, 8);
        this.transportCombo.setItems(TransportFactory.getTransportList());
        this.transportCombo.select(0);
        new Label(comp, 0).setText(Messages.getString("ServiceDiscoveryWizardMainPage.ProtocolLabel"));
        this.protocolCombo = new Combo(comp, 8);
        this.protocolCombo.setItems(ProtocolFactory.getProtocolList());
        this.protocolCombo.select(0);
        this.protocolCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent event) {
                String selectedProtocol = ((Combo)event.getSource()).getText();
                String[] queries = new String[]{};
                try {
                    queries = ProtocolFactory.getQueryList((String)selectedProtocol);
                }
                catch (CoreException coreException) {}
                ServiceDiscoveryWizardMainPage.this.queryCombo.removeAll();
                ServiceDiscoveryWizardMainPage.this.queryCombo.setItems(queries);
                ServiceDiscoveryWizardMainPage.this.queryCombo.select(0);
            }
        });
        new Label(comp, 0).setText(Messages.getString("ServiceDiscoveryWizardMainPage.DiscoveryQueryLabel"));
        this.queryCombo = new Combo(comp, 0);
        String[] queries = new String[]{};
        try {
            queries = ProtocolFactory.getQueryList((String)this.protocolCombo.getText());
        }
        catch (CoreException coreException) {}
        int i = 0;
        while (i < queries.length) {
            this.queryCombo.add(queries[i]);
            ++i;
        }
        this.queryCombo.select(0);
        new Label(comp, 0).setText(Messages.getString("ServiceDiscoveryWizardMainPage.TimeOutLabel"));
        this.timeOutText = new Text(comp, 2116);
        this.timeOutText.setText(Messages.getString("ServiceDiscoveryWizardMainPage.TimeOutValue"));
        this.timeOutText.redraw();
        this.setPageComplete(false);
        this.setControl((Control)comp);
    }

    public String getQuery() {
        return this.queryCombo.getText();
    }

    public String getAddress() {
        return this.addressText.getText();
    }

    public String getTransport() {
        return this.transportCombo.getText();
    }

    public String getProtocol() {
        return this.protocolCombo.getText();
    }

    public int getTimeOut() {
        try {
            this.timeOut = Integer.parseInt(this.timeOutText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {}
        return this.timeOut;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }
}

