/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.internal.telnet;

import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.eclipse.tm.terminal.ITerminalControl;
import org.eclipse.tm.terminal.Logger;
import org.eclipse.tm.terminal.TerminalState;
import org.eclipse.tm.terminal.internal.telnet.TelnetConnection;
import org.eclipse.tm.terminal.internal.telnet.TelnetConnector;

class TelnetConnectWorker
extends Thread {
    private final ITerminalControl fControl;
    private final TelnetConnector fConn;

    protected TelnetConnectWorker(TelnetConnector conn, ITerminalControl control) {
        this.fControl = control;
        this.fConn = conn;
        this.fControl.setState(TerminalState.CONNECTING);
    }

    public void run() {
        try {
            int nTimeout = this.fConn.getTelnetSettings().getTimeout() * 1000;
            String strHost = this.fConn.getTelnetSettings().getHost();
            int nPort = this.fConn.getTelnetSettings().getNetworkPort();
            InetSocketAddress address = new InetSocketAddress(strHost, nPort);
            Socket socket = new Socket();
            socket.connect(address, nTimeout);
            socket.setOOBInline(true);
            this.fConn.setSocket(socket);
            TelnetConnection connection = new TelnetConnection(this.fConn, socket);
            socket.setKeepAlive(true);
            this.fConn.setTelnetConnection(connection);
            connection.start();
            this.fControl.setState(TerminalState.CONNECTED);
        }
        catch (UnknownHostException ex) {
            String txt = "Unknown host: " + ex.getMessage();
            this.connectFailed(txt, "Unknown host: " + ex.getMessage() + "\n");
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.connectFailed(socketTimeoutException.getMessage(), "Connection Error!\n" + socketTimeoutException.getMessage());
        }
        catch (ConnectException connectException) {
            this.connectFailed(connectException.getMessage(), "Connection refused!");
        }
        catch (Exception exception) {
            Logger.logException(exception);
            this.connectFailed(exception.getMessage(), "");
        }
    }

    private void connectFailed(String terminalText, String msg) {
        Logger.log(terminalText);
        this.fControl.displayTextInTerminal(terminalText);
        this.fConn.cleanSocket();
        this.fControl.setState(TerminalState.CLOSED);
        this.fControl.setMsg(msg);
    }
}

