/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.server;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dstore.core.java.IRemoteClassInstance;
import org.eclipse.dstore.core.miners.miner.Miner;
import org.eclipse.dstore.core.model.CommandHandler;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.DataStoreResources;
import org.eclipse.dstore.core.server.MinerLoader;

public class ServerCommandHandler
extends CommandHandler {
    private ArrayList _loaders;
    private MinerLoader _minerLoader;

    public ServerCommandHandler(ArrayList loaders) {
        this._loaders = loaders;
    }

    public void setDataStore(DataStore dataStore) {
        super.setDataStore(dataStore);
    }

    public void loadMiners() {
        if (this._dataStore != null) {
            if (this._minerLoader == null) {
                this._minerLoader = new MinerLoader(this._dataStore, this._loaders);
            }
            this._minerLoader.loadMiners();
        }
    }

    public Miner loadMiner(String minerId) {
        if (this._dataStore != null) {
            Miner miner;
            if (this._minerLoader == null) {
                this._minerLoader = new MinerLoader(this._dataStore, this._loaders);
            }
            if ((miner = this._minerLoader.loadMiner(minerId)) != null) {
                this._minerLoader.connectMiner(miner);
            }
            return miner;
        }
        return null;
    }

    public ArrayList getMiners() {
        return this._minerLoader.getMiners();
    }

    public Miner getMiner(String name) {
        return this._minerLoader.getMiner(name);
    }

    public void finishMiner(String name) {
        this._minerLoader.finishMiner(name);
    }

    public void finish() {
        if (this._minerLoader != null) {
            this._minerLoader.finishMiners();
        }
        super.finish();
    }

    private void clearDeleted(DataElement element, int depth) {
        if (depth > 0 && element != null) {
            int i = 0;
            while (i < element.getNestedSize()) {
                DataElement child = element.get(i);
                if (child != null) {
                    if (child.isReference()) {
                        child = child.dereference();
                    }
                    if (child != null) {
                        if (child.isDeleted()) {
                            element.removeNestedData(child);
                        } else {
                            this.clearDeleted(child, depth - 1);
                        }
                    }
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommands() {
        while (this._commands.size() > 0) {
            DataElement command = null;
            ArrayList arrayList = this._commands;
            synchronized (arrayList) {
                command = (DataElement)this._commands.get(0);
                this.clearDeleted(command, 2);
                this._commands.remove(command);
            }
            DataElement status = command.get(command.getNestedSize() - 1);
            String commandSource = command.getSource();
            String commandName = command.getName();
            this._dataStore.trace("command: " + commandName);
            if (commandName.equals("C_VALIDATE_TICKET")) {
                DataElement serverTicket = this._dataStore.getTicket();
                DataElement clientTicket = command.get(0);
                String st = serverTicket.getName();
                String ct = clientTicket.getName();
                if (ct.equals(st)) {
                    serverTicket.setAttribute(3, DataStoreResources.model_valid);
                    clientTicket.setAttribute(3, DataStoreResources.model_valid);
                    DataElement host = this._dataStore.getHostRoot();
                    this._dataStore.getHashMap().remove(host.getId());
                    host.setAttribute(1, "host." + serverTicket.getName());
                    this._dataStore.getHashMap().put(host.getId(), host);
                    this._dataStore.update(host);
                } else {
                    serverTicket.setAttribute(3, DataStoreResources.model_invalid);
                    clientTicket.setAttribute(3, DataStoreResources.model_invalid);
                }
                this._dataStore.update(clientTicket);
                this._dataStore.startDataElementRemoverThread();
                status.setAttribute(2, DataStoreResources.model_done);
            } else if (commandName.equals("C_SET")) {
                command.get(0);
                status.setAttribute(2, DataStoreResources.model_done);
            } else if (commandName.equals("C_MODIFY")) {
                DataElement dataObject = command.get(0);
                DataElement original = this._dataStore.find(dataObject.getId());
                original.setAttributes(dataObject.getAttributes());
                status.setAttribute(2, DataStoreResources.model_done);
            } else if (commandName.equals("C_SET_HOST")) {
                DataElement dataObject = command.get(0);
                DataElement original = this._dataStore.getHostRoot();
                original.setAttributes(dataObject.getAttributes());
                this._dataStore.setAttribute(7, dataObject.getSource());
                this._dataStore.setAttribute(4, dataObject.getSource());
                status.setAttribute(2, DataStoreResources.model_done);
            } else if (commandName.equals("C_ADD_MINERS")) {
                DataElement location = command.get(1);
                this._dataStore.addMinersLocation(location);
                status.setAttribute(2, DataStoreResources.model_done);
            } else if (commandName.equals("C_ACTIVATE_MINER")) {
                DataElement minerId = command.get(0);
                String minerName = minerId.getName();
                Miner miner = this.loadMiner(minerName);
                miner.initMiner(status);
            } else if (commandName.equals("C_SET_PREFERENCE")) {
                DataElement dataObject = command.get(0);
                String property = dataObject.getName();
                String value = dataObject.getValue();
                this._dataStore.setPreference(property, value);
            } else if (commandName.equals("C_QUERY_INSTALL")) {
                status.setAttribute(4, this._dataStore.getAttribute(0));
                status.setAttribute(2, DataStoreResources.model_done);
            } else if (commandName.equals("C_QUERY_CLIENT_IP")) {
                status.setAttribute(4, this._dataStore.getRemoteIP());
                status.setAttribute(2, DataStoreResources.model_done);
            } else if (commandName.equals("C_QUERY_JVM")) {
                Runtime runtime = Runtime.getRuntime();
                runtime.gc();
                long freeMem = runtime.freeMemory();
                long totalMem = runtime.totalMemory();
                long maxMem = runtime.maxMemory();
                StringBuffer statsBuffer = new StringBuffer();
                statsBuffer.append(freeMem);
                statsBuffer.append(',');
                statsBuffer.append(totalMem);
                statsBuffer.append(',');
                statsBuffer.append(maxMem);
                statsBuffer.append(',');
                statsBuffer.append(this._dataStore.getNumElements());
                statsBuffer.append(',');
                List lastCreated = this._dataStore.getLastCreatedElements();
                int i = 0;
                while (i < lastCreated.size()) {
                    DataElement element = (DataElement)lastCreated.get(i);
                    statsBuffer.append(element.getName());
                    statsBuffer.append(":");
                    statsBuffer.append("id=" + element.getId());
                    statsBuffer.append(";");
                    ++i;
                }
                status.setAttribute(4, statsBuffer.toString());
                status.setAttribute(2, DataStoreResources.model_done);
            } else if (commandName.equals("C_SCHEMA")) {
                this.loadMiners();
                DataElement schemaRoot = this._dataStore.getDescriptorRoot();
                this._dataStore.refresh(schemaRoot);
                status.setAttribute(2, DataStoreResources.model_done);
            } else if (commandName.equals("C_START_SPIRIT")) {
                this._dataStore.receiveStartSpiritCommand();
                status.setAttribute(2, DataStoreResources.model_done);
            } else if (this._dataStore.validTicket() && this._minerLoader != null && status != null) {
                boolean failure = false;
                ArrayList miners = this._minerLoader.getMiners();
                int j = 0;
                while (j < miners.size() && !failure) {
                    Miner miner = (Miner)miners.get(j);
                    if (commandSource.equals("*") || commandSource.equals(miner.getClass().getName())) {
                        if (this._dataStore.isAutoRefreshOn()) {
                            this._dataStore.enableAutoRefresh(false);
                        }
                        miner.requestCommand(command);
                    }
                    ++j;
                }
                if (commandName.equals("C_INIT_MINERS")) {
                    status.setAttribute(2, DataStoreResources.model_done);
                }
            }
            this._dataStore.refresh(status);
        }
    }

    public void sendFile(String fileName, File file) {
    }

    public void sendFile(String fileName, byte[] bytes, int size, boolean binary) {
        this.sendFile(fileName, bytes, size, binary, "default");
    }

    public void sendFile(String fileName, byte[] bytes, int size, boolean binary, String byteStreamHandlerId) {
        this._dataStore.saveFile(fileName, bytes, size, binary, byteStreamHandlerId);
    }

    public void sendAppendFile(String fileName, byte[] bytes, int size, boolean binary) {
        this.sendAppendFile(fileName, bytes, size, binary, "default");
    }

    public void sendAppendFile(String fileName, byte[] bytes, int size, boolean binary, String byteStreamHandlerId) {
        this._dataStore.appendToFile(fileName, bytes, size, binary);
    }

    public synchronized void sendClass(String className) {
        this.sendClass(className, "default");
    }

    public synchronized void sendClass(String className, String classByteStreamHandlerId) {
    }

    public void sendClassInstance(IRemoteClassInstance runnable, String classByteStreamHandlerId) {
        this.notifyInput();
    }

    public void requestClass(String className) {
    }

    public void sendKeepAliveConfirmation() {
    }

    public void sendKeepAliveRequest() {
    }
}

