/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.server;

import java.util.ResourceBundle;
import org.eclipse.dstore.core.model.ISSLProperties;

public class ServerSSLProperties
implements ISSLProperties {
    private boolean _enableSSL = false;
    private boolean _disableServerSSL = false;
    private String _daemonKeyStorePath;
    private String _daemonKeyStorePassword;
    private String _serverKeyStorePath;
    private String _serverKeyStorePassword;
    private static final String ENABLE_SSL = "enable_ssl";
    private static final String DISABLE_SERVER_SSL = "disable_server_ssl";
    private static final String DAEMON_KEYSTORE_FILE = "daemon_keystore_file";
    private static final String DAEMON_KEYSTORE_PASSWORD = "daemon_keystore_password";
    private static final String SERVER_KEYSTORE_FILE = "server_keystore_file";
    private static final String SERVER_KEYSTORE_PASSWORD = "server_keystore_password";

    public ServerSSLProperties() {
        try {
            ResourceBundle properties = ResourceBundle.getBundle("ssl");
            this._enableSSL = properties.getString(ENABLE_SSL).trim().equals("true");
            if (this._enableSSL) {
                try {
                    this._disableServerSSL = properties.getString(DISABLE_SERVER_SSL).trim().equals("true");
                }
                catch (Exception exception) {}
                try {
                    this._daemonKeyStorePath = properties.getString(DAEMON_KEYSTORE_FILE).trim();
                    this._daemonKeyStorePassword = properties.getString(DAEMON_KEYSTORE_PASSWORD).trim();
                }
                catch (Exception exception) {}
                if (!this._disableServerSSL) {
                    try {
                        this._serverKeyStorePath = properties.getString(SERVER_KEYSTORE_FILE).trim();
                        this._serverKeyStorePassword = properties.getString(SERVER_KEYSTORE_PASSWORD).trim();
                    }
                    catch (Exception exception) {}
                }
                if (this._daemonKeyStorePath == null && this._serverKeyStorePath != null) {
                    this._daemonKeyStorePath = this._serverKeyStorePath;
                    this._daemonKeyStorePassword = this._serverKeyStorePassword;
                }
                if (!this._disableServerSSL && this._serverKeyStorePath == null && this._daemonKeyStorePath != null) {
                    this._serverKeyStorePath = this._daemonKeyStorePath;
                    this._serverKeyStorePassword = this._daemonKeyStorePassword;
                }
            }
            if (this._enableSSL) {
                System.out.println("SSL Settings");
                System.out.println("[daemon keystore:\t" + this._daemonKeyStorePath + "]");
                System.out.println("[daemon keystore pw:\t" + this._daemonKeyStorePassword + "]");
                if (!this._disableServerSSL) {
                    System.out.println("[server keystore:\t" + this._serverKeyStorePath + "]");
                    System.out.println("[server keystore pw:\t" + this._serverKeyStorePassword + "]");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean usingSSL() {
        return this._enableSSL;
    }

    public boolean usingServerSSL() {
        return !this._disableServerSSL;
    }

    public String getDaemonKeyStorePath() {
        return this._daemonKeyStorePath;
    }

    public String getServerKeyStorePath() {
        return this._serverKeyStorePath;
    }

    public String getDaemonKeyStorePassword() {
        return this._daemonKeyStorePassword;
    }

    public String getServerKeyStorePassword() {
        return this._serverKeyStorePassword;
    }
}

