/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.persistence.dom;

import java.util.Vector;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterStartHere;
import org.eclipse.rse.core.filters.ISystemFilterString;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.IPropertyType;
import org.eclipse.rse.core.model.IRSEModelObject;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemProfileManager;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.PropertyType;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IServerLauncherProperties;
import org.eclipse.rse.core.subsystems.IServiceSubSystem;
import org.eclipse.rse.core.subsystems.IServiceSubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.SubSystemFilterNamingPolicy;
import org.eclipse.rse.persistence.dom.IRSEDOMImporter;
import org.eclipse.rse.persistence.dom.RSEDOM;
import org.eclipse.rse.persistence.dom.RSEDOMNode;
import org.eclipse.rse.persistence.dom.RSEDOMNodeAttribute;

public class RSEDOMImporter
implements IRSEDOMImporter {
    private static RSEDOMImporter _instance = new RSEDOMImporter();
    private ISystemRegistry _registry;

    public static RSEDOMImporter getInstance() {
        return _instance;
    }

    public void setSystemRegistry(ISystemRegistry registry) {
        this._registry = registry;
    }

    public ISystemProfile restoreProfile(ISystemProfileManager profileManager, RSEDOM dom) {
        String profileName = dom.getName();
        boolean defaultPrivate = this.getBooleanValue(dom.getAttribute("defaultPrivate").getValue());
        boolean isActive = this.getBooleanValue(dom.getAttribute("isActive").getValue());
        ISystemProfile profile = profileManager.createSystemProfile(profileName, isActive);
        if (profile != null) {
            profile.setDefaultPrivate(defaultPrivate);
            profileManager.makeSystemProfileActive(profile, isActive);
            RSEDOMNode[] children = dom.getChildren();
            int i = 0;
            while (i < children.length) {
                RSEDOMNode child = children[i];
                String type = child.getType();
                if (type.equals("Host")) {
                    this.restoreHost(profile, child);
                } else if (type.equals("FilterPool")) {
                    this.restoreFilterPool(profile, child);
                } else if (type.equals("PropertySet")) {
                    this.restorePropertySet(profile, child);
                }
                ++i;
            }
        }
        return profile;
    }

    public IHost restoreHost(ISystemProfile profile, RSEDOMNode hostNode) {
        IHost host = null;
        String connectionName = hostNode.getName();
        String systemType = hostNode.getAttribute("type").getValue();
        String hostName = hostNode.getAttribute("hostname").getValue();
        String description = hostNode.getAttribute("description").getValue();
        boolean isOffline = this.getBooleanValue(hostNode.getAttribute("offline").getValue());
        boolean isPromptable = this.getBooleanValue(hostNode.getAttribute("promptable").getValue());
        try {
            host = profile.createHost(systemType, connectionName, hostName, description);
            host.setOffline(isOffline);
            host.setPromptable(isPromptable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RSEDOMNode[] children = hostNode.getChildren();
        int i = 0;
        while (i < children.length) {
            RSEDOMNode child = children[i];
            String type = child.getType();
            if (type.equals("ConnectorService")) {
                this.restoreConnectorService(host, child);
            } else if (type.equals("PropertySet")) {
                this.restorePropertySet(profile, child);
            }
            ++i;
        }
        return host;
    }

    public IConnectorService restoreConnectorService(IHost host, RSEDOMNode connectorServiceNode) {
        IConnectorService service = null;
        boolean useSSL = this.getBooleanValue(connectorServiceNode.getAttribute("useSSL").getValue());
        RSEDOMNodeAttribute att = connectorServiceNode.getAttribute("port");
        int port = 0;
        if (att != null) {
            port = this.getIntegerValue(att.getValue());
        }
        RSEDOMNode[] ssChildren = connectorServiceNode.getChildren("SubSystem");
        int s = 0;
        while (s < ssChildren.length) {
            ISubSystemConfiguration factory;
            RSEDOMNode ssChild = ssChildren[s];
            ISubSystem subSystem = this.restoreSubSystem(host, ssChild);
            if (subSystem != null && service == null && (service = (factory = subSystem.getSubSystemConfiguration()).getConnectorService(host)) != null) {
                IServerLauncherProperties sl;
                if (factory.supportsServerLaunchProperties(host) && (sl = factory.createServerLauncher(service)) != null) {
                    RSEDOMNode serverLauncherPropertiesNode = null;
                    RSEDOMNode[] slChildren = connectorServiceNode.getChildren("ServerLauncher");
                    if (slChildren != null && slChildren.length > 0) {
                        serverLauncherPropertiesNode = slChildren[0];
                        this.restoreServerLauncher(service, serverLauncherPropertiesNode, sl);
                    }
                }
                service.setPort(port);
                service.setIsUsingSSL(useSSL);
            }
            if (service != null && subSystem != null) {
                subSystem.setConnectorService(service);
            }
            ++s;
        }
        RSEDOMNode[] psChildren = connectorServiceNode.getChildren("PropertySet");
        int p = 0;
        while (p < psChildren.length) {
            RSEDOMNode psChild = psChildren[p];
            this.restorePropertySet(service, psChild);
            ++p;
        }
        return service;
    }

    public IServerLauncherProperties restoreServerLauncher(IConnectorService service, RSEDOMNode serverLauncherNode, IServerLauncherProperties sl) {
        RSEDOMNode[] psChildren = serverLauncherNode.getChildren("PropertySet");
        int p = 0;
        while (p < psChildren.length) {
            RSEDOMNode psChild = psChildren[p];
            this.restorePropertySet(sl, psChild);
            ++p;
        }
        sl.restoreFromProperties();
        service.setRemoteServerLauncherProperties(sl);
        return sl;
    }

    public ISubSystem restoreSubSystem(IHost host, RSEDOMNode subSystemNode) {
        String name = subSystemNode.getName();
        String type = subSystemNode.getAttribute("type").getValue();
        boolean isHidden = this.getBooleanValue(subSystemNode.getAttribute("hidden").getValue());
        ISubSystem subSystem = null;
        ISubSystemConfiguration factory = this.getSubSystemConfiguration(type);
        if (factory != null) {
            if (factory instanceof IServiceSubSystemConfiguration) {
                IServiceSubSystemConfiguration serviceFactory = (IServiceSubSystemConfiguration)factory;
                ISubSystem[] existingSubSystems = this._registry.getServiceSubSystems(serviceFactory.getServiceType(), host);
                if (existingSubSystems != null && existingSubSystems.length > 0) {
                    subSystem = existingSubSystems[0];
                    ((IServiceSubSystem)subSystem).switchServiceFactory(serviceFactory);
                }
            } else {
                ISubSystem[] existingSubSystems = this._registry.getSubSystems(type, host);
                if (existingSubSystems != null && existingSubSystems.length > 0) {
                    subSystem = existingSubSystems[0];
                }
            }
            if (subSystem == null) {
                subSystem = factory.createSubSystemInternal(host);
            }
            subSystem.setHidden(isHidden);
            subSystem.setHost(host);
            subSystem.setSubSystemConfiguration(factory);
            subSystem.setName(factory.getName());
            subSystem.setConfigurationId(factory.getId());
            subSystem.setWasRestored(true);
            if (factory.supportsFilters()) {
                ISystemFilterStartHere startHere = this._registry.getSystemFilterStartHere();
                ISystemFilterPoolReferenceManager fprMgr = startHere.createSystemFilterPoolReferenceManager(subSystem, factory, name, new SubSystemFilterNamingPolicy());
                subSystem.setFilterPoolReferenceManager(fprMgr);
                ISystemFilterPoolManager defaultFilterPoolManager = factory.getFilterPoolManager(host.getSystemProfile());
                fprMgr.setDefaultSystemFilterPoolManager(defaultFilterPoolManager);
            }
            RSEDOMNode[] filterPoolReferenceChildren = subSystemNode.getChildren("FilterPoolReference");
            int i = 0;
            while (i < filterPoolReferenceChildren.length) {
                RSEDOMNode fprChild = filterPoolReferenceChildren[i];
                this.restoreFilterPoolReference(subSystem, fprChild);
                ++i;
            }
            RSEDOMNode[] psChildren = subSystemNode.getChildren("PropertySet");
            int p = 0;
            while (p < psChildren.length) {
                RSEDOMNode psChild = psChildren[p];
                this.restorePropertySet(subSystem, psChild);
                ++p;
            }
        }
        return subSystem;
    }

    public ISystemFilter restoreFilter(ISystemFilterPool filterPool, RSEDOMNode node) {
        String name = node.getName();
        boolean supportsNestedFilters = this.getBooleanValue(node.getAttribute("supportsNestedFilters").getValue());
        int relativeOrder = this.getIntegerValue(node.getAttribute("relativeOrder").getValue());
        boolean isDefault = this.getBooleanValue(node.getAttribute("default").getValue());
        boolean isSetStringsCaseSensitive = this.getBooleanValue(node.getAttribute("stringsCaseSensitive").getValue());
        boolean isPromptable = this.getBooleanValue(node.getAttribute("promptable").getValue());
        boolean isSetSupportsDuplicateFilterStrings = this.getBooleanValue(node.getAttribute("supportsDuplicateFilterStrings").getValue());
        boolean isNonDeletable = this.getBooleanValue(node.getAttribute("nonDeletable").getValue());
        boolean isNonRenamable = this.getBooleanValue(node.getAttribute("nonRenamable").getValue());
        boolean isNonChangable = this.getBooleanValue(node.getAttribute("nonChangable").getValue());
        boolean isStringsNonChangable = this.getBooleanValue(node.getAttribute("stringsNonChangable").getValue());
        int release = this.getIntegerValue(node.getAttribute("release").getValue());
        boolean isSetSingleFilterStringOnly = this.getBooleanValue(node.getAttribute("singleFilterStringOnly").getValue());
        Vector<String> filterStrings = new Vector<String>();
        RSEDOMNode[] filterStringNodes = node.getChildren("FilterString");
        int i = 0;
        while (i < filterStringNodes.length) {
            RSEDOMNode filterStringNode = filterStringNodes[i];
            filterStrings.add(filterStringNode.getName());
            ++i;
        }
        ISystemFilter filter = filterPool.createSystemFilter(name, filterStrings);
        filter.setWasRestored(true);
        filter.setSupportsNestedFilters(supportsNestedFilters);
        filter.setRelativeOrder(relativeOrder);
        filter.setDefault(isDefault);
        filter.setStringsCaseSensitive(isSetStringsCaseSensitive);
        filter.setPromptable(isPromptable);
        filter.setSupportsDuplicateFilterStrings(isSetSupportsDuplicateFilterStrings);
        filter.setNonDeletable(isNonDeletable);
        filter.setNonChangable(isNonChangable);
        filter.setNonRenamable(isNonRenamable);
        filter.setStringsNonChangable(isStringsNonChangable);
        filter.setRelease(release);
        filter.setSingleFilterStringOnly(isSetSingleFilterStringOnly);
        RSEDOMNode[] psChildren = node.getChildren("PropertySet");
        int p = 0;
        while (p < psChildren.length) {
            RSEDOMNode psChild = psChildren[p];
            this.restorePropertySet(filter, psChild);
            ++p;
        }
        return filter;
    }

    public ISystemFilterPool restoreFilterPool(ISystemProfile profile, RSEDOMNode node) {
        ISystemFilterPool filterPool = null;
        String name = node.getName();
        String type = node.getAttribute("type").getValue();
        String id = node.getAttribute("id").getValue();
        boolean supportsNestedFilters = this.getBooleanValue(node.getAttribute("supportsNestedFilters").getValue());
        boolean isDeletable = this.getBooleanValue(node.getAttribute("deletable").getValue());
        boolean isDefault = this.getBooleanValue(node.getAttribute("default").getValue());
        boolean isSetStringsCaseSensitive = this.getBooleanValue(node.getAttribute("stringsCaseSensitive").getValue());
        boolean isSetSupportsDuplicateFilterStrings = this.getBooleanValue(node.getAttribute("supportsDuplicateFilterStrings").getValue());
        int release = this.getIntegerValue(node.getAttribute("release").getValue());
        boolean isSetSingleFilterStringOnly = this.getBooleanValue(node.getAttribute("singleFilterStringOnly").getValue());
        String owningParentName = node.getAttribute("owningParentName").getValue();
        boolean isNonRenamable = this.getBooleanValue(node.getAttribute("nonRenamable").getValue());
        try {
            ISubSystemConfiguration factory = this.getSubSystemConfiguration(id);
            if (factory != null) {
                ISystemFilterPoolManager mgr = factory.getFilterPoolManager(profile);
                filterPool = isDefault ? mgr.getFirstDefaultSystemFilterPool() : mgr.getSystemFilterPool(name);
                if (filterPool == null && (filterPool = this._registry.getSystemFilterPool().createSystemFilterPool(name, supportsNestedFilters, isDeletable, false)) != null) {
                    filterPool.setSystemFilterPoolManager(mgr);
                    mgr.getPools().add(filterPool);
                }
                filterPool.setType(type);
                filterPool.setDefault(isDefault);
                filterPool.setSupportsNestedFilters(supportsNestedFilters);
                filterPool.setStringsCaseSensitive(isSetStringsCaseSensitive);
                filterPool.setSupportsDuplicateFilterStrings(isSetSupportsDuplicateFilterStrings);
                filterPool.setRelease(release);
                filterPool.setSingleFilterStringOnly(isSetSingleFilterStringOnly);
                filterPool.setOwningParentName(owningParentName);
                filterPool.setNonRenamable(isNonRenamable);
                filterPool.setWasRestored(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RSEDOMNode[] children = node.getChildren();
        int i = 0;
        while (i < children.length) {
            RSEDOMNode child = children[i];
            String ctype = child.getType();
            if (ctype.equals("Filter")) {
                if (filterPool != null) {
                    this.restoreFilter(filterPool, child);
                }
            } else if (ctype.equals("PropertySet")) {
                this.restorePropertySet(filterPool, child);
            }
            ++i;
        }
        return filterPool;
    }

    public ISystemFilterPoolReference restoreFilterPoolReference(ISubSystem subsystem, RSEDOMNode node) {
        ISystemFilterPoolReference filterPoolReference = null;
        String subsystemName = node.getAttribute("refID").getValue();
        String filterPoolName = node.getName();
        ISubSystemConfiguration configuration = this.getSubSystemConfiguration(subsystemName);
        if (configuration != null) {
            ISystemProfile profile = subsystem.getSystemProfile();
            ISystemFilterPoolManager filterPoolManager = configuration.getFilterPoolManager(profile);
            ISystemFilterPool filterPool = filterPoolManager.getSystemFilterPool(filterPoolName);
            ISystemFilterPoolReferenceManager referenceManager = subsystem.getFilterPoolReferenceManager();
            filterPoolReference = filterPool != null ? referenceManager.addReferenceToSystemFilterPool(filterPool) : referenceManager.addReferenceToSystemFilterPool(filterPoolManager, filterPoolName);
        }
        return filterPoolReference;
    }

    public ISystemFilterString restoreFilterString(ISystemFilter filter, RSEDOMNode node) {
        return null;
    }

    public IPropertySet restorePropertySet(IRSEModelObject modelObject, RSEDOMNode propertySetNode) {
        String name = propertySetNode.getName();
        IPropertySet set = modelObject.createPropertySet(name);
        RSEDOMNodeAttribute[] attributes = propertySetNode.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            RSEDOMNodeAttribute attribute = attributes[i];
            String typeStr = attribute.getType();
            IPropertyType type = PropertyType.fromString(typeStr);
            set.addProperty(attribute.getKey(), attribute.getValue(), type);
            ++i;
        }
        return set;
    }

    private boolean getBooleanValue(String booleanStr) {
        return booleanStr != null && booleanStr.equalsIgnoreCase("true");
    }

    private int getIntegerValue(String integerString) {
        int result = 0;
        if (integerString != null) {
            try {
                result = Integer.parseInt(integerString);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    private ISubSystemConfiguration getSubSystemConfiguration(String subsystemName) {
        return this._registry.getSubSystemConfiguration(subsystemName);
    }
}

