/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.actions;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.files.ui.resources.ISystemRemoteEditConstants;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Shell;

public class SystemEditFileAction
extends SystemBaseAction
implements ISystemRemoteEditConstants {
    protected String _editorId;

    public SystemEditFileAction(String text, String tooltip, ImageDescriptor image, Shell parent, String editorId) {
        super(text, tooltip, null, image, parent);
        this.init();
        this._editorId = editorId;
    }

    public SystemEditFileAction(String text, String tooltip, ImageDescriptor image, int style, Shell parent, String editorId) {
        super(text, tooltip, null, image, style, parent);
        this.init();
        this._editorId = editorId;
    }

    private void init() {
        this.allowOnMultipleSelection(false);
    }

    public void run() {
        IStructuredSelection selection = this.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Object element = this.getFirstSelection();
        if (element == null) {
            return;
        }
        if (!(element instanceof IRemoteFile)) {
            return;
        }
        this.process((IRemoteFile)element);
    }

    protected void process(IRemoteFile remoteFile) {
        SystemEditableRemoteFile editableFile = new SystemEditableRemoteFile(remoteFile, this._editorId);
        editableFile.open(SystemBasePlugin.getActiveWorkbenchShell());
    }
}

