/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.files.ui.FileResources;
import org.eclipse.rse.model.ISystemResourceChangeEvent;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.view.ISystemDragDropAdapter;
import org.eclipse.swt.widgets.Shell;

public class SystemExtractAction
extends SystemBaseAction {
    protected List _selected;
    protected Shell _parent;
    protected String _label;

    public SystemExtractAction(Shell parent) {
        super(FileResources.ACTION_EXTRACT_LABEL, parent);
        this._label = FileResources.ACTION_EXTRACT_LABEL;
        this.setToolTipText(FileResources.ACTION_EXTRACT_TOOLTIP);
        this._selected = new ArrayList();
        this._parent = parent;
        this.allowOnMultipleSelection(true);
        this.setHelp("org.eclipse.rse.ui.actn0118");
        this.setImageDescriptor(RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.xtrctarchv_tskIcon"));
    }

    public SystemExtractAction(Shell parent, String label, String tooltip) {
        super(label, tooltip, parent);
        this._label = label;
        this.setToolTipText(tooltip);
        this._selected = new ArrayList();
        this._parent = parent;
        this.allowOnMultipleSelection(true);
        this.setHelp("org.eclipse.rse.ui.actn0118");
        this.setImageDescriptor(RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.xtrctarchv_tskIcon"));
    }

    public void run() {
        int i = 0;
        while (i < this._selected.size()) {
            block6: {
                IRemoteFile selection = (IRemoteFile)this._selected.get(i);
                IRemoteFile destinationParent = selection.getParentRemoteFile();
                IRemoteFileSubSystem ss = selection.getParentRemoteFileSubSystem();
                String newName = this.getExtractedName(selection);
                IRemoteFile destination = null;
                try {
                    destination = ss.getRemoteFileObject(String.valueOf(destinationParent.getAbsolutePath()) + destinationParent.getSeparator() + newName);
                    ss.createFolder(destination);
                }
                catch (SystemMessageException e) {
                    SystemMessageDialog dlg = new SystemMessageDialog(this.getShell(), e.getSystemMessage());
                    dlg.open();
                    break block6;
                }
                IRunnableContext runnableContext = this.getRunnableContext(this._parent);
                ExtractRunnable runnable = new ExtractRunnable(selection, destination);
                try {
                    runnableContext.run(false, true, (IRunnableWithProgress)runnable);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
                SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
                registry.fireRemoteResourceChangeEvent(1, (Object)destination, (Object)destinationParent, (ISubSystem)ss, null, null);
                registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)destination, 82, (Object)destinationParent));
            }
            ++i;
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        this._selected.clear();
        boolean enable = false;
        Iterator e = selection.iterator();
        while (e.hasNext()) {
            Object selected = e.next();
            if (selected != null && selected instanceof IRemoteFile) {
                IRemoteFile file = (IRemoteFile)selected;
                if (!file.isArchive() || !file.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemConfiguration().supportsArchiveManagement()) continue;
                this._selected.add(file);
                enable = true;
                continue;
            }
            return false;
        }
        if (this._selected.size() == 1) {
            this.setText(this.getActionLabelForSingleSelection());
        } else {
            this.setText(this._label);
        }
        return enable;
    }

    protected String getActionLabelForSingleSelection() {
        String msg = FileResources.ACTION_EXTRACT_SUB_LABEL;
        return SystemMessage.sub((String)msg, (String)"%1", (String)this.getExtractedName((IRemoteFile)this._selected.get(0)));
    }

    protected String getExtractedName(IRemoteFile selection) {
        String newName = selection.getName();
        int k = newName.lastIndexOf(".");
        newName = k == -1 ? String.valueOf(newName) + "_contents" : newName.substring(0, k);
        return newName;
    }

    protected IRunnableContext getRunnableContext(Shell shell) {
        IRunnableContext irc = RSEUIPlugin.getTheSystemRegistry().getRunnableContext();
        if (irc != null) {
            return irc;
        }
        return new ProgressMonitorDialog(shell);
    }

    protected class ExtractRunnable
    implements IRunnableWithProgress {
        private IRemoteFileSubSystem destSS;
        private IRemoteFileSubSystem sourceSS;
        private IRemoteFile selection;
        private IRemoteFile destination;
        static /* synthetic */ Class class$0;

        public ExtractRunnable(IRemoteFile source, IRemoteFile dest) {
            this.destSS = dest.getParentRemoteFileSubSystem();
            this.sourceSS = source.getParentRemoteFileSubSystem();
            this.selection = source;
            this.destination = dest;
        }

        public void run(IProgressMonitor monitor) {
            try {
                IRemoteFile[] sources = this.sourceSS.listFoldersAndFiles(this.selection, monitor);
                int j = 0;
                while (j < sources.length && !monitor.isCanceled()) {
                    try {
                        boolean sameSys;
                        IAdaptable iAdaptable = (IAdaptable)this.selection;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.rse.ui.view.ISystemDragDropAdapter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        ISystemDragDropAdapter srcAdapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
                        boolean sameSysType = this.sourceSS.getClass().equals(this.destSS.getClass());
                        boolean bl = sameSys = this.sourceSS == this.destSS;
                        if (!sameSys) {
                            Object source = srcAdapter.doDrag((Object)sources[j], sameSysType, monitor);
                            srcAdapter.doDrop(source, (Object)this.destination, sameSysType, sameSys, 0, monitor);
                        } else {
                            srcAdapter.doDrop((Object)sources[j], (Object)this.destination, sameSysType, sameSys, 0, monitor);
                        }
                    }
                    catch (Exception e) {
                        SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEG1066");
                        SystemMessageDialog dlg = new SystemMessageDialog(SystemExtractAction.this.getShell(), msg);
                        dlg.open();
                        System.out.println(e.getMessage());
                        System.out.println("Could not extract " + sources[j].getAbsolutePath());
                    }
                    ++j;
                }
            }
            catch (SystemMessageException e) {
                SystemMessageDialog dlg = new SystemMessageDialog(SystemExtractAction.this.getShell(), e.getSystemMessage());
                dlg.open();
            }
        }
    }
}

