/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.files.ui.actions.SystemEditFileAction;
import org.eclipse.rse.files.ui.resources.SystemIFileProperties;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteSearchResult;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class SystemSearchEditFileLineAction
extends SystemEditFileAction {
    protected IRemoteFile _remoteFile;
    protected IRemoteSearchResult _searchResult;

    public SystemSearchEditFileLineAction(String text, String tooltip, ImageDescriptor image, Shell parent, String editorId, IRemoteFile remoteFile, IRemoteSearchResult searchResult) {
        super(text, tooltip, image, parent, editorId);
        this._remoteFile = remoteFile;
        this._searchResult = searchResult;
    }

    public void run() {
        this.process(this._remoteFile, this._searchResult);
    }

    public void process(IRemoteFile remoteFile, IRemoteSearchResult searchResult) {
        super.process(remoteFile);
        SystemSearchEditFileLineAction.handleGotoLine(remoteFile, searchResult);
    }

    public static void handleGotoLine(IRemoteFile remoteFile, IRemoteSearchResult searchResult) {
        int line = searchResult.getLine();
        if (line > 0) {
            IWorkbench desktop = PlatformUI.getWorkbench();
            IWorkbenchPage persp = desktop.getActiveWorkbenchWindow().getActivePage();
            IEditorPart editor = null;
            String fileName = remoteFile.getAbsolutePath();
            IEditorReference[] editors = persp.getEditorReferences();
            int i = 0;
            while (i < editors.length) {
                IFileEditorInput input;
                IFile efile;
                SystemIFileProperties properties;
                String comparePath;
                IEditorInput einput;
                IEditorReference ref = editors[i];
                IEditorPart editorp = ref.getEditor(false);
                if (editorp != null && (einput = editorp.getEditorInput()) instanceof IFileEditorInput && (comparePath = (properties = new SystemIFileProperties((IResource)(efile = (input = (IFileEditorInput)einput).getFile()))).getRemoteFilePath()) != null && comparePath.replace('\\', '/').equals(fileName.replace('\\', '/'))) {
                    editor = editorp;
                    persp.bringToTop((IWorkbenchPart)editor);
                    int firstStartOffset = -1;
                    int firstEndOffset = -1;
                    int matchSize = searchResult.numOfMatches();
                    if (matchSize > 0) {
                        firstStartOffset = searchResult.getCharStart(0);
                        firstEndOffset = searchResult.getCharEnd(0);
                    }
                    try {
                        IMarker firstMarker = SystemSearchEditFileLineAction.createMarker(efile, line, firstStartOffset, firstEndOffset);
                        int charStart = -1;
                        int charEnd = -1;
                        int idx = 1;
                        while (idx < matchSize) {
                            charStart = searchResult.getCharStart(idx);
                            charEnd = searchResult.getCharEnd(idx);
                            SystemSearchEditFileLineAction.createMarker(efile, line, charStart, charEnd);
                            ++idx;
                        }
                        IDE.gotoMarker((IEditorPart)editor, (IMarker)firstMarker);
                    }
                    catch (CoreException e) {
                        SystemBasePlugin.logError((String)"Error occured trying to create a marker", (Throwable)e);
                    }
                }
                ++i;
            }
        }
    }

    protected static IMarker createMarker(IFile file, int line, int charStart, int charEnd) throws CoreException {
        IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
        marker.setAttribute("lineNumber", line);
        marker.setAttribute("charStart", charStart);
        marker.setAttribute("charEnd", charEnd);
        return marker;
    }
}

