/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.rse.ui.dialogs.SystemSelectFileTypesDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;

public class SystemSearchSelectFileTypesDialog
extends SystemSelectFileTypesDialog {
    public SystemSearchSelectFileTypesDialog(Shell shell, Collection currentTypes) {
        super(shell, currentTypes);
    }

    protected void checkInitialSelections() {
        IFileEditorMapping[] editorMappings = PlatformUI.getWorkbench().getEditorRegistry().getFileEditorMappings();
        ArrayList<String> selectedMappings = new ArrayList<String>();
        int i = 0;
        while (i < editorMappings.length) {
            IFileEditorMapping mapping = editorMappings[i];
            if (this.initialSelections.contains(mapping.getExtension())) {
                this.listViewer.setChecked((Object)mapping, true);
                selectedMappings.add(mapping.getExtension());
            }
            ++i;
        }
        Iterator initialIterator = this.initialSelections.iterator();
        StringBuffer entries = new StringBuffer();
        boolean first = true;
        while (initialIterator.hasNext()) {
            String nextExtension = (String)initialIterator.next();
            if (selectedMappings.contains(nextExtension)) continue;
            if (!first) {
                entries.append(TYPE_DELIMITER);
                entries.append(" ");
            } else {
                first = false;
            }
            entries.append(nextExtension);
        }
        this.userDefinedText.setText(entries.toString());
    }

    protected void addUserDefinedEntries(List result) {
        StringTokenizer tokenizer = new StringTokenizer(this.userDefinedText.getText(), TYPE_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            String currentExtension = tokenizer.nextToken().trim();
            if (currentExtension.equals("")) continue;
            result.add(currentExtension);
        }
    }

    protected boolean processOK() {
        IFileEditorMapping[] children = this.getInput();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < children.length) {
            IFileEditorMapping element = children[i];
            if (this.listViewer.getChecked((Object)element)) {
                list.add(element.getLabel());
            }
            ++i;
        }
        this.addUserDefinedEntries(list);
        this.setResult(list);
        return true;
    }

    protected boolean validateFileType(String filename) {
        return true;
    }
}

