/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.wizards;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorServerPortInput;
import org.eclipse.rse.ui.wizards.AbstractSystemNewConnectionWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class SystemFileNewConnectionWizardPage
extends AbstractSystemNewConnectionWizardPage {
    protected Label labelPortPrompt;
    protected Text textPort;
    protected ISystemValidator portValidator;
    protected SystemMessage errorMessage;
    protected boolean enablePortSelection = true;

    public SystemFileNewConnectionWizardPage(IWizard wizard, ISubSystemConfiguration parentFactory) {
        super(wizard, parentFactory, parentFactory.getId(), SystemResources.RESID_NEWCONN_SUBSYSTEMPAGE_FILES_TITLE, SystemResources.RESID_NEWCONN_SUBSYSTEMPAGE_FILES_DESCRIPTION);
        if (this.enablePortSelection) {
            this.getPortValidator();
        }
    }

    public boolean isInformationalOnly() {
        return !this.enablePortSelection;
    }

    protected Control getInitialFocusControl() {
        if (this.textPort != null) {
            return this.textPort;
        }
        return null;
    }

    public void setEnablePortSelection(boolean flag) {
        this.enablePortSelection = flag;
    }

    protected ISystemValidator getPortValidator() {
        if (this.portValidator == null) {
            this.portValidator = new ValidatorServerPortInput();
        }
        return this.portValidator;
    }

    public Control createContents(Composite parent) {
        int nbrColumns = 2;
        Composite composite_prompts = SystemWidgetHelpers.createComposite((Composite)parent, (int)nbrColumns);
        String text = null;
        text = SystemResources.RESID_NEWCONN_SUBSYSTEMPAGE_FILES_VERBAGE1;
        boolean border = false;
        int span = nbrColumns;
        int widthHint = 200;
        SystemWidgetHelpers.createVerbiage((Composite)composite_prompts, (String)text, (int)span, (boolean)border, (int)widthHint);
        SystemWidgetHelpers.createSpacerLine((Composite)composite_prompts, (int)span, (boolean)false);
        text = SystemResources.RESID_NEWCONN_SUBSYSTEMPAGE_FILES_VERBAGE2;
        SystemWidgetHelpers.createVerbiage((Composite)composite_prompts, (String)text, (int)span, (boolean)border, (int)widthHint);
        if (this.enablePortSelection) {
            String labelText = SystemWidgetHelpers.appendColon((String)SystemResources.RESID_SUBSYSTEM_PORT_LABEL);
            this.labelPortPrompt = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)labelText);
            this.textPort = SystemWidgetHelpers.createTextField((Composite)composite_prompts, null, (String)SystemResources.RESID_SUBSYSTEM_PORT_TIP);
            this.textPort.setText("0");
            this.textPort.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SystemFileNewConnectionWizardPage.this.validatePortInput();
                }
            });
        }
        return composite_prompts;
    }

    protected boolean isPortEditable() {
        return this.parentFactory.isPortEditable();
    }

    public boolean performFinish() {
        if (this.textPort == null) {
            return true;
        }
        return this.validatePortInput() == null;
    }

    public int getPortNumber() {
        Integer iPort = null;
        if (this.textPort == null) {
            iPort = new Integer(0);
        } else {
            String sPort = this.textPort.getText().trim();
            try {
                iPort = new Integer(sPort);
            }
            catch (Exception exception) {
                iPort = new Integer(0);
            }
        }
        return iPort;
    }

    protected SystemMessage validatePortInput() {
        this.clearErrorMessage();
        this.errorMessage = this.getPortValidator().validate(this.textPort.getText().trim());
        if (this.errorMessage != null) {
            this.setErrorMessage(this.errorMessage);
        }
        this.setPageComplete(this.errorMessage == null);
        return this.errorMessage;
    }

    public boolean isPageComplete() {
        if (this.textPort == null) {
            return true;
        }
        return this.textPort.getText().trim().length() > 0;
    }
}

