/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.dstore.universal.miners.command.patterns;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.rse.dstore.universal.miners.command.patterns.CommandPattern;
import org.eclipse.rse.dstore.universal.miners.command.patterns.OutputPattern;
import org.eclipse.rse.dstore.universal.miners.command.patterns.ParsedOutput;

public class Patterns {
    private ArrayList _theCommands;
    private DataStore _dataStore;
    private String _currentCommand = null;
    private List _currentCommandPatterns = null;
    private long _timeStamp = 0L;
    private File _thePatternsFile;
    private boolean _isTerminal = false;
    private String _pluginPath;
    private static String MINERS_PACKAGE = "org.eclipse.rse.services.dstore";
    private static String PATTERNS_FILE = "patterns.dat";
    private String _version = "8.0.0";

    public Patterns(DataStore ds) {
        this._dataStore = ds;
        this._theCommands = new ArrayList();
        this._currentCommandPatterns = new ArrayList();
        this._pluginPath = ds.getAttribute(2);
        this.parsePatternsFile();
    }

    public Patterns(DataStore ds, String pluginsPath) {
        this._dataStore = ds;
        this._theCommands = new ArrayList();
        this._currentCommandPatterns = new ArrayList();
        this._pluginPath = pluginsPath;
        this.parsePatternsFile();
    }

    public void setIsTerminal(boolean isTerminal) {
        this._isTerminal = isTerminal;
    }

    private String cleanCmdString(String theCommand) {
        int spaceIndex;
        String result = theCommand;
        int semiIndex = result.indexOf(";");
        if (semiIndex > 0) {
            result = result.substring(0, semiIndex);
        }
        if ((spaceIndex = result.indexOf(" ")) > -1) {
            int slashIndex = result.lastIndexOf("/", spaceIndex);
            if (slashIndex > 0) {
                result = result.substring(slashIndex + 1, result.length());
            }
        } else {
            int slashIndex = result.lastIndexOf("/");
            if (slashIndex > 0) {
                result = result.substring(slashIndex + 1, result.length());
            }
        }
        return result;
    }

    public void refresh(String theCommand) {
        this._currentCommand = this.cleanCmdString(theCommand);
        this._currentCommandPatterns.clear();
        this.parsePatternsFile();
    }

    public void update(String theCommand) {
        this._currentCommand = this.cleanCmdString(theCommand);
        this._currentCommandPatterns.clear();
    }

    private File getPatternsFile() {
        if (this._thePatternsFile == null) {
            File parentFile;
            File thePatternsFile = new File(String.valueOf(this._pluginPath) + "/" + MINERS_PACKAGE + "/" + PATTERNS_FILE);
            if (!thePatternsFile.exists() && !(thePatternsFile = new File(String.valueOf(this._pluginPath) + "/" + PATTERNS_FILE)).exists() && !(thePatternsFile = new File(String.valueOf(this._pluginPath) + "/" + MINERS_PACKAGE + "_" + this._version + "/" + PATTERNS_FILE)).exists() && (parentFile = new File(this._pluginPath)).exists()) {
                File[] files = parentFile.listFiles();
                int i = 0;
                while (i < files.length && !thePatternsFile.exists()) {
                    File c = files[i];
                    if (c.getName().startsWith(MINERS_PACKAGE)) {
                        thePatternsFile = c;
                    }
                    ++i;
                }
            }
            this._thePatternsFile = thePatternsFile;
        }
        return this._thePatternsFile;
    }

    private void parsePatternsFile() {
        if (this._dataStore == null) {
            return;
        }
        File thePatternsFile = this.getPatternsFile();
        long newTimeStamp = 0L;
        if (!thePatternsFile.exists() || (newTimeStamp = thePatternsFile.lastModified()) == this._timeStamp) {
            return;
        }
        this._timeStamp = newTimeStamp;
        try {
            this.readPatternsFile(thePatternsFile, "UTF-8");
        }
        catch (Exception e) {
            this._dataStore.trace((Throwable)e);
            this._dataStore.trace("failed to load patterns.dat with UTF-8.  Trying with native encoding");
            try {
                this.readPatternsFile(thePatternsFile, null);
            }
            catch (Exception ex) {
                this._dataStore.trace((Throwable)ex);
            }
        }
    }

    private void readPatternsFile(File thePatternsFile, String encoding) throws Exception {
        String curLine;
        FileInputStream fileStream = new FileInputStream(thePatternsFile);
        InputStreamReader inReader = null;
        inReader = encoding == null ? new InputStreamReader(fileStream) : new InputStreamReader((InputStream)fileStream, encoding);
        BufferedReader reader = new BufferedReader(inReader);
        this._theCommands.clear();
        CommandPattern curCommand = null;
        while ((curLine = reader.readLine()) != null) {
            if ((curLine = curLine.trim()).length() == 0 || curLine.charAt(0) == '#') continue;
            if (curLine.startsWith("command")) {
                int colon = curLine.indexOf(":");
                if (colon == curLine.length() - 1) continue;
                String cmdStr = curLine.substring(colon + 1, curLine.length()).trim();
                Pattern thePattern = Pattern.compile(cmdStr);
                curCommand = new CommandPattern(thePattern);
                this._theCommands.add(curCommand);
                continue;
            }
            int firstSpace = curLine.indexOf(" ");
            int patternWord = curLine.indexOf("pattern");
            int firstEquals = curLine.indexOf("=");
            if (firstEquals == -1 || firstEquals == curLine.length() - 1) continue;
            String objType = curLine.substring(0, firstSpace);
            String matchOrder = curLine.substring(firstSpace + 1, patternWord).trim();
            String patternString = curLine.substring(firstEquals + 1, curLine.length());
            Pattern thePattern = Pattern.compile(patternString.trim());
            if (curCommand == null) continue;
            curCommand.addOutputPattern(new OutputPattern(objType, matchOrder, thePattern));
        }
    }

    private List getCurrentCommandPatterns() {
        if (this._currentCommandPatterns.size() == 0) {
            int commands = this._theCommands.size();
            int i = 0;
            while (i < commands) {
                CommandPattern curCommand = (CommandPattern)this._theCommands.get(i);
                if (curCommand.matchCommand(this._currentCommand)) {
                    this._currentCommandPatterns.add(curCommand);
                }
                ++i;
            }
        }
        return this._currentCommandPatterns;
    }

    public ParsedOutput matchLine(String theLine) {
        ParsedOutput matchedOutput = null;
        List cmdPatterns = this.getCurrentCommandPatterns();
        int i = 0;
        while (i < cmdPatterns.size()) {
            CommandPattern curCommand = (CommandPattern)cmdPatterns.get(i);
            if (curCommand.matchCommand(this._currentCommand) && (!this._currentCommand.equals("ls") || !this._isTerminal || curCommand.getPattern().equals(".*"))) {
                matchedOutput = curCommand.matchLine(theLine);
            }
            if (matchedOutput != null) {
                return matchedOutput;
            }
            ++i;
        }
        return null;
    }
}

