/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver;

import java.io.PrintWriter;
import org.eclipse.rse.services.clientserver.IMatcher;

public class NamePatternMatcher
implements IMatcher {
    public static final char WILDCARD = '*';
    private static final String WILDCARD_DOUBLED = "**";
    public static final char QUOTE = '\"';
    public static final int SCALAR = 0;
    public static final int ALL = 1;
    public static final int WILDCARD_END = 2;
    public static final int WILDCARD_START = 4;
    public static final int WILDCARD_MIDDLE = 8;
    public static final int WILDCARD_START_END = 16;
    public static final int WILDCARD_MIDDLE_END = 32;
    public static final int WILDCARD_START_MIDDLE = 64;
    public static final int WILDCARD_MIDDLE_MIDDLE = 128;
    private static final int[] TYPES_IDX;
    private static final String[] TYPES;
    private String genericName;
    private String part1;
    private String part2;
    private String part3;
    private int part1len;
    private int part2len;
    private int part3len;
    private int part12len;
    private int part123len;
    private int patternType;
    private boolean quotedName;
    private boolean validName;
    private boolean caseSensitive = true;

    static {
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 4;
        nArray[4] = 8;
        nArray[5] = 16;
        nArray[6] = 32;
        nArray[7] = 64;
        nArray[8] = 128;
        TYPES_IDX = nArray;
        TYPES = new String[]{"SCALAR", "ALL", "END", "START", "MIDDLE", "START_END", "MIDDLE_END", "START_MIDDLE", "MIDDLE_MIDDLE"};
    }

    public NamePatternMatcher(String genericName) {
        this(genericName, false, true);
    }

    public NamePatternMatcher(String genericName, boolean advanced, boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        if (genericName == null) {
            genericName = "*";
        }
        int len = 0;
        this.validName = genericName != null && genericName.length() != 0;
        if (this.validName) {
            len = genericName.length();
            boolean bl = this.quotedName = genericName.charAt(0) == '\"';
            if (this.quotedName && (len == 1 || genericName.charAt(len - 1) != '\"')) {
                this.validName = false;
            }
            if (!this.quotedName && !caseSensitive) {
                genericName = genericName.toLowerCase();
            }
        }
        if (this.validName) {
            if (genericName.equals("*BLANK")) {
                genericName = "          ";
            }
            int firstCharPos = this.quotedName ? 1 : 0;
            int lastCharPos = this.quotedName ? len - 2 : len - 1;
            char firstChar = genericName.charAt(firstCharPos);
            char lastChar = genericName.charAt(lastCharPos);
            int wildcardOccurrences = NamePatternMatcher.countOccurrencesOf(genericName, '*');
            if (wildcardOccurrences == 0) {
                this.patternType = 0;
            } else if (wildcardOccurrences == 1) {
                if (!this.quotedName && len == 1 || this.quotedName && len == 3 || genericName.equals("*ALL") || genericName.equals("\"*ALL\"") || genericName.equals("*LIBL")) {
                    this.patternType = 1;
                } else if (firstChar == '*') {
                    this.patternType = 4;
                    this.part2 = genericName.substring(firstCharPos + 1, lastCharPos + 1);
                } else if (lastChar == '*') {
                    this.patternType = 2;
                    this.part1 = genericName.substring(firstCharPos, lastCharPos);
                } else {
                    this.patternType = 8;
                    int wcPos = genericName.indexOf(42);
                    this.part1 = genericName.substring(firstCharPos, wcPos);
                    this.part2 = genericName.substring(wcPos + 1, lastCharPos + 1);
                }
            } else if (wildcardOccurrences == 2) {
                if (!advanced && lastChar != '*' && firstChar != '*') {
                    this.validName = false;
                } else if (genericName.indexOf(WILDCARD_DOUBLED) >= 0) {
                    this.validName = false;
                } else if (firstChar == '*' && lastChar == '*') {
                    this.patternType = 16;
                    this.part1 = genericName.substring(firstCharPos + 1, lastCharPos);
                } else if (lastChar == '*') {
                    this.patternType = 32;
                    int wcPos = genericName.indexOf(42);
                    this.part1 = genericName.substring(firstCharPos, wcPos);
                    this.part2 = genericName.substring(wcPos + 1, lastCharPos);
                    this.part1len = this.part1.length();
                    this.part2len = this.part2.length();
                    this.part12len = this.part1len + this.part2len;
                } else if (firstChar == '*') {
                    this.patternType = 64;
                    int wcPos = genericName.lastIndexOf(42);
                    this.part1 = genericName.substring(firstCharPos + 1, wcPos);
                    this.part2 = genericName.substring(wcPos + 1, lastCharPos + 1);
                    this.part1len = this.part1.length();
                    this.part2len = this.part2.length();
                    this.part12len = this.part1len + this.part2len;
                } else {
                    this.patternType = 128;
                    int wcPos1 = genericName.indexOf(42);
                    int wcPos2 = genericName.lastIndexOf(42);
                    this.part1 = genericName.substring(firstCharPos, wcPos1);
                    this.part2 = genericName.substring(wcPos1 + 1, wcPos2);
                    this.part3 = genericName.substring(wcPos2 + 1, lastCharPos + 1);
                    this.part1len = this.part1.length();
                    this.part2len = this.part2.length();
                    this.part12len = this.part1len + this.part2len;
                    this.part123len = this.part12len + this.part3.length();
                }
            } else {
                this.validName = false;
            }
        }
        this.genericName = genericName;
    }

    public boolean matches(String input) {
        boolean matches = false;
        if (this.validName) {
            if (input.length() > 2 && input.charAt(0) == '\"') {
                input = input.substring(1, input.length() - 1);
            } else if (!this.caseSensitive) {
                input = input.toLowerCase();
            }
            switch (this.patternType) {
                case 0: {
                    matches = input.equals(this.genericName);
                    break;
                }
                case 1: {
                    matches = true;
                    break;
                }
                case 2: {
                    matches = input.startsWith(this.part1);
                    break;
                }
                case 4: {
                    matches = input.endsWith(this.part2);
                    break;
                }
                case 8: {
                    matches = input.startsWith(this.part1) && input.endsWith(this.part2);
                    break;
                }
                case 16: {
                    matches = input.indexOf(this.part1) >= 0;
                    break;
                }
                case 32: {
                    if (input.startsWith(this.part1) && input.length() >= this.part12len) {
                        matches = input.indexOf(this.part2, this.part1len) >= 0;
                        break;
                    }
                    matches = false;
                    break;
                }
                case 64: {
                    if (input.endsWith(this.part2) && input.length() >= this.part12len) {
                        int idx = input.indexOf(this.part1);
                        int startOfEndPart = input.length() - this.part2len;
                        matches = idx >= 0 && idx + this.part1len <= startOfEndPart;
                        break;
                    }
                    matches = false;
                    break;
                }
                case 128: {
                    if (input.startsWith(this.part1) && input.endsWith(this.part3) && input.length() >= this.part123len) {
                        int idx = input.indexOf(this.part2);
                        int startOfEndPart = input.length() - this.part3len;
                        matches = idx >= 0 && idx >= this.part1len && idx <= startOfEndPart;
                        break;
                    }
                    matches = false;
                }
            }
        }
        return matches;
    }

    public boolean isValid() {
        return this.validName;
    }

    public boolean isGeneric() {
        return this.patternType != 0;
    }

    public boolean isQuoted() {
        return this.quotedName;
    }

    public int getPatternType() {
        return this.patternType;
    }

    private static int countOccurrencesOf(String haystack, char needle) {
        int count = 0;
        int idx = 0;
        while (idx < haystack.length()) {
            if (haystack.charAt(idx) == needle) {
                ++count;
            }
            ++idx;
        }
        return count;
    }

    public String toString() {
        return this.genericName;
    }

    public void writeInfo(PrintWriter stream) {
        stream.println("GENERIC NAME: " + this.genericName);
        stream.println(" isValid: " + this.isValid());
        stream.println(" isGeneric: " + this.isGeneric());
        stream.println(" isQuoted: " + this.isQuoted());
        int type = this.getPatternType();
        int typeidx = 0;
        boolean match = false;
        int idx = 0;
        while (!match && idx < TYPES_IDX.length) {
            if (type == TYPES_IDX[idx]) {
                typeidx = idx;
                match = true;
            }
            ++idx;
        }
        stream.println(" patternType: " + TYPES[typeidx]);
        if (this.part1 != null) {
            stream.println(" part1: " + this.part1);
        }
        if (this.part2 != null) {
            stream.println(" part2: " + this.part2);
        }
        if (this.part3 != null) {
            stream.println(" part3: " + this.part3);
        }
        stream.println();
        stream.flush();
    }

    public static boolean verifyPattern(String genericName, boolean advanced) {
        boolean quotedName;
        if (genericName == null) {
            return false;
        }
        genericName = genericName.trim();
        if (genericName.length() == 0) {
            return false;
        }
        int len = genericName.length();
        boolean bl = quotedName = genericName.charAt(0) == '\"';
        if (quotedName && (len == 1 || genericName.charAt(len - 1) != '\"')) {
            return false;
        }
        int wildcardOccurrences = NamePatternMatcher.countOccurrencesOf(genericName, '*');
        if (wildcardOccurrences == 2) {
            char firstChar = genericName.charAt(quotedName ? 1 : 0);
            char lastChar = genericName.charAt(quotedName ? len - 2 : len - 1);
            if (!advanced && lastChar != '*' && firstChar != '*') {
                return false;
            }
            if (genericName.indexOf(WILDCARD_DOUBLED) >= 0) {
                return false;
            }
        } else if (wildcardOccurrences > 2) {
            return false;
        }
        return true;
    }
}

